<?php
$pagina = 8;
define('PERMITIDO', true);
require_once("../inc/init.php");
require_once("../inc/config.ui.php");

$codExamen = isset($_GET['codExamen']) ? $_GET['codExamen'] : "-1";
$idEmpresa = isset($_GET['idEmpresa']) ? $_GET['idEmpresa'] : "-1";

$query = $mysqli->prepare("SELECT NOMBRE
FROM examenes
WHERE COD_INTERNO = ?
LIMIT 1");
$query->bind_param("s", $codExamen);
$query->execute();
$query->bind_result($nombreExamen);
$query->store_result();
$query->fetch();
$query->close();

$stmt = $mysqli->prepare("SELECT pe.ID_PEX, pe.COD_EXAMEN, pe.PRECIO,
DATE_FORMAT(pe.FECHA_INICIO,'%d/%m/%Y %H:%i:%s') AS fechaCreacionPrecio,
CONCAT(DATE_FORMAT(cpe.FECHA,'%d/%m/%Y'), ' ', cpe.HORA) AS fechaCargaArchivo,
CONCAT_WS(' ', u.NOMBRES, u.APELLIDO_PATERNO, u.APELLIDO_MATERNO) AS usuarioCreadorPrecio,
CONCAT_WS(' ', u2.NOMBRES, u2.APELLIDO_PATERNO, u2.APELLIDO_MATERNO) AS usuarioCargadorArchivo
FROM precios_examenes pe
INNER JOIN examenes e ON pe.COD_EXAMEN = e.COD_INTERNO
LEFT JOIN cargas_precios_examenes cpe ON cpe.ID_CARGA_PRECIOS_EXAMENES = pe.ID_CARGA_PRECIOS_EXAMENES
LEFT JOIN usuarios u ON u.ID_USUARIO = pe.ID_USUARIO_CREADOR
LEFT JOIN usuarios u2 ON u2.ID_USUARIO = cpe.ID_USUARIO
WHERE pe.COD_EXAMEN = ? AND pe.ID_EMPRESA = ?
ORDER BY pe.ID_PEX DESC");
$stmt->bind_param("si", $codExamen, $idEmpresa);
$stmt->execute();
$result = $stmt->get_result();
$num_rows = $result->num_rows;
$rows = $result->fetch_all(MYSQLI_ASSOC); // Fetching all rows into an associative array
$result->free(); // Freeing result 
$stmt->close(); // Closing statement


ob_start();
?>

<div class="modal-header">
    <button type="button" class="close" data-dismiss="modal" aria-hidden="true">
        &times;
    </button>
    <h4 class="modal-title" id="myModalLabel">Historial de precios de examen </h4>
</div>

<div class="modal-body">
    <p class="font-md">Código examen: <?= $codExamen ?></p>
    <p class="font-md">Nombre examen: <?= $nombreExamen ?></p>
    <div class="table-responsive">
        <table id="dataTable-historialPrecios" class="table table-bordered table-hover">
            <thead>
                <tr>
                    <th>Precio examen</th>
                    <th>Fecha creación precio</th>
                    <th>Usuario creador</th>
                    <th>Fecha carga de archivo</th>
                    <th>Usuario cargador de archivo</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach($rows as $row) { ?>
                    <tr>
                        <td>$ <?= number_format($row["PRECIO"], '0', ',', '.') ?></td>
                        <td><?= $row["fechaCreacionPrecio"] ? $row["fechaCreacionPrecio"] : "-" ?></td>
                        <td><?= $row["usuarioCreadorPrecio"] ? $row["usuarioCreadorPrecio"] : "-" ?></td>
                        <td><?= $row["fechaCargaArchivo"] ? $row["fechaCargaArchivo"] : "-"?></td>
                        <td><?= $row["usuarioCargadorArchivo"] ? $row["usuarioCargadorArchivo"] : "-"?></td>
                    </tr>
                <?php } ?>
            </tbody>
        </table>
    </div>
</div>

<div class="modal-footer">
    <button type="button" class="btn btn-default" data-dismiss="modal">
        Cancelar
    </button>
    <!-- <button class="btn btn-primary btn-modificarPrecioExamen pull-right" data-form="#formModificarPrecioExamen"> <i class="fa fa-save"></i> Grabar </button> -->
</div>

<script>
    $(document).ready(function() {
    });
</script>