<?php
define('PERMITIDO', true);
# $pagina = 34;
require_once("../inc/init.php");
require_once '../assets/php/PHPExcel.php';

date_default_timezone_set("America/Santiago");

/** Error reporting */
error_reporting(E_ALL);
ini_set('display_errors', true);
ini_set('display_startup_errors', true);

if (PHP_SAPI == 'cli') die('This file should only be run from a Web Browser');

$objPHPExcel = new PHPExcel();
$objPHPExcel->getProperties()->setCreator('RIPIT')->setTitle('Reporte');
$objPHPExcel->setActiveSheetIndex(0);

$idEmpresa = isset($_GET['idEmpresa']) ? $_GET['idEmpresa'] : "-1";

$qEmpresas = $mysqli->prepare("SELECT NOMBRE_E, NBR FROM empresas WHERE ID_EMPRESA = ?");
$qEmpresas->bind_param("i", $idEmpresa);
$qEmpresas->execute();
$qEmpresas->bind_result($nombreEmpresa, $nbrEmpresa);
$qEmpresas->store_result();
$qEmpresas->fetch();
$qEmpresas->close();

$stmt = $mysqli->prepare("SELECT pe.COD_EXAMEN, pe.PRECIO, DATE_FORMAT(pe.FECHA_INICIO,'%d/%m/%Y %H:%i:%s') AS FECHA_INICIO,
e.NOMBRE, e.NOMBRE_INF, e.COD_FONASA, e.NRO_HOJA_TRABAJO
FROM precios_examenes pe
INNER JOIN examenes e ON pe.COD_EXAMEN = e.COD_INTERNO
INNER JOIN (
  SELECT COD_EXAMEN, MAX(ID_PEX) AS MAX_ID_PEX
  FROM precios_examenes
  WHERE ID_EMPRESA = ?
  GROUP BY COD_EXAMEN
) max_pe ON pe.COD_EXAMEN = max_pe.COD_EXAMEN AND pe.ID_PEX = max_pe.MAX_ID_PEX
WHERE pe.ID_EMPRESA = ?
ORDER BY e.NOMBRE ASC");
$stmt->bind_param("ii", $idEmpresa, $idEmpresa);
$stmt->execute();
$result = $stmt->get_result();
$num_rows = $result->num_rows;
$rows = $result->fetch_all(MYSQLI_ASSOC); // Fetching all rows into an associative array
$result->free(); // Freeing result 
$stmt->close(); // Closing statement

$columnasInicio = 'A';
$columnasFin = 'E';

$objPHPExcel->getActiveSheet()
->setCellValue('A1', 'Código interno')
	->setCellValue('B1', 'Nombre examen')
	->setCellValue('C1', 'Código Fonasa')
	->setCellValue('D1', '')
	->setCellValue('E1', 'Precio ($)');

$f = 2;

foreach ($rows as $row) {
	$columnaNombre = $row["NOMBRE_INF"] != "" ? $row["NOMBRE_INF"] : $row["NOMBRE"];
	$columnaCodFonasa = $row["COD_FONASA"] != "" ? $row["COD_FONASA"] : "PARTICULAR";
	$esDerivacion = $row["NRO_HOJA_TRABAJO"] == 4 ? "(Derivación)" : "";
	$precioExamen = $row["PRECIO"];

	$objPHPExcel->getActiveSheet()->setCellValue('A' . $f, $row["COD_EXAMEN"]);
	$objPHPExcel->getActiveSheet()->setCellValue('B' . $f, $columnaNombre);
	$objPHPExcel->getActiveSheet()->setCellValue('C' . $f, $columnaCodFonasa);
	$objPHPExcel->getActiveSheet()->setCellValue('D' . $f, $esDerivacion);
	$objPHPExcel->getActiveSheet()->setCellValue('E' . $f, $precioExamen);
	$f++;
}

// Establecer tamaño automático de las columnas
for ($letra = $columnasInicio; $letra <= $columnasFin; $letra++) {
	$objPHPExcel->getActiveSheet()->getColumnDimension($letra)->setAutoSize(true);
}

header('Content-Disposition: attachment;filename="Precios de exámenes de ' . $nbrEmpresa . '.xlsx"');
$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
$objWriter->save('php://output');

die();
