<?php
$pagina = 21;
define('PERMITIDO', true);
require_once("../inc/init.php");

function procesarArchivoCSV($archivo)
{
    // Verificar si se ha enviado un archivo
    if (!isset($archivo["archivo_csv"])) {
        return ["status" => false, "message" => "Error: No se recibió ningún archivo."];
    }

    $archivo_csv = $archivo["archivo_csv"];

    // Verificar si hay errores al subir el archivo
    if ($archivo_csv["error"] != 0) {
        return ["status" => false, "message" => "Error al subir el archivo: " . $archivo_csv["error"]];
    }

    // Verificar la extensión del archivo
    $extension = pathinfo($archivo_csv["name"], PATHINFO_EXTENSION);
    if ($extension != "csv") {
        return ["status" => false, "message" => "Error: El archivo debe tener extensión .csv"];
    }

    $ruta_temporal = $archivo_csv["tmp_name"];

    // Mover el archivo temporal a la ruta de destino
    $nombre_archivo = uniqid() . "_" . $archivo_csv["name"]; // Generar un nombre único para el archivo
    $ruta_destino_completa = "../HISTORIAL_PRECIOS/" . $nombre_archivo;

    if (!move_uploaded_file($ruta_temporal, $ruta_destino_completa)) {
        return ["status" => false, "message" => "Error al mover el archivo al servidor."];
    }

    return ["status" => true, "message" => "El archivo se subió correctamente.", "ruta_destino_completa" => $ruta_destino_completa];
}

echo json_encode(procesarArchivoCSV($_FILES));
