<?php
// require_once '../Connections/conexionlab.php';
define('PERMITIDO', true);
require_once "../inc/init.php";
require_once '../assets/php/php/php-barcode.php';
require_once '../assets/php/php/fpdf.php';

// if (!(isset($_GET['fch']) && isset($_GET['idp']))) {
// 	die();
// }

$qAtencionesHoja = $mysqli->prepare("SELECT a.ID_ATENCION, DATE_FORMAT(a.FECHA,'%d-%m-%y'), cc.NOMBRE, 
pa.NOMBRES, pa.APELLIDO_PATERNO, pa.APELLIDO_MATERNO, cg2.DESCRIPCION_CG
FROM atenciones a
LEFT JOIN centros_contacto cc ON cc.ID_CENTRO_CONTACTO = a.ID_CENTRO_CONTACTO
LEFT JOIN personas pa ON pa.ID_PERSONA = a.ID_CLIENTE
LEFT JOIN codigos_generales cg2 ON cg2.CODIGO = a.TURNO_DIALISIS AND cg2.COD_TABLA = 'SIS_TURDIA'
WHERE a.ID_HOJA_TRANSPORTE = ? AND a.FLAG_ELIMINADO = 0
ORDER BY a.ID_ATENCION");
$qAtencionesHoja->bind_param('i', $_GET['idht']);
$qAtencionesHoja->execute();
$qAtencionesHoja->bind_result($a_idAtencion, $a_fechaAtencion, $a_procedenciaAtencion, 
$a_nombrePaciente, $a_apellidoPaternoPaciente, $a_apellidoMaternoPaciente, $a_turnoDialisis);
$qAtencionesHoja->store_result();
$num_rows = $qAtencionesHoja->num_rows;

class eFPDF extends FPDF {
	function TextWithRotation($x, $y, $txt, $txt_angle, $font_angle=0) {
		$font_angle += 90 + $txt_angle;
		$txt_angle *= M_PI / 180;
		$font_angle *= M_PI / 180;

		$txt_dx = cos($txt_angle);
		$txt_dy = sin($txt_angle);
		$font_dx = cos($font_angle);
		$font_dy = sin($font_angle);

		$s = sprintf('BT %.2F %.2F %.2F %.2F %.2F %.2F Tm (%s) Tj ET', $txt_dx, $txt_dy, $font_dx, $font_dy, $x * $this->k,($this->h-$y) * $this->k, $this->_escape($txt));
		if ($this->ColorFlag)
			$s = 'q ' . $this->TextColor . ' ' . $s . ' Q';
		$this->_out($s);
	}
}

$pdf = new eFPDF('P', 'pt', 'barras');

if ($num_rows == 0) {
	echo "No existen atenciones asociadas a la fecha y plantilla seleccionadas.";
	die();
}

while($qAtencionesHoja->fetch()) {

  $qTiposTuboAtecion = $mysqli->prepare("SELECT ea.TIPO_TUBO, cg.DESCRIPCION_CG
	FROM examenes_atenciones ea
	INNER JOIN examenes ex ON ea.COD_EXAMEN=ex.COD_INTERNO
	LEFT JOIN codigos_generales cg ON ea.TIPO_TUBO=cg.CODIGO
	WHERE ea.ID_ATENCION = ? AND cg.COD_TABLA='SIS_TIPTUB' AND ea.TIPO_TUBO!='17'
	GROUP BY ea.TIPO_TUBO");
  $qTiposTuboAtecion->bind_param('i', $a_idAtencion);
  $qTiposTuboAtecion->execute();
  $qTiposTuboAtecion->bind_result($ea_tipoTubo, $ea_descTipoTubo);
  $qTiposTuboAtecion->store_result();
	
	while($qTiposTuboAtecion->fetch()) {
		$fontSize = 9;
		$marge    = 5;   // between barcode and hri in pixel
		$x        = 40;  // barcode center
		$y        = 70;  // barcode center
		$height   = 30;  // barcode height in 1D ; module size in 2D
		$width    = 1;   // barcode height in 1D ; not use in 2D
		$angle    = 90;  // rotation in degrees

		$code     = $a_idAtencion . "-"  .$ea_tipoTubo; // barcode, of course ;).... con el id de la muestra: atencion-tipotubo
		$type     = 'code128';
		$black    = '000000'; // color in hexa

		$nombre_c = explode(' ', trim($a_nombrePaciente));
		$nombre = utf8_decode($nombre_c[0]);
		$paciente = substr(utf8_decode($nombre . " " . $a_apellidoPaternoPaciente . " " . $a_apellidoMaternoPaciente), 0, 25);
		
    $tipotubo = $a_idAtencion . ' - ' . utf8_decode($ea_descTipoTubo);
		$procedencia = utf8_decode($a_procedenciaAtencion);
		$fechaTurno = $a_fechaAtencion;
		if ($a_turnoDialisis != '') $fechaTurno .= '  ' . $a_turnoDialisis;
		$lab = "Laboratorio Etcheverry";

    $s_letra = 8;

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		$pdf->AddPage();
		$data = Barcode::fpdf($pdf, $black, $x, $y, $angle, $type, array('code' => $code), $width, $height);

		$pdf->SetFont('Arial', '', $s_letra);
		$pdf->SetTextColor(0, 0, 0);
		
		$len_t = $pdf->GetStringWidth($tipotubo);
		Barcode::rotate(-$len_t / 2, -($data['height'] / 2) - $s_letra, $angle, $xt, $yt);
		$pdf->TextWithRotation($x + $xt - 2, $y + $yt, $tipotubo, $angle);

		$len_st = $pdf->GetStringWidth($procedencia);
		Barcode::rotate(-$len_st / 2, -($data['height'] / 2) - $s_letra, $angle, $xt, $yt);
		$pdf->TextWithRotation($x + $xt + 6, $y + $yt, $procedencia, $angle);

		$len = $pdf->GetStringWidth($paciente);
		Barcode::rotate(-$len / 2, ($data['height'] / 2) + $s_letra + $marge, $angle, $xt, $yt);
		$pdf->TextWithRotation($x + $xt, $y + $yt, $paciente, $angle);

		$len_f = $pdf->GetStringWidth($fechaTurno);
		Barcode::rotate(-$len_f / 2, ($data['height'] / 2) + $s_letra + $marge, $angle, $xt, $yt);
		$pdf->TextWithRotation($x + $xt + 8, $y + $yt, $fechaTurno, $angle);
	}
}

$pdf->Output();

?>
