<?php
define('PERMITIDO', true);
# $pagina = 34;
require_once("../inc/init.php");
require_once '../assets/php/PHPExcel.php';

date_default_timezone_set("America/Santiago");

/** Error reporting */
error_reporting(E_ALL);
ini_set('display_errors', true);
ini_set('display_startup_errors', true);

if (PHP_SAPI == 'cli') die('This file should only be run from a Web Browser');

$objPHPExcel = new PHPExcel();
$objPHPExcel->getProperties()->setCreator('RIPIT')->setTitle('Reporte');
$objPHPExcel->setActiveSheetIndex(0);

$stmt = $mysqli->prepare("SELECT e.COD_INTERNO, IF(NOMBRE_INF != '', NOMBRE_INF, NOMBRE) AS NOMBRE, e.COD_FONASA, e.HORAS_PROCESO, cg.DESCRIPCION_CG AS tipoTubo, 
cg2.DESCRIPCION_CG AS tipoMuestra, cg3.DESCRIPCION_CG AS PREPARACION, IFNULL(cg4.DESCRIPCION_CG, 'Sin instrucciones') AS ARCH_INSTRUCCIONES, cg5.DESCRIPCION_CG AS AREA_TRABAJO,cg6.DESCRIPCION_CG as UNIDAD_MEDIDA
FROM examenes e
LEFT JOIN codigos_generales cg  ON e.TIPO_TUBO = cg.CODIGO  AND cg.COD_TABLA  = 'SIS_TIPTUB'
LEFT JOIN codigos_generales cg2 ON e.TIPO_MUESTRA = cg2.CODIGO AND cg2.COD_TABLA = 'SIS_TIPMUE'
LEFT JOIN codigos_generales cg3 ON e.PREPARACION = cg3.CODIGO AND cg3.COD_TABLA = 'SIS_PREPAR'
LEFT JOIN codigos_generales cg4 ON e.ARCH_INSTRUCCIONES = cg4.CODIGO AND cg4.COD_TABLA = 'SIS_ARCINS'
LEFT JOIN codigos_generales cg5 ON e.NRO_HOJA_TRABAJO = cg5.CODIGO AND cg5.COD_TABLA = 'SIS_AREAS'
LEFT JOIN codigos_generales cg6 ON e.UNIDAD_MEDIDA = cg6.CODIGO AND cg6.COD_TABLA = 'SIS_UNIMED'
WHERE 1
AND COD_FONASA IS NOT NULL
AND COD_FONASA !=''
AND e.FLAG_ELIMINADO IS NULL
ORDER BY IF(NOMBRE_INF != '', TRIM(NOMBRE_INF), NOMBRE) ASC");
$stmt->execute();
$result = $stmt->get_result();
$num_rows = $result->num_rows;
$rows = $result->fetch_all(MYSQLI_ASSOC); // Fetching all rows into an associative array
$result->free(); // Freeing result 
$stmt->close(); // Closing statement


$columnasInicio = 'A';
$columnasFin = 'I';

$objPHPExcel->getActiveSheet()
  ->setCellValue('A1', 'Código interno')
  ->setCellValue('B1', 'Nombre examen')
  ->setCellValue('C1', 'Código fonasa')
  ->setCellValue('D1', 'Área de trabajo')
  ->setCellValue('E1', 'Tipo de tubo')
  ->setCellValue('F1', 'Tipo de muestra')
  ->setCellValue('G1', 'Horas')
  ->setCellValue('H1', 'Preparación')
  ->setCellValue('I1', 'Unidad de medida');

$f = 2;
foreach ($rows as $row) {
  $objPHPExcel->getActiveSheet()->setCellValue('A' . $f, $row['COD_INTERNO']);
  $objPHPExcel->getActiveSheet()->setCellValue('B' . $f, $row['NOMBRE']);
  $objPHPExcel->getActiveSheet()->setCellValue('C' . $f, $row['COD_FONASA']);
  $objPHPExcel->getActiveSheet()->setCellValue('D' . $f, $row['AREA_TRABAJO']);
  $objPHPExcel->getActiveSheet()->setCellValue('E' . $f, $row['tipoTubo']);
  $objPHPExcel->getActiveSheet()->setCellValue('F' . $f, $row['tipoMuestra']);
  $objPHPExcel->getActiveSheet()->setCellValue('G' . $f, $row['HORAS_PROCESO']);
  $objPHPExcel->getActiveSheet()->setCellValue('H' . $f, $row['ARCH_INSTRUCCIONES']);
  $objPHPExcel->getActiveSheet()->setCellValue('I' . $f, $row['UNIDAD_MEDIDA']);
  $f++;
}

// Establecer tamaño automático de las columnas
for ($letra = $columnasInicio; $letra <= $columnasFin; $letra++) {
  $objPHPExcel->getActiveSheet()->getColumnDimension($letra)->setAutoSize(true);
}

header('Content-Disposition: attachment;filename="Consulta de exámenes ' . date("YmdHis") . '.xlsx"');
$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
$objWriter->save('php://output');

die();
