<?php
# $pagina = 24;
define('PERMITIDO', true);
require_once("../inc/init.php");
include('../pdfClasses/class.ezpdf.php');

$pdf = new Cezpdf('LETTER');
$pdf->selectFont('../pdfClasses/fonts/Helvetica.afm');
$pdf->ezStartPageNumbers(330, 18, 10, '', 'Página {PAGENUM} de {TOTALPAGENUM}', 1);
$pdf->ezSetCmMargins(1, 1.5, 1, 1);

$stmt = $mysqli->prepare("SELECT e.COD_INTERNO, IF(NOMBRE_INF != '', NOMBRE_INF, NOMBRE) AS NOMBRE, e.COD_FONASA, e.HORAS_PROCESO, cg.DESCRIPCION_CG AS tipoTubo, 
cg2.DESCRIPCION_CG AS tipoMuestra, cg3.DESCRIPCION_CG AS PREPARACION, IFNULL(cg4.DESCRIPCION_CG, 'Sin instrucciones') AS ARCH_INSTRUCCIONES, cg5.DESCRIPCION_CG AS AREA_TRABAJO,cg6.DESCRIPCION_CG as UNIDAD_MEDIDA
FROM examenes e
LEFT JOIN codigos_generales cg  ON e.TIPO_TUBO = cg.CODIGO  AND cg.COD_TABLA  = 'SIS_TIPTUB'
LEFT JOIN codigos_generales cg2 ON e.TIPO_MUESTRA = cg2.CODIGO AND cg2.COD_TABLA = 'SIS_TIPMUE'
LEFT JOIN codigos_generales cg3 ON e.PREPARACION = cg3.CODIGO AND cg3.COD_TABLA = 'SIS_PREPAR'
LEFT JOIN codigos_generales cg4 ON e.ARCH_INSTRUCCIONES = cg4.CODIGO AND cg4.COD_TABLA = 'SIS_ARCINS'
LEFT JOIN codigos_generales cg5 ON e.NRO_HOJA_TRABAJO = cg5.CODIGO AND cg5.COD_TABLA = 'SIS_AREAS'
LEFT JOIN codigos_generales cg6 ON e.UNIDAD_MEDIDA = cg6.CODIGO AND cg6.COD_TABLA = 'SIS_UNIMED'
WHERE 1
AND COD_FONASA IS NOT NULL
AND COD_FONASA !=''
AND e.FLAG_ELIMINADO IS NULL
ORDER BY IF(NOMBRE_INF != '', TRIM(NOMBRE_INF), NOMBRE) ASC");
$stmt->execute();
$result = $stmt->get_result();
$num_rows = $result->num_rows;
$rows = $result->fetch_all(MYSQLI_ASSOC); // Fetching all rows into an associative array
$result->free(); // Freeing result 
$stmt->close(); // Closing statement

$data = array();
foreach ($rows as $row) {
  $cod_int = $row['COD_INTERNO'];
  $nombre = $row['NOMBRE'];
  $fonasa = $row['COD_FONASA'];
  $tipo_tubo = $row['tipoTubo'];
  $tipo_mu = $row['tipoMuestra'];
  $horas = $row['HORAS_PROCESO'];
  $instrucciones = $row['ARCH_INSTRUCCIONES'];
  $data[] = array(
    'CODI' => $cod_int,
    'NOM' => $nombre,
    'FONASA' => $fonasa,
    'T_TUBO' => $tipo_tubo,
    'T_MU' => $tipo_mu,
    'HRS' => $horas,
    'PREP' => $instrucciones
  );
}

$titles = array(
  'CODI' => '<b>C. Interno</b>',
  'NOM' => '<b>Examen</b>',
  'FONASA' => '<b>C. Fonasa</b>',
  'T_TUBO' => '<b>Tipo de Tubo</b>',
  'T_MU' => '<b>Tipo de Muestra</b>',
  'HRS' => '<b>Hrs</b>',
  'PREP' => '<b>Preparación</b>'
);

$options = array(
  'shadeCol' => array(0.9, 0.9, 0.9),
  'showLines' => 1,
  'xOrientation' => 'center',
  'width' => 570,
  'fontSize' => 7,
  'cols' => array(
    'CODI' => array('justification' => 'left', 'width' => 45),
    'NOM' => array('justification' => 'left', 'width' => 180),
    'FONASA' => array('justification' => 'left', 'width' => 55),
    'T_TUBO' => array('justification' => 'left'),
    'T_MU' => array('justification' => 'left', 'width' => 90),
    'HRS' => array('justification' => 'center'),
    'PREP' => array('justification' => 'center', 'width' => 70)
  )
);

// IMPRIMIR RESULTADOS
$logo_empresa = imagecreatefrompng('../assets/img/logo_empresa_informes.png');
$pdf->addImage($logo_empresa, 30, 730, null, 50);
$pdf->ezText("\n\n\n", 10);
$pdf->ezText("LISTADO DE EXAMENES\n", 10);
$pdf->ezTable($data, $titles, '', $options);

ob_end_clean();
$pdf->ezStream();
