<?php
$pantalla_actual = 'CON_EXA';
define('PERMITIDO', true);
require_once("../inc/init.php");
require_once("../inc/config.ui.php");
$page_title = $datos_pantallas[$pantalla_actual]['page_title'];
$page_css[] = "your_style.css";
include("../inc/header.php");
include("../inc/nav.php");

if (isset($_GET['ex'])) {
  $id = $_GET['ex'];
  $filtro = "AND (e.COD_INTERNO LIKE '%$id%' OR e.NOMBRE LIKE '%$id%')";
}

$stmt = $mysqli->prepare("SELECT e.COD_INTERNO, IF(NOMBRE_INF != '', NOMBRE_INF, NOMBRE) AS NOMBRE, e.COD_FONASA,
e.HORAS_PROCESO, cg.DESCRIPCION_CG AS tipoTubo, cg2.DESCRIPCION_CG AS tipoMuestra, cg3.DESCRIPCION_CG AS PREPARACION,
IFNULL(cg4.DESCRIPCION_CG, 'Sin instrucciones') AS ARCH_INSTRUCCIONES, cg5.DESCRIPCION_CG AS AREA_TRABAJO, e.OBS
FROM examenes e
LEFT JOIN codigos_generales cg  ON e.TIPO_TUBO = cg.CODIGO  AND cg.COD_TABLA  = 'SIS_TIPTUB'
LEFT JOIN codigos_generales cg2 ON e.TIPO_MUESTRA = cg2.CODIGO AND cg2.COD_TABLA = 'SIS_TIPMUE'
LEFT JOIN codigos_generales cg3 ON e.PREPARACION = cg3.CODIGO AND cg3.COD_TABLA = 'SIS_PREPAR'
LEFT JOIN codigos_generales cg4 ON e.ARCH_INSTRUCCIONES = cg4.CODIGO AND cg4.COD_TABLA = 'SIS_ARCINS'
LEFT JOIN codigos_generales cg5 ON e.NRO_HOJA_TRABAJO = cg5.CODIGO AND cg5.COD_TABLA = 'SIS_AREAS'
WHERE 1 
AND COD_FONASA IS NOT NULL
AND COD_FONASA != ''
AND e.FLAG_ELIMINADO IS NULL $filtro
ORDER BY IF(NOMBRE_INF != '', TRIM(NOMBRE_INF), NOMBRE) ASC");
$stmt->execute();
$resultado = $stmt->get_result();
$datos = $resultado->fetch_all(MYSQLI_ASSOC);

ob_start();
?>

<table class="table table-responsive">
  <tr>
    <td align="right">
      <a href="consultaExamenes_excel.php" class="btn btn-link"> <i class="fa fa-file-excel-o"></i> Exportar Excel</a>
      <a href="consultaExamenes_pdf.php" class="btn btn-link" target="_blank"><i class="fa fa-file-pdf-o"> </i> Exportar PDF </a>
    </td>
  </tr>
</table>

<table id="dataTable" class="table table-bordered table-hover">
  <thead>
    <tr>
      <th>Cód. Interno</th>
      <th>Nombre</th>
      <th>Cód. FONASA</th>
      <th>Area Trabajo</th>
      <th>Tipo de Tubo</th>
      <th>Tipo Muestra</th>
      <th>Horas</th>
      <th>Preparación</th>
      <th>Instrucciones</th>
      <th>Obs</th>
    </tr>
  </thead>
  <tbody>
    <?php foreach ($datos as $dato) {
      if ($dato['OBS'] != '') {
        $obs = $dato['OBS'];
      } else {
        $obs = 'Sin Observaciones';
      }
    ?>
      <tr>
        <td><?= $dato['COD_INTERNO'] ?></td>
        <td><?= $dato['NOMBRE'] ?></td>
        <td><?= $dato['COD_FONASA'] ?></td>
        <td><?= $dato['AREA_TRABAJO'] ?></td>
        <td><?= $dato['tipoTubo'] ?></td>
        <td><?= $dato['tipoMuestra'] ?></td>
        <td><?= $dato['HORAS_PROCESO'] ?></td>
        <td><?= $dato['PREPARACION'] ?></td>
        <td><?= $dato['ARCH_INSTRUCCIONES'] ?></td>
        <td><span class="fa fa-comment-o" rel="popover-hover" data-placement="left" data-original-title="Observaciones" data-content="<?= $obs ?>"></span></td>
      </tr>
    <?php } ?>
  </tbody>
</table>

<?php
$contenido = ob_get_contents();
ob_end_clean();

$ui = new SmartUI;
$options = array("editbutton" => false);
$widget = $ui->create_widget($options);

$widget->header = array(
  "title" => $datos_pantallas[$pantalla_actual]['body_title'],
  "icon" => 'fa fa-cog',
  'toolbar' => array(
    array(
      "id" => "toolbar-id",
      "content" => '<a href="#"  data-toggle="modal" data-target="#myModalNew"></a>',
      "class" => 'smart-form'
    )
  )
);
$widget->body('content', $contenido);
?>

<div id="main" role="main">
  <?php
  include("../inc/ribbon.php");
  ?>

  <div id="content">
    <?php
    $widget->print_html();
    ?>
  </div>

</div>

<?php
include("../inc/footer.php");
include("../inc/scripts.php");
?>

<script>
  $(document).ready(function() {
    $('#dataTable').DataTable({
      'lengthMenu': [
        [50, 100, 200],
        [50, 100, 200]
      ],
      'language': {
        "sProcessing": "Procesando...",
        "sZeroRecords": "No se encontraron resultados",
        "sInfoPostFix": "",
        "sUrl": "",
        "oPaginate": {
          "sFirst": "Primero",
          "sPrevious": "Anterior",
          "sNext": "Siguiente",
          "sLast": "Último"
        },
        "sInfo": "_START_ a _END_ de _TOTAL_ Registros",
        "sInfoEmpty": "0 Registros",
        "sInfoFiltered": "(de _MAX_ Registros en total)",
        "sLengthMenu": "Mostrar _MENU_ Registros",
        "sSearch": "Buscar: "
      },
      'pageLength': 50,
      'order': [0, "asc"],
      'columnDefs': [{
          'orderable': false,
          'targets': [9]
        } // Aquí especifica las columnas que no son ordenables
      ],
      'destroy': true
    });
  });
</script>

<?php
include("../inc/google-analytics.php");
?>