<?php
define('PERMITIDO', true);
$pantalla_actual = 'LIS_CEN_TOM_MUE';

require_once("../inc/init.php");
require_once("../inc/config.ui.php");
$page_title = $datos_pantallas[$pantalla_actual]['page_title'];
$page_css[] = "your_style.css";
include("../inc/header.php");
include("../inc/nav.php");

$idEmpresa = $_GET['idem'] ? $_GET['idem'] : "-1";

$stmt = $mysqli->prepare("SELECT * FROM empresas WHERE ID_EMPRESA = ?");
$stmt->bind_param("i", $idEmpresa);
$stmt->execute();
$resultado = $stmt->get_result();
$datos_empresa = $resultado->fetch_array(MYSQLI_ASSOC);

$stmt = $mysqli->prepare("SELECT * FROM centros_contacto WHERE ID_EMPRESA = ?");
$stmt->bind_param("i", $idEmpresa);
$stmt->execute();
$resultado = $stmt->get_result();
$datos_centrosContactoEmpresa = $resultado->fetch_all(MYSQLI_ASSOC);

ob_start();
?>

<p class="font-md"><?= $datos_empresa['NOMBRE_E'] ?></p>

<table id="dataTable" class="table table-bordered table-hover">
  <thead>
    <tr>
      <th>Nro.</th>
      <th>Nombre</th>
      <th>Muestra</th>
      <th>Laboratorio</th>
      <th>Centro de Diálisis</th>
      <th>Modificar</th>
    </tr>
  </thead>
  <tbody>
    <?php foreach ($datos_centrosContactoEmpresa as $data) { ?>
      <tr>
        <td><?= $data['NRO_CENTRO']; ?></td>
        <td><?= $data['NOMBRE']; ?></td>
        <td><?= $data['FLAG_MUESTRA'] == "S" ? "Si" : "No"; ?></td>
        <td><?= $data['FLAG_LABORATORIO'] == "S" ? "Si" : "No"; ?></td>
        <td><?= $data['FLAG_DIALISIS'] == "S" ? "Si" : "No"; ?></td>
        <td align="center">
          <a href="e_centro.php?idcc=<?= $data['ID_CENTRO_CONTACTO']; ?>&amp;idem=<?= $data['ID_EMPRESA'] ?>"><i class="fa fa-edit fa-lg"></i></a>
        </td>
      </tr>
    <?php } ?>
  </tbody>
</table>
<?php
$contenido = ob_get_contents();
ob_end_clean();

$ui = new SmartUI;
$options = array("editbutton" => false);
$widget = $ui->create_widget($options);

$widget->header = array(
  "title" => $datos_pantallas[$pantalla_actual]['body_title'],
  "icon" => 'fa fa-cog',
  'toolbar' => array(
    array(
      "id" => "toolbar-id",
      "content" => '<a href="n_centro.php?idem=' . $_GET['idem'] . '" class="btn btn-success"><i class="fa fa-plus"></i> Agregar</a>',
      "class" => 'smart-form'
    )
  )

);
$widget->body('content', $contenido);
?>

<div id="main" role="main">
  <?php include("../inc/ribbon.php");  ?>

  <div id="content">

    <?php
    $widget->print_html();
    ?>

  </div>
</div>

<?php
include("../inc/footer.php");
include("../inc/scripts.php");
?>

<!-- PAGE RELATED PLUGIN(S) 
<script src="<?= ASSETS_URL; ?>/js/plugin/YOURJS.js"></script>-->

<script>
  $(document).ready(function() {
    $('#dataTable').DataTable({
      'lengthMenu': [
        [50, 100, 200],
        [50, 100, 200]
      ],
      'language': {
        "sProcessing": "Procesando...",
        "sZeroRecords": "No se encontraron resultados",
        "sInfoPostFix": "",
        "sUrl": "",
        "oPaginate": {
          "sFirst": "Primero",
          "sPrevious": "Anterior",
          "sNext": "Siguiente",
          "sLast": "Último"
        },
        "sInfo": "_START_ a _END_ de _TOTAL_ Registros",
        "sInfoEmpty": "0 Registros",
        "sInfoFiltered": "(de _MAX_ Registros en total)",
        "sLengthMenu": "Mostrar _MENU_ Registros",
        "sSearch": "Buscar: "
      },
      'pageLength': 50,
      'order': [0, "asc"],
      'columnDefs': [{
          'orderable': false,
          'targets': [5]
        } // Aquí especifica las columnas que no son ordenables
      ],
      'destroy': true
    });
  })
</script>

<?php
//include footer
include("../inc/google-analytics.php");
?>