<?php
define('PERMITIDO', true);
$pantalla_actual = 'LIS_EMP';
require_once("../inc/init.php");
require_once("../inc/config.ui.php");
$page_title = $datos_pantallas[$pantalla_actual]['page_title'];
$page_css[] = "your_style.css";
include("../inc/header.php");
include("../inc/nav.php");

$qEmpresas = $mysqli->prepare("SELECT ID_EMPRESA, NRO_RUT_EMPRESA, DV_RUT_EMPRESA, NOMBRE_E, NBR, 
FLAG_LABORATORIO, FLAG_HOSPITAL, FLAG_CONVENIO, FLAG_IVA, FLAG_PREVISION, FLAG_PROVEEOR, FLAG_COMISION_MEDICA, FLAG_INACTIVO
FROM empresas 
ORDER BY NOMBRE_E ASC");
$qEmpresas->execute();
$qEmpresas->bind_result($idEmpresa, $nroRutEmpresa, $dvRutEmpresa, $nombre_e, $nbr,
$flag_laboratorio, $flag_hospital, $flag_convenio, $flag_iva, $flag_prevision, $flag_proveeor, $flag_comisionMedica, $flag_inactivo);
$qEmpresas->store_result();

function marcarSiNo($valor) {
  return ($valor == "S") ? "<i class='fa fa-check-circle fa-lg txt-color-green'> Si</i>" : "<i class='fa fa-times-circle fa-lg txt-color-red'> No</i>";
}

ob_start();
?>

<table class="table table-hover table-bordered" id="dataTables-empresas">
  <thead>
    <tr>
      <th>Rut</th>
      <th>Nombre</th>
      <th>Abreviación</th>
      <th>Laboratorio</th>
      <th>Hospital</th>
      <th>Convenio</th>
      <th>IVA</th>
      <th>Previsión</th>
      <th>Proveedor</th>
      <th>Comisión Médica</th>
      <th>Estado</th>
      <th>Acciones</th>
    </tr>
  </thead>
  <tbody>
    <?php while ($qEmpresas->fetch()) { ?>
      <tr <?= $flag_inactivo == 1 ? "class='warning'" : "" ?>>
        <td><?= number_format($nroRutEmpresa, 0, ',', '.') ?>-<?= $dvRutEmpresa ?></td>
        <td><?= $nombre_e ?></td>
        <td><?= $nbr ?></td>
        <td><?= marcarSiNo($flag_laboratorio) ?></td>
        <td><?= marcarSiNo($flag_hospital) ?></td>
        <td><?= marcarSiNo($flag_convenio) ?></td>
        <td><?= marcarSiNo($flag_iva) ?></td>
        <td><?= marcarSiNo($flag_prevision) ?></td>
        <td><?= marcarSiNo($flag_prevision) ?></td>
        <td><?= marcarSiNo($flag_comisionMedica) ?></td>
        <td><?= $flag_inactivo == 1 ? "<span class='badge bg-color-red'>Inactivo</span>" : "<span class='badge bg-color-green'>Activo</span>" ?></td>
        <td>
          <a class="btn btn-link" href="e_empresas.php?idEmpresa=<?= $idEmpresa ?>" title="Modificar Empresa"><i class="fa fa-edit fa-lg"></i></a>
          <a class="btn btn-link btn-eliminarEmpresa <?php if ($flag_inactivo == 1) echo "hidden" ?>" data-id="<?= $idEmpresa ?>" title="Eliminar Empresa"><i class="fa fa-trash-o fa-lg txt-color-red"></i></a>
          <a class="btn btn-link btn-restaurarEmpresa <?php if ($flag_inactivo == 0) echo "hidden" ?>" data-id="<?= $idEmpresa ?>" title="Restaurar Empresa"><i class="fa fa-arrow-circle-up fa-lg txt-color-green"></i></a>
        </td>
      </tr>
    <?php } ?>
  </tbody>
</table>

<?php
$contenido = ob_get_contents();
ob_end_clean();

$ui = new SmartUI;
$options = array("editbutton" => false);
$widget = $ui->create_widget($options);

$widget->header = array(
  "title" => $datos_pantallas[$pantalla_actual]['body_title'],
  "icon" => 'fa fa-cog',
  'toolbar' => array(
    array(
      "id" => "toolbar-id",
      "content" => "<a href='n_empresa.php' class='btn btn-success'> <i class='fa fa-plus fa-lg'></i> Agregar</a>",
      "class" => 'smart-form'
    )
  )
);
$widget->body('content', $contenido);
?>

<div id="main" role="main">
  <?php
  include("../inc/ribbon.php");
  ?>
  <div id="content">
    <?php
    $widget->print_html();
    ?>
  </div>
</div>

<?php include("../inc/footer.php"); ?>
<?php include("../inc/scripts.php"); ?>

<script>
  $(document).ready(function() {
    $("#dataTables-empresas").DataTable({
      'lengthMenu': [
        [20, 50, 100],
        [20, 50, 100]
      ],
      'language': {
        "sProcessing": "Procesando...",
        "sZeroRecords": "No se encontraron resultados",
        "sInfoPostFix": "",
        "sUrl": "",
        "oPaginate": {
          "sFirst": "Primero",
          "sPrevious": "Anterior",
          "sNext": "Siguiente",
          "sLast": "Último"
        },
        "sInfo": "_START_ a _END_ de _TOTAL_ Registros",
        "sInfoEmpty": "0 Registros",
        "sInfoFiltered": "(de _MAX_ Registros en total)",
        "sLengthMenu": "Mostrar _MENU_ Registros",
        "sSearch": "Buscar: "
      },
      'pageLength': 50,
      'order': [1, "asc"],
      'columns': [
        null,
        null,
        null,
        null,
        null,
        null,
        null,
        null,
        null,
        null,
        null,
        { "orderable": false }
      ],
      'destroy': true
    });
  });

  $(".btn-eliminarEmpresa").on("click", function() {
    if (confirm("¿Desea marcar a la empresa como inactiva?")) {
      $.post("sql_cod.php", {
        eliminarEmpresa: "eliminarEmpresa",
        idEmpresa: $(this).data("id")
      }, function(data) {
        if (data.exito) {
          exito();
          location.reload();
        } else {
          error("Error: " + data.mensaje);
        }
      }, 'json');
    }
  });

  $(".btn-restaurarEmpresa").on("click", function() {
    if (confirm("¿Desea restaurar la empresa?")) {
      $.post("sql_cod.php", {
        restaurarEmpresa: "restaurarEmpresa",
        idEmpresa: $(this).data("id")
      }, function(data) {
        if (data.exito) {
          exito();
          location.reload();
        } else {
          error("Error: " + data.mensaje);
        }
      }, 'json');
    }
  });
</script>

<?php
include("../inc/google-analytics.php");
?>