<?php
$pantalla_actual = 'ING_EMP';
define('PERMITIDO', true);
require_once("../inc/init.php");
require_once("../inc/config.ui.php");
$page_title =  $datos_pantallas[$pantalla_actual]['page_title'];
$page_css[] = "your_style.css";
include("../inc/header.php");
include("../inc/nav.php");

ob_start();
?>
<form class="form-inline" id="formAgregarEmpresa">
  <table class="table table-hover table-bordered">
    <tr>
      <td>Rut:</td>
      <td>
        <input type="text" name="NRO_RUT_EMPRESA" value="" class="form-control" required="required" pattern="[0-9]{6,9}" title="Rut sin puntos" /> -
        <input type="text" name="DV_RUT_EMPRESA" value="" class="form-control" required="required" pattern="[0-9-k*K]" />
      </td>
    </tr>
    <tr>
      <td>Nombre o Razón Social:</td>
      <td><input type="text" name="NOMBRE_E" class="form-control" value="" required="required" /> </td>
    </tr>
    <tr>
      <td>Abreviación:</td>
      <td>
        <input type="text" name="NBR" class="form-control" value="" maxlength="20"/>
      </td>
    </tr>
    <tr>
      <td>Laboratorio:</td>
      <td>
        <select name="FLAG_LABORATORIO" class="form-control">
          <option value="N">No</option>
          <option value="S">Si</option>
        </select>
      </td>
    </tr>
    <tr>
      <td>Hospital:</td>
      <td>
        <select name="FLAG_HOSPITAL" class="form-control">
          <option value="N">No</option>
          <option value="S">Si</option>
        </select>
      </td>
    </tr>
    <tr>
      <td>Convenio:</td>
      <td>
        <select name="FLAG_CONVENIO" class="form-control">
          <option value="N">No</option>
          <option value="S">Si</option>
        </select>
      </td>
    </tr>
    <tr>
      <td>IVA incluido en atenciones:</td>
      <td>
        <select name="FLAG_IVA" class="form-control">
          <option value="N">No</option>
          <option value="S">Si</option>
        </select>
      </td>
    </tr>
    <tr>
      <td>Previsión:</td>
      <td>
        <select name="FLAG_PREVISION" class="form-control">
          <option value="N">No</option>
          <option value="S">Si</option>
        </select>
      </td>
    </tr>
    <tr>
      <td>Proveedor</td>
      <td>
        <select name="FLAG_PROVEEOR" class="form-control">
          <option value="N">No</option>
          <option value="S">Si</option>
        </select>
      </td>
    </tr>
    <tr>
      <td colspan="2" align="center">
        <a class="btn btn-sm btn-primary btn-agregarEmpresa"> <i class="fa fa-lg fa-save"></i> Grabar</a>
      </td>
    </tr>
  </table>

  <input type="hidden" name="formAgregarEmpresa" value="formAgregarEmpresa" />
</form>

<?php
$contenido = ob_get_contents();
ob_end_clean();

$ui = new SmartUI;
$options = array("editbutton" => false);
$widget = $ui->create_widget($options);

$widget->header = array(
  "title" =>  $datos_pantallas[$pantalla_actual]['body_title'],
  "icon" => 'fa fa-cog',
  'toolbar' => array(
    array(
      "id" => "toolbar-id",
      "content" => '<a href="#"  data-toggle="modal" data-target="#myModalNew"></a>',
      "class" => 'smart-form'
    )
  )
);
$widget->body('content', $contenido);
?>

<div id="main" role="main">
  <?php
  include("../inc/ribbon.php");
  ?>

  <div id="content">
    <?php
    $widget->print_html();
    ?>
  </div>
</div>

<!-- PAGE FOOTER -->
<?php
// include page footer
include("../inc/footer.php");
?>
<!-- END PAGE FOOTER -->

<?php
//include required scripts
include("../inc/scripts.php");
?>

<!-- PAGE RELATED PLUGIN(S) 
<script src="<?php echo ASSETS_URL; ?>/js/plugin/YOURJS.js"></script>-->

<script>
  $(document).ready(function() {
    $('.btn-agregarEmpresa').on('click', function() {
      if (confirm("¿Desea agregar esta empresa?")) {
        $.post("sql_cod.php", $("#formAgregarEmpresa").serialize(), function(data) {
          if (data.exito) {
            exito(data.mensaje);
            location.reload();
          } else {
            error(data.mensaje);
          }
        }, 'json');
      }
    });
  });
</script>

<?php
//include footer
include("../inc/google-analytics.php");
?>