<?php
$pantalla_actual = 'LIS_EQUI';
define('PERMITIDO', true);
require_once("../inc/init.php");
require_once("../inc/config.ui.php");
$page_title = $datos_pantallas[$pantalla_actual]['page_title'];
$page_css[] = "your_style.css";
include("../inc/header.php");
include("../inc/nav.php");

$stmt = $mysqli->prepare("SELECT ID_EQUIPO, FABRICANTE, MODELO, SERIE, CONTACTO, USO, FONO, RECEPCION, LEFT (CONDICION,30) AS COND, DATE_FORMAT(EN_MARCHA,'%d/%m/%Y') AS EN_MARCHA, 
LEFT (INST_FABRIC, 30) AS INSTR, DATE_FORMAT(NACE,'%d/%m/%Y') AS NACE, BAJA, 
cg1.DESCRIPCION_CG AS TIPO, cg2.DESCRIPCION_CG AS UBICACION, OPERATIVO, cg3.DESCRIPCION_CG AS AREA
FROM equipos
LEFT JOIN codigos_generales cg1 ON TIPO = cg1.CODIGO AND cg1.COD_TABLA = 'SIS_TIPEQU'
LEFT JOIN codigos_generales cg2 ON UBICACION = cg2.CODIGO AND cg2.COD_TABLA = 'SIS_UBICA'
LEFT JOIN codigos_generales cg3 ON AREA = cg3.CODIGO AND cg3.COD_TABLA = 'SIS_AREAS'
WHERE BAJA = 'N'");
$stmt->execute();
$resultado = $stmt->get_result();
$datos_equipos = $resultado->fetch_all(MYSQLI_ASSOC);

ob_start();
?>

<table id="dataTables-equipos" class="table table-hover table-bordered">
  <thead>
    <tr>
      <th>Modelo</th>
      <th>Marca/Fabricante</th>
      <th>N° Serie</th>
      <th>Tipo de equipo</th>
      <th>Área</th>
      <th>Operativo</th>
      <th>Fecha puesta en marcha</th>
      <th>Uso</th>
      <th>Exámenes</th>
      <th>Modificar</th>
      <th>Eliminar</th>
    </tr>
  </thead>
  <tbody>
    <?php foreach ($datos_equipos as $data_equipo) { ?>
      <tr>
        <td><?= $data_equipo['MODELO'] ?></td>
        <td><?= $data_equipo['FABRICANTE'] ?></td>
        <td><?= $data_equipo['SERIE'] ?></td>
        <td><?= $data_equipo['TIPO'] ?></td>
        <td><?= $data_equipo['AREA'] ?></td>
        <td><?= ($data_equipo['OPERATIVO'] == "S") ? "Si" : "No" ?></td>
        <td><?= $data_equipo['EN_MARCHA'] ?></td>
        <td><?= $data_equipo['USO'] ?></td>
        <td> <a style="padding:0" href="examenesEquipo.php?ideq=<?= $data_equipo['ID_EQUIPO'] ?>"><i class="txt-color-green fa fa-flask fa-lg"></i></a> </td>
        <td> <a data-toggle="modal" href="md_modificarEquipo.php?ideq=<?= $data_equipo['ID_EQUIPO'] ?>" data-target="#md_modificarEquipo" style="padding:0;"><i class="fa fa-edit fa-lg"></i></a> </td>
        <td> <a style="padding:0" class="btn btn-sm btn-link bajaEquipo" data-ideq="<?= $data_equipo['ID_EQUIPO'] ?>"><i class="txt-color-red fa fa-remove fa-lg"></i></a> </td>
      </tr>
    <?php } ?>
  </tbody>
</table>



<?php
$contenido = ob_get_contents();
ob_end_clean();

$ui = new SmartUI;
$options = array("editbutton" => false);
$widget = $ui->create_widget($options);
/*,
'toolbar' => array(
    array(
        "id" => "toolbar-id",
        "content" => '<a href="ing_eq.php" class="btn btn-success"> Ingreso de Equipo </a>',
        "class" => 'smart-form'
    )
)*/
$widget->header = array(
  "title" => $datos_pantallas[$pantalla_actual]['body_title'],
  "icon" => 'fa fa-cog'
);
$widget->body('content', $contenido);
?>

<div id="main" role="main">
  <?php
  include("../inc/ribbon.php");
  ?>

  <div id="content">
    <?php
    $widget->print_html();
    ?>
  </div>
</div>

<div class="modal fade Edit" id="md_modificarEquipo" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
  <div class="modal-dialog">

    <div class="modal-content"></div>
  </div>
</div>

<?php
include("../inc/footer.php");
include("../inc/scripts.php");
?>

<script>
  $(document).ready(function() {
    var order = [0, "asc"];
    var columnasNoOrdenables = [8, 9, 10];
    inicializarDataTables('dataTables-equipos', order, columnasNoOrdenables);

    $('.bajaEquipo').click(function() {
      var ideq = $(this).data('ideq');
      if (confirm('Una vez dado de baja el equipo,\neste NO podra volver a cambiar su estado.\n\n¿Está seguro que desea dar de baja el equipo?')) {
        $.post('sql_cod.php', {
          bajaEquipo: 1,
          ideq: ideq
        }, function(data) {
          if (data.exito) {
            exito();
            location.reload();

          } else {
            error("Error: " + data.mensaje);
          }
        }, 'json');
      }
    })
  });
</script>

<?php
include("../inc/google-analytics.php");
?>