<?php
$pantalla_actual = 'MOD_EXA';
define('PERMITIDO', true);
require_once("../inc/init.php");
require_once("../inc/config.ui.php");
$page_title = $datos_pantallas[$pantalla_actual]['page_title'];
$page_css[] = "your_style.css";
include("../inc/header.php");
include("../inc/nav.php");

$idExamen = isset($_GET['idex']) && $_GET['idex'] != "" ? $_GET['idex'] : "-1";

$stmt = $mysqli->prepare("SELECT * FROM examenes WHERE COD_INTERNO = ?");
$stmt->bind_param("s", $idExamen);
$stmt->execute();
$resultado = $stmt->get_result();
$datos_examen = $resultado->fetch_array(MYSQLI_ASSOC);

$options_tipoTubo = optionsCodigosG("SIS_TIPTUB", $datos_examen['TIPO_TUBO']);
$options_areasLaboratorio = optionsCodigosG("SIS_AREAS", $datos_examen['AREA_LAB']);
$options_hojaTrabajo = optionsCodigosG("SIS_AREAS", $datos_examen['NRO_HOJA_TRABAJO']);
$options_unidadMedida = optionsCodigosG("SIS_UNIMED", $datos_examen['UNIDAD_MEDIDA']);
$options_tipoMuestra = optionsCodigosG("SIS_TIPMUE", $datos_examen['TIPO_MUESTRA']);
$options_preparacion = optionsCodigosG("SIS_PREPAR", $datos_examen['TIPO_TUBO']);
$options_archivoInstrucciones = optionsCodigosG("SIS_ARCINS", $datos_examen['ARCH_INSTRUCCIONES']);

ob_start();
?>

<form id="formModificarExamen" class="form-group">
  <table class="table table-hover table-bordered">
    <tr>
      <th>Código Interno:</th>
      <th><?= $datos_examen['COD_INTERNO']; ?></th>
      <th>Estado:</th>
      <th>
        <select class="form-control" name="FLAG_ELIMINADO">
          <option value="" <?php if ($datos_examen['FLAG_ELIMINADO'] != 1) echo "selected" ?>>Activo</option>
          <option value="1" <?php if ($datos_examen['FLAG_ELIMINADO'] == 1) echo "selected" ?>>Inactivo</option>
        </select>
      </th>
    </tr>
    <tr>
      <th>Nombre:</th>
      <td><input type="text" name="NOMBRE" class="form-control" value="<?= $datos_examen['NOMBRE']; ?>" /></td>
      <th>Nombre en Informe:</th>
      <td><input name="NOMBRE_INF" type="text" class="form-control" value="<?= $datos_examen['NOMBRE_INF']; ?>" maxlength="200" /></td>
    </tr>
    <tr>
      <th>Sinónimos:</th>
      <td><input type="text" class="form-control TM_SINONIMOS" placeholder="Ingrese un sinónimo y presione Enter" autocomplete="off" /></td>
      <th>Codigo FONASA:</th>
      <td><input type="text" name="COD_FONASA" class="form-control" value="<?= $datos_examen['COD_FONASA']; ?>" placeholder="12.34.567" pattern="[0-9][0-9]+.[0-9][0-9]+.[0-9][0-9][0-9]" /></td>
    </tr>
    <tr>
      <th>Agrupación:</th>
      <td>
        <select class="form-control" name="FLAG_AGRUPACION">
          <option value="N" <?php if (!(strcmp("N", htmlentities($datos_examen['FLAG_AGRUPACION'], ENT_COMPAT, 'utf-8')))) echo "selected" ?>>No</option>
          <option value="S" <?php if (!(strcmp("S", htmlentities($datos_examen['FLAG_AGRUPACION'], ENT_COMPAT, 'utf-8')))) echo "selected" ?>>Si</option>
        </select>
      </td>
      <th>Hijo:</th>
      <td>
        <select class="form-control" name="FLAG_HIJO">
          <option value="N" <?php if (!(strcmp("N", htmlentities($datos_examen['FLAG_HIJO'], ENT_COMPAT, 'utf-8')))) echo "selected" ?>>No</option>
          <option value="S" <?php if (!(strcmp("S", htmlentities($datos_examen['FLAG_HIJO'], ENT_COMPAT, 'utf-8')))) echo "selected" ?>>Si</option>
        </select>
      </td>
    </tr>
    <tr>
      <th>Tipo de Tubo:</th>
      <td>
        <select class="form-control" name="TIPO_TUBO">
          <?= $options_tipoTubo ?>
        </select>
      </td>
      <th>Tipo Muestra:</th>
      <td>
        <select name="TIPO_MUESTRA" class="form-control" id="TIPO_MUESTRA" title="<?= $datos_examen['TIPO_MUESTRA']; ?>">
          <?= $options_tipoMuestra ?>
        </select>
      </td>
    </tr>
    <tr>
      <th>Unidad de Medida:</th>
      <td>
        <select class="form-control" name="UNIDAD_MEDIDA">
          <?= $options_unidadMedida ?>
        </select>
      </td>
      <th>Método Análisis:</th>
      <td><input name="METODO" type="text" class="form-control" id="METODO" value="<?= $datos_examen['METODO']; ?>" /></td>
    </tr>
    <tr>
      <th>Cantidad:</th>
      <td><input name="CANTIDAD" type="text" class="form-control" id="CANTIDAD" value="<?= $datos_examen['CANTIDAD']; ?>" /></td>
      <th>Área de Laboratorio:</th>
      <td>
        <select class="form-control" name="AREA_LAB">
          <?= $options_areasLaboratorio ?>
        </select>
      </td>
    </tr>
    <tr>
      <th>Área Hoja de Trabajo:</th>
      <td>
        <select class="form-control" name="NRO_HOJA_TRABAJO">
          <?= $options_hojaTrabajo ?>
        </select>
      </td>
      <th>Horas de Proceso:</th>
      <td><input type="number" class="form-control" name="HORAS_PROCESO" value="<?= $datos_examen['HORAS_PROCESO']; ?>" min="1" max="999" /></td>
    </tr>
    <tr>
      <th>Género</th>
      <td>
        <select name="GENERO" class="form-control" id="GENERO">
          <option value="F/M" selected="selected" <?php if (!(strcmp("F/M", $datos_examen['GENERO']))) echo "selected" ?>>F/M</option>
          <option value="F" <?php if (!(strcmp("F", $datos_examen['GENERO']))) echo "selected" ?>>FEMENINO</option>
          <option value="M" <?php if (!(strcmp("M", $datos_examen['GENERO']))) echo "selected" ?>>MASCULINO</option>
        </select>
      </td>
      <th>Ultima Regla:</th>
      <td>
        <select class="form-control" name="FLAG_ULTIMA_REGLA">
          <option value="N" <?php if (!(strcmp("N", htmlentities($datos_examen['FLAG_ULTIMA_REGLA'], ENT_COMPAT, 'utf-8')))) echo "selected" ?>>No</option>
          <option value="S" <?php if (!(strcmp("S", htmlentities($datos_examen['FLAG_ULTIMA_REGLA'], ENT_COMPAT, 'utf-8')))) echo "selected" ?>>Si</option>
        </select>
      </td>
    </tr>
    <tr>
      <th>Costo Interno ($):</th>
      <td><input type="number" name="COSTO_INTERNO" class="form-control" value="<?= htmlentities($datos_examen['COSTO_INTERNO'], ENT_COMPAT, 'utf-8'); ?>" /></td>
      <th>Secuencia Código de Barra:</th>
      <td><input type="number" class="form-control" name="SECUENCIA_CBARRA" min="0" max="1" value="<?= htmlentities($datos_examen['SECUENCIA_CBARRA'], ENT_COMPAT, 'utf-8'); ?>" /></td>
    </tr>
    <tr>
      <th>Incluir en Informe:</th>
      <td>
        <select class="form-control" name="F_INF">
          <option value="S" <?php if (!(strcmp("S", $datos_examen['F_INF']))) echo "selected" ?>>Si</option>
          <option value="N" <?php if (!(strcmp("N", $datos_examen['F_INF']))) echo "selected" ?>>No</option>
        </select>
      </td>
      <th>% de diferencia examen anterior: </th>
      <td>
        <input type="text" class="form-control" name="PORC_DIFERENCIA" value="<?= $datos_examen['PORC_DIFERENCIA']; ?>" />
      </td>
    </tr>
    <tr>
      <th>Urgente:</th>
      <td>
        <select class="form-control" name="FLAG_URGENTE">
          <option value="1" <?php if ($datos_examen['FLAG_URGENTE'] == 1) echo "selected" ?>>Si</option>
          <option value="0" <?php if ($datos_examen['FLAG_URGENTE'] != 1) echo "selected" ?>>No</option>
        </select>
      </td>
      <th>Crítico:</th>
      <td>
        <select class="form-control" name="FLAG_CRITICO">
          <option value="1" <?php if ($datos_examen['FLAG_CRITICO'] == 1) echo "selected" ?>>Si</option>
          <option value="0" <?php if ($datos_examen['FLAG_CRITICO'] != 1) echo "selected" ?>>No</option>
        </select>
      </td>
    </tr>
    <tr>
      <th>Preparación:</th>
      <td>
        <select name="PREPARACION" class="form-control" id="PREPARACION" title="<?= $datos_examen['PREPARACION']; ?>">
          <?= $options_preparacion ?>
        </select>
      </td>
      <th>Archivo Instrucciones:</th>
      <td>
        <select name="ARCH_INSTRUCCIONES" class="form-control" id="ARCH_INSTRUCCIONES">
          <?= $options_archivoInstrucciones ?>
        </select>
      </td>
    </tr>
    <tr>
      <th valign="middle">Observaciones:</th>
      <td colspan="3"><textarea name="OBS" id="OBS" class="form-control" cols="40" rows="5"><?= $datos_examen['OBS']; ?></textarea></td>
    </tr>
    <tr <?php if ($datos_examen['FLAG_AGRUPACION'] == "N") echo "hidden" ?>>
      <th>Agrupación Homologada en I-MED:</th>
      <td>
        <select name="FLAG_AGRUPACION_HOMOLOGADA_IMED" class="form-control">
          <option <?php if ($datos_examen['FLAG_AGRUPACION_HOMOLOGADA_IMED'] == 0) echo "selected" ?> value="0">No</option>
          <option <?php if ($datos_examen['FLAG_AGRUPACION_HOMOLOGADA_IMED'] == 1) echo "selected" ?> value="1">Si</option>
        </select>
      </td>
    </tr>
    <tr>
      <td colspan="4" align="center">
        <a class="btn btn-primary btn-sm btn-modificarExamen"> <i class="fa fa-save"></i> Grabar </a>
      </td>
    </tr>
  </table>
  <input type="hidden" name="formModificarExamen" value="formModificarExamen" />
  <input type="hidden" name="COD_INTERNO" value="<?= $datos_examen['COD_INTERNO']; ?>" />
</form>

<?php
$contenido = ob_get_contents();
ob_end_clean();

$ui = new SmartUI;
$options = array("editbutton" => false);
$widget = $ui->create_widget($options);

$hidden = $usuario_id != 0 ? "hidden" : "";

if ($datos_examen['FLAG_AGRUPACION'] == 'S' && $datos_examen['FLAG_HIJO'] == 'N') {
  $widget->header = array(
    "title" => $datos_pantallas[$pantalla_actual]['body_title'],
    "icon" => 'fa fa-cog',
    'toolbar' => array(
      array(
        "id" => "toolbar-id",
        "content" => '
          <a class="btn btn-success' . $hidden . '" href="e_agrupacion.php?idex=' . $datos_examen['COD_INTERNO'] . '">Detalle Agrupación</a>
          <a class="btn btn-success' . $hidden . '" href="formulasExamen.php?idex=' . $datos_examen['COD_INTERNO'] . '"><i class="fa fa-edit fa-lg"></i> Fórmulas de Resultado</a>
        ',
        "class" => 'smart-form'
      )
    )
  );
} else {
  $widget->header = array(
    "title" => $datos_pantallas[$pantalla_actual]['body_title'],
    "icon" => 'fa fa-cog',
    'toolbar' => array(
      array(
        "id" => "toolbar-id",
        "content" => '
          <a class="btn btn-success' . $hidden . '" href="formulasExamen.php?idex=' . $datos_examen['COD_INTERNO'] . '"><i class="fa fa-edit fa-lg"></i> Fórmulas de Resultado</a>
        ',
        "class" => 'smart-form'
      )
    )
  );
}

$widget->body('content', $contenido);
?>

<div id="main" role="main">
  <?php include("../inc/ribbon.php");  ?>

  <div id="content">
    <?php
    $widget->print_html();
    ?>
  </div>
</div>

<?php
include("../inc/footer.php");
include("../inc/scripts.php");
?>

<script src="<?= ASSETS_URL ?>/js/plugin/tagManager/3.0.2/tagmanager.min.js"></script>
<link rel="stylesheet" type="text/css" href="<?= ASSETS_URL ?>/js/plugin/tagManager/3.0.2/tagmanager.min.css">

<script>
  $(document).ready(function() {
    $(".TM_SINONIMOS").tagsManager({
      hiddenTagListName: "TM_SINONIMOS",
      prefilled: "<?= $datos_examen['SINONIMOS']; ?>",
      deleteTagsOnBackspace: false
    });

    $('.btn-modificarExamen').on('click', function() {
      $.post('sql_cod.php', $('#formModificarExamen').serialize(), function(data) {
        if (data.exito) {
          exito();
          location.reload();
        } else {
          error("Error: " + data.mensaje);
        }
      }, 'json');
    });
  });
</script>
<?php
//include footer
include("../inc/google-analytics.php");
?>