<?php
$pagina = 1;
define('PERMITIDO', true);
require_once("../inc/init.php");

use Dompdf\Dompdf;
use Dompdf\Options;

require_once '../vendor/autoload.php';

$options = new Options();
$options->set('isHtml5ParserEnabled', true);
$options->set('isPhpEnabled', true);
$options->set('defaultFont', 'Helvetica');

$dompdf = new Dompdf($options);
$dompdf->setPaper('letter');
$dompdf->loadHtml('<html><body>');

// Función para generar el contenido HTML
function generarContenidoHTML($datos_examen)
{
	$html = '<img src="../assets/img/logo_empresa_informes.png" />';
	$html .= '<h1>LISTADO DE EXÁMENES</h1>';
	$html .= '<table border="1">';
	$html .= '
	<tr>
		<th>Correlativo</th>
		<th>Cod. Interno</th>
		<th>Nombre examen</th>
		<th>Cod. FONASA</th>
		<th>Tipo de Tubo</th>
		<th>Tipo de Muestra</th>
	</tr>';

	$i = 1;
	foreach ($datos_examen as $examen) {
		$cod_int = $examen['COD_INTERNO'];
		$nombre = $examen['NOMBRE'];
		$fonasa = $examen['COD_FONASA'] != "" ? $examen['COD_FONASA'] : "";
		$tipo_tubo = $examen['TIPOTUBO'];
		$tipo_mu = $examen['TIPOMUESTRA'];

		$html .= "
    <tr>
			<td>$i</td>
			<td>$cod_int</td>
			<td>$nombre</td>
			<td>$fonasa</td>
			<td>$tipo_tubo</td>
			<td>$tipo_mu</td>
    </tr>";
		$i++;
	}

	$html .= '</table>';
	return $html;
}

$stmt = $mysqli->prepare("SELECT COD_INTERNO, IF(NOMBRE_INF != '', NOMBRE_INF, NOMBRE) AS NOMBRE, COD_FONASA, HORAS_PROCESO, cg.DESCRIPCION_CG AS TIPOTUBO, cg2.DESCRIPCION_CG AS TIPOMUESTRA, cg3.DESCRIPCION_CG AS PREP
FROM examenes e
LEFT JOIN codigos_generales cg ON e.TIPO_TUBO = cg.CODIGO  AND cg.COD_TABLA = 'SIS_TIPTUB'
LEFT JOIN codigos_generales cg2 ON e.TIPO_MUESTRA = cg2.CODIGO AND cg2.COD_TABLA = 'SIS_TIPMUE'
LEFT JOIN codigos_generales cg3 ON e.PREPARACION = cg3.CODIGO AND cg3.COD_TABLA = 'SIS_PREPAR'
WHERE e.FLAG_ELIMINADO IS NULL # AND COD_FONASA != ''
ORDER BY IF(NOMBRE_INF != '', NOMBRE_INF, NOMBRE) ASC");
$stmt->execute();
$resultado = $stmt->get_result();
$datos_examen = $resultado->fetch_all(MYSQLI_ASSOC);

$html = generarContenidoHTML($datos_examen);

$dompdf->loadHtml($html);

// Renderizar el PDF
$dompdf->render();

// Enviar el PDF al navegador
$dompdf->stream("listado_examenes.pdf");
