<?php
$pantalla_actual = 'MOD_EXA';
define('PERMITIDO', true);
require_once("../inc/init.php");
require_once("../inc/config.ui.php");
$page_title = $datos_pantallas[$pantalla_actual]['page_title'];
$page_css[] = "your_style.css";
include("../inc/header.php");
include("../inc/nav.php");

/* Examen Padre */
$codExamen = "-1";
if (isset($_GET['idex'])) $codExamen = $_GET['idex'];

$qbuscar = $mysqli->prepare("SELECT NOMBRE
FROM examenes
WHERE COD_INTERNO = ?");
$qbuscar->bind_param('s', $codExamen);
$qbuscar->execute();
$qbuscar->bind_result($nombreExamen);
$qbuscar->store_result();
$qbuscar->fetch();
$qbuscar->close();

# consulto si existe usuario para el rut actual
$qFormulas = $mysqli->prepare("SELECT ID_FORMULA_EXAMEN, DESCRIPCION, FORMULA
FROM formulas_examen
WHERE COD_EXAMEN = ?");
$qFormulas->bind_param('s', $codExamen);
$qFormulas->execute();
$qFormulas->bind_result($idFormula, $descripcionFormula, $formulaFormula);
$qFormulas->store_result();
$rows = $qFormulas->num_rows;

ob_start();
?>

<h3>Fórmulas de Resultado de Exámen</h3>
<h3><?= $codExamen ?> - <?= $nombreExamen ?></h3>
<?php if ($rows > 0) { ?>
    <table class="table table-hover table-bordered">
        <thead>
            <tr>
                <th>Descripción fórmula</th>
                <th>Fórmula</th>
                <th>Variables</th>
                <th>Acciones</th>
            </tr>
        </thead>
        <tbody>
            <?php while ($qFormulas->fetch()) { ?>
                <tr>
                    <td><?= $descripcionFormula ?></td>
                    <td><?= $formulaFormula ?></td>
                    <td>
                        <a class="btn btn-link" data-toggle="modal" href="md_variablesFormula.php?idFormula=<?= $idFormula ?>" data-target="#md_variablesFormula"><i class="fa fa-list fa-lg"></i> </a>
                    </td>
                    <td>
                        <a class="btn btn-link" data-toggle="modal" href="md_modificarFormula.php?idFormula=<?= $idFormula ?>" data-target="#md_modificarFormula"><i class="fa fa-edit fa-lg"></i> </a>
                        <a class="btn btn-link btn-eliminarFormulaExamen" data-id="<?= $idFormula ?>"><i class="fa fa-remove fa-lg txt-color-red"></i></a>
                    </td>
                </tr>
            <?php } ?>
        </tbody>
    </table>
<?php } else {
    echo '<h5>No hay fórmulas agregadas</h5>';
} ?>


<?php
$contenido = ob_get_contents();
ob_end_clean();

$ui = new SmartUI;
$options = array("editbutton" => false);
$widget = $ui->create_widget($options);

$widget->header = array(
    "title" => $datos_pantallas[$pantalla_actual]['body_title'],
    "icon" => 'fa fa-cog',
    'toolbar' => array(
        array(
            "id" => "toolbar-id",
            "content" => "
            <a class='btn btn-sm btn-success' href='md_agregarFormula.php?codExamen=$codExamen' data-toggle='modal' data-target='#md_agregarFormula'>
                <i class='fa fa-plus'> </i> Agregar Fórmula
            </a>",
            "class" => 'smart-form'
        )
    )
);
$widget->body('content', $contenido);
?>

<div id="main" role="main">
    <?php include("../inc/ribbon.php");  ?>

    <div id="content">
        <?php
        $widget->print_html();
        ?>
    </div>
</div>

<div class="modal fade" id="md_agregarFormula" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content"></div>
    </div>
</div>

<div class="modal fade Edit" id="md_variablesFormula" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content" style="width:120%">
        </div>
    </div>
</div>

<div class="modal fade Edit" id="md_modificarFormula" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content" style="width:120%">
        </div>
    </div>
</div>

<?php
include("../inc/footer.php");
include("../inc/scripts.php");
?>

<script>
    $(document).ready(function() {
        $('.btn-agregar').on('click', function() { //agregar Nuevo Hijo		
            $.post('sql_cod.php', $('#FormNHijo').serialize(), function(data) {
                if (data.exito) {
                    exito();
                    location.reload();
                    //$("#tablaAct").load("#tablaAct");
                } else {
                    error("Error: " + data.mensaje);
                }
            }, 'json');
        });

        $('.btn-eliminarFormulaExamen').click(function() {
            if (confirm("¿Desea eliminar la fórmula de resultados para el exámen?")) {
                $.post('sql_cod.php', {
                    eliminarFormulaExamen: 1,
                    idFormulaExamen: $(this).data('id'),
                }, function(data) {
                    if (data.exito) {
                        exito("Se ha guardado con exito!");
                        location.reload();
                    } else {
                        error(data.mensaje);
                    }
                }, 'json');
            }
        });
    });
</script>

<?php
include("../inc/google-analytics.php");
?>