<?php
# $pagina = 8;
define('PERMITIDO', true);
require_once("../inc/init.php");
require_once("../inc/config.ui.php");

$codExamen = isset($_GET['codExamen']) ? $_GET['codExamen'] : "-1";

$qbuscar = $mysqli->prepare("SELECT NOMBRE
FROM examenes
WHERE COD_INTERNO = ?");
$qbuscar->bind_param('s', $codExamen);
$qbuscar->execute();
$qbuscar->bind_result($nombreExamen);
$qbuscar->store_result();
$qbuscar->fetch();
$qbuscar->close();


ob_start();
?>

<div class="modal-header">
  <button type="button" class="close" data-dismiss="modal" aria-hidden="true">
    &times;
  </button>
  <h4 class="modal-title" id="myModalLabel"> Agregar nueva fórmula - Examen: <?= $nombreExamen ?> </h4>
</div>

<div class="modal-body">
  <form action="sql_cod.php" id="formAgregarFormulaExamen" name="formAgregarFormulaExamen" class="smart-form" method="post">
    <div class="row">
      <section class="col col-2">
        Descripción:
      </section>
      <section class="col col-8">
        <label class="input">
          <input type="text" class="input-sm" name="DESCRIPCION" value="" />
        </label>
      </section>
    </div>
    <div class="row">
      <section class="col col-2">
        Fórmula:
      </section>
      <section class="col col-8">
        <label class="input">
          <input type="text" class="input-sm" name="FORMULA" value="" />
        </label>
      </section>
    </div>
    <input type="hidden" name="formAgregarFormulaExamen" value="formAgregarFormulaExamen" />
    <input type="hidden" name="codExamen" value="<?= $codExamen ?>" />
  </form>
</div>

<div class="modal-footer">
  <button type="button" class="btn btn-default" data-dismiss="modal">
    Cancelar
  </button>
  <button class="btn btn-primary btn-agregarFormulaExamen pull-right" data-form="#formAgregarFormula">
    <i class="fa fa-save"></i> Grabar
  </button>
</div>

<script>
  $(document).ready(function() {
    $('#selectExamen').select2();

    $(".btn-agregarFormulaExamen").on("click", function() {
      $(".btn-agregarFormulaExamen").attr('disabled', true);
      $.post('sql_cod.php', $('#formAgregarFormulaExamen').serialize(), function(data) {
        if (data.exito) {
          exito();
          // $("#md_btn-agregarFormulaExamen .close").click();
          location.reload();
        } else {
          error(data.mensaje);
          $(".btn-agregarFormulaExamen").attr('disabled', false);
        }
      }, 'json');
    });
  });
</script>