<?php
$pantalla_actual = 'MOD_PER';
define('PERMITIDO', true);
require_once("../inc/init.php");
require_once("../inc/config.ui.php");
$page_title = $datos_pantallas[$pantalla_actual]['page_title'];
$page_css[] = "your_style.css";
include("../inc/header.php");
include("../inc/nav.php");

$idPerfilUsuario = isset($_GET['idPerfilUsuario']) ? $_GET['idPerfilUsuario'] : "-1";

$stmt = $mysqli->prepare("SELECT DESCRIPCION_CG FROM codigos_generales WHERE DESCRIPCION_CG = ?");
$stmt->bind_param('s', $idPerfilUsuario);
$stmt->execute();
$stmt->bind_result($descripcionPerfilUsuario);
$stmt->store_result();
$stmt->fetch();
$stmt->close();

$options_nuevaAccion = "<option value=''>Seleccione una nueva acción</option>";
$stmt = $mysqli->prepare("SELECT CODIGO, DESCRIPCION_CG 
FROM codigos_generales 
WHERE codigos_generales.COD_TABLA = 'SIS_ACCION' AND CODIGO NOT IN (SELECT ACCION FROM acciones_perfiles WHERE COD_PERFIL = ?) 
ORDER BY DESCRIPCION_CG");
$stmt->bind_param('s', $idPerfilUsuario);
$stmt->execute();
$stmt->bind_result($codigoNuevaAccion, $descripcionNuevaAccion);
$stmt->store_result();
while ($stmt->fetch()) {
  $options_nuevaAccion .= "<option value='$codigoNuevaAccion'> $descripcionNuevaAccion </option>";
}
$stmt->close();

$qAccionesPerfil = $mysqli->prepare("SELECT ap.ID_AP, cg.CODIGO, cg.DESCRIPCION_CG
FROM acciones_perfiles ap 
INNER JOIN codigos_generales cg ON ap.ACCION = cg.CODIGO 
WHERE COD_PERFIL = ? AND cg.COD_TABLA = 'SIS_ACCION' AND FLAG_ELIMINADO IS NULL
ORDER BY cg.DESCRIPCION_CG ASC");
$qAccionesPerfil->bind_param('s', $idPerfilUsuario);
$qAccionesPerfil->execute();
$qAccionesPerfil->bind_result($idAccion, $codigoAccion, $descripcionAccion);
$qAccionesPerfil->store_result();

ob_start();
?>

<div class="well well-sm bg-color-blue txt-color-white text-left">
  <p class="font-md">
    Perfil de usuario: <?= $descripcionPerfilUsuario ?>
  </p>
</div>
<br />

<form action="sql_cod.php" method="post" class="smart-form" id="FormAgregarAccionPerfil">
  <div class="row">
    <section class="col col-6">
      <select name="ACCION" class="select2" style="width:100%">
        <?= $options_nuevaAccion  ?>
      </select>
    </section>
    <section class="col col-2">
      <button class="btn btn-sm btn-success btn-agregarNuevaAccion" data-form="#FormAgregarAccionPerfil">
        <i class="fa fa lg fa-plus"> </i> Agregar
      </button>
    </section>
  </div>
  <input type="hidden" name="COD_PERFIL" value="<?= $descripcionPerfilUsuario ?>" />
  <input type="hidden" name="FormAgregarAccionPerfil" value="FormAgregarAccionPerfil" />
</form>

<table id="dataTable" class="table table-hover table-bordered table-condensed">
  <thead>
    <tr>
      <th>Código acción</th>
      <th>Acciones</th>
      <th>Eliminar</th>
    </tr>
  </thead>
  <tbody>
    <?php while ($qAccionesPerfil->fetch()) { ?>
      <tr>
        <td><?= $codigoAccion ?></td>
        <td><?= $descripcionAccion ?></td>
        <td class="text-center">
          <a class="btn btn-link btn-eliminarAccionPerfil" data-id="<?= $idAccion ?>"> <i class="fa fa-trash-o fa-lg txt-color-red"></i> </a>
        </td>
      </tr>
    <?php }
    $qAccionesPerfil->close(); ?>
  </tbody>
</table>

<?php
$contenido = ob_get_contents();
ob_end_clean();

$ui = new SmartUI;
$options = array("editbutton" => false);
$widget = $ui->create_widget($options);

$widget->header = array(
  "title" => $datos_pantallas[$pantalla_actual]['body_title'],
  "icon" => 'fa fa-cog',
  'toolbar' => array(
    array(
      "id" => "toolbar-id",
      "content" => '<a href="#"  data-toggle="modal" data-target="#myModalNew"></a>',
      "class" => 'smart-form'
    )
  )
);
$widget->body('content', $contenido);
?>

<div id="main" role="main">
  <?php
  include("../inc/ribbon.php");
  ?>

  <div id="content">
    <?php
    $widget->print_html();
    ?>
  </div>
</div>

<?php
include("../inc/footer.php");
include("../inc/scripts.php");
?>

<script>
  $(document).ready(function() {
    var order = [0, "asc"];
    var columnasNoOrdenables = [2];
    inicializarDataTables('dataTable', order, columnasNoOrdenables);

    $(".btn-agregarNuevaAccion").on("click", function() {
      $(".btn-agregarNuevaAccion").prop('disabled', true);
      var form = $(this).data("form");
      $.post($(form).attr("action"), $(form).serialize(), function(data) {
        if (data.exito) {
          exito();
          location.reload();
        } else {
          $(".btn-agregarNuevaAccion").prop('disabled', false);
          error(data.mensaje);
        }
      }, 'json');
    });

    $(".btn-eliminarAccionPerfil").on("click", function() {
      if (confirm("¿Está seguro que desea eliminar el registro?\nEliminar este registro puede afectar el funcionamiento del Sistema")) {
        var id = $(this).data("id");
        $.post("sql_cod.php", {
          eliminar_accion_perfil: 1,
          id_accion_perfil: id
        }, function(data) {
          if (data.exito) {
            exito();
            location.reload();
          } else {
            error(data.mensaje);
          }
        }, 'json');
      }
    });
  });
</script>

<?php
include("../inc/google-analytics.php");
?>