<?php
$pantalla_actual = 'MOD_ELE_DOM';
define('PERMITIDO', true);
require_once("../inc/init.php");
require_once("../inc/config.ui.php");
$page_title = $datos_pantallas[$pantalla_actual]['page_title'];
$page_css[] = "your_style.css";
include("../inc/header.php");
include("../inc/nav.php");

$idCodigoGeneral = isset($_GET['idCodigoGeneral']) ? $_GET['idCodigoGeneral'] : "-1";

$stmt = $mysqli->prepare("SELECT * FROM codigos_generales WHERE ID_CODIGO = ?");
$stmt->bind_param("i", $idCodigoGeneral);
$stmt->execute();
$resultado = $stmt->get_result();
$datos_codigoGeneral = $resultado->fetch_array(MYSQLI_ASSOC);

ob_start();
?>

<p class="font-md">Tabla dominio: <?= $datos_codigoGeneral["COD_TABLA"] ?></p>

<form id="formModificarCodigoGeneral" class="form-horizontal">
  <table class="table table-hover table-bordered">
  <tr>
      <td>Código elemento:</td>
      <td><?= $datos_codigoGeneral["CODIGO"] ?></td>
    </tr>
    <tr>
      <td>Descripción elemento:</td>
      <td>
        <textarea name="DESCRIPCION_CG" class="form-control" placeholder="Descripción del código"><?= $datos_codigoGeneral['DESCRIPCION_CG'] ?></textarea>
      </td>
    </tr>
    <tr>
      <td>Atributo:</td>
      <td><input type="text" name="ATRIBUTO1" class="form-control" placeholder="Atributo del código" value="<?= $datos_codigoGeneral['ATRIBUTO1'] ?>" /></td>
    </tr>
    <tr>
      <td colspan="2" align="center">
        <a class="btn btn-primary btn-sm btn-modificarCodigoGeneral"><i class="fa fa-lg fa-save"></i> Grabar</a>
      </td>
    </tr>
  </table>
  <input type="hidden" name="formModificarCodigoGeneral" value="formModificarCodigoGeneral" />
  <input type="hidden" name="ID_CODIGO" value="<?= $idCodigoGeneral ?>" />
</form>

<?php
$contenido = ob_get_contents();
ob_end_clean();

$ui = new SmartUI;
$options = array("editbutton" => false);
$widget = $ui->create_widget($options);

$widget->header = array(
  "title" => $datos_pantallas[$pantalla_actual]['body_title'],
  "icon" => 'fa fa-cog',
  'toolbar' => array(
    array(
      "id" => "toolbar-id",
      "content" => '<a href="#"  data-toggle="modal" data-target="#myModalNew"></a>',
      "class" => 'smart-form'
    )
  )
);
$widget->body('content', $contenido);
?>

<div id="main" role="main">
  <?php

  include("../inc/ribbon.php");
  ?>

  <div id="content">
    <?php
    $widget->print_html();
    ?>
  </div>
</div>

<?php
include("../inc/footer.php");
include("../inc/scripts.php");
?>

<!-- PAGE RELATED PLUGIN(S)
<script src="<?= ASSETS_URL ?>/js/plugin/YOURJS.js"></script>-->

<script>
  $(document).ready(function() {
    $('.btn-modificarCodigoGeneral').on('click', function() {
      if (confirm("¿Desea modificar este código general?")) {
        $.post("sql_cod.php", $("#formModificarCodigoGeneral").serialize(), function(data) {
          if (data.exito) {
            exito(data.mensaje);
            location.reload();
            // window.location.href = "l_codigos.php?id=" + data.idDominioInsertado;
          } else {
            error(data.mensaje);
          }
        }, 'json');
      }
    });
  });
</script>

<?php
//include footer
include("../inc/google-analytics.php");
?>