<?php
$pantalla_actual = 'MOD_DOM';
define('PERMITIDO', true);
require_once("../inc/init.php");
require_once("../inc/config.ui.php");
$page_title = $datos_pantallas[$pantalla_actual]['page_title'];
$page_css[] = "your_style.css";
include("../inc/header.php");
include("../inc/nav.php");

$idTablaGeneral = isset($_GET['idTablaGeneral']) ? $_GET['idTablaGeneral'] : "-1";

$stmt = $mysqli->prepare("SELECT * FROM tablas_generales WHERE ID_TG = ?");
$stmt->bind_param("i", $idTablaGeneral);
$stmt->execute();
$resultado = $stmt->get_result();
$datos = $resultado->fetch_array(MYSQLI_ASSOC);

ob_start();
?>

<form id="formModificarTablaGeneral" class="form-horizontal">
  <table class="table table-hover table-bordered">
    <tr>
      <td width="83">Código:</td>
      <td width="405">
        <input type="text" name="COD_TABLA" readonly class="form-control" value="<?= $datos['COD_TABLA'] ?>" required />
    </tr>
    <tr>
      <td>Descripción:</td>
      <td>
        <input type="text" name="DESCRIPCION_TG" class="form-control" value="<?= $datos['DESCRIPCION_TG'] ?>" required />
      </td>
    </tr>
    <tr>
      <td>Tipo Tabla:</td>
      <td>
        <select name="ATRIBUTO1" class="form-control">
          <option value="S" <?= ($datos['ATRIBUTO1'] == "S") ? "selected" : "" ?>>SISTEMA</option>
          <option value="V" <?= ($datos['ATRIBUTO1'] == "V") ? "selected" : "" ?>>VALIDACIÓN</option>
          <option value="A" <?= ($datos['ATRIBUTO1'] == "A") ? "selected" : "" ?>>ARQUITECTURA</option>
        </select>
      </td>
    </tr>
    <tr>
      <td colspan="2" align="center">
        <a class="btn btn-primary btn-sm btn-modificarTablaGeneral"><i class="fa fa-lg fa-save"></i> Grabar</a>
      </td>
    </tr>
  </table>
  <input type="hidden" name="formModificarTablaGeneral" value="formModificarTablaGeneral" />
  <input type="hidden" name="ID_TG" value="<?= $datos['ID_TG']; ?>" />
</form>

<?php
$contenido = ob_get_contents();
ob_end_clean();

$ui = new SmartUI;
$options = array("editbutton" => false);
$widget = $ui->create_widget($options);

$widget->header = array(
  "title" => $datos_pantallas[$pantalla_actual]['body_title'],
  "icon" => 'fa fa-cog',
  'toolbar' => array(
    array(
      "id" => "toolbar-id",
      "content" => '<a href="#"  data-toggle="modal" data-target="#myModalNew"></a>',
      "class" => 'smart-form'
    )
  )
);
$widget->body('content', $contenido);
?>

<div id="main" role="main">
  <?php
  include("../inc/ribbon.php");
  ?>

  <div id="content">
    <?php
    $widget->print_html();
    ?>
  </div>
</div>

<?php
// include page footer
include("../inc/footer.php");
?>
<!-- END PAGE FOOTER -->

<?php
//include required scripts
include("../inc/scripts.php");
?>

<!-- PAGE RELATED PLUGIN(S)
<script src="<?= ASSETS_URL; ?>/js/plugin/YOURJS.js"></script>-->

<script>
  $(document).ready(function() {
    $('.btn-modificarTablaGeneral').on('click', function() {
      if (confirm("¿Desea modificar esta tabla general?")) {
        $.post("sql_cod.php", $("#formModificarTablaGeneral").serialize(), function(data) {
          if (data.exito) {
            exito(data.mensaje);
            window.location.href = "l_tablas.php";
          } else {
            error(data.mensaje);
          }
        }, 'json');
      }
    });
  });
</script>

<?php
//include footer
include("../inc/google-analytics.php");
?>