<?php
$pantalla_actual = 'LIS_ELE_DOM';
define('PERMITIDO', true);
$hora = time();
require_once("../inc/init.php");
require_once("../inc/config.ui.php");
$page_title = $datos_pantallas[$pantalla_actual]['page_title'];
$page_css[] = "your_style.css";
include("../inc/header.php");
include("../inc/nav.php");

$idTablaGeneral = isset($_GET['idTablaGeneral']) ? $_GET['idTablaGeneral'] : "-1";

$stmt = $mysqli->prepare("SELECT ID_TG, DESCRIPCION_TG, COD_TABLA FROM tablas_generales WHERE ID_TG = ?");
$stmt->bind_param("i", $idTablaGeneral);
$stmt->execute();
$resultado = $stmt->get_result();
$datos_tablaGeneral = $resultado->fetch_array(MYSQLI_ASSOC);

$stmt = $mysqli->prepare("SELECT * FROM codigos_generales
WHERE COD_TABLA = ?");
$stmt->bind_param("s", $datos_tablaGeneral['COD_TABLA']);
$stmt->execute();
$resultado = $stmt->get_result();
$datos_codigosGeneralesTabla = $resultado->fetch_all(MYSQLI_ASSOC);

ob_start();
?>

<div class="well well-sm bg-color-blue txt-color-white font-md">
	<div class="row">
		<section class="col-md-12">
			Tabla: <?= $datos_tablaGeneral['COD_TABLA'] ?>
		</section>
	</div>
	<div class="row">
		<section class="col-md-12">
			Descripción: <?= $datos_tablaGeneral['DESCRIPCION_TG'] ?>
		</section>
	</div>
</div>
<br>

<table id="dataTable-codigosGenerales" class="table table-hover table-bordered">
	<thead>
		<tr>
			<th>Código</th>
			<th>Descripción código</th>
			<th>Atributo adicional</th>
			<th style="width:9em;">Acciones</th>
		</tr>
	</thead>
	<tbody>
		<?php foreach ($datos_codigosGeneralesTabla as $data_codigosGeneralesTabla) {
			$strike = $data_codigosGeneralesTabla['FLAG_ELIMINADO'] ? 'style="text-decoration:line-through;"' : "";
		?>
			<tr>
				<td <?= $strike ?>><?= $data_codigosGeneralesTabla['CODIGO'] ?></td>
				<td <?= $strike ?>><?= $data_codigosGeneralesTabla['DESCRIPCION_CG'] ?></td>
				<td <?= $strike ?>><?= $data_codigosGeneralesTabla['ATRIBUTO1'] ?></td>
				<td>
					<a class="btn btn-link" href="e_codigo.php?idTablaGeneral=<?= $datos_tablaGeneral['ID_TG'] ?>&idCodigoGeneral=<?= $data_codigosGeneralesTabla['ID_CODIGO'] ?>"><i class="fa fa-edit fa-lg"></i></a>
					<a class="btn btn-link btn-eliminarCodigoGeneral" data-id="<?= $data_codigosGeneralesTabla['ID_CODIGO'] ?>"><i class="fa fa-trash-o fa-lg txt-color-red"></i></a>
				</td>
			</tr>
		<?php } ?>
	</tbody>
</table>

<?php
$contenido = ob_get_contents();
ob_end_clean();

$ui = new SmartUI;
$options = array("editbutton" => false);
$widget = $ui->create_widget($options);

$widget->header = array(
	"title" => $datos_pantallas[$pantalla_actual]['body_title'],
	"icon" => 'fa fa-cog',
	'toolbar' => array(
		array(
			"id" => "toolbar-id",
			"content" => '<a href="n_codigo.php?idTablaGeneral=' . $datos_tablaGeneral['ID_TG'] . '&codigoTablaGeneral=' . $datos_tablaGeneral['COD_TABLA'] . '" class="btn btn-success"><i class="fa fa-plus"></i> Agregar</a>',
			"class" => 'smart-form'
		)
	)
);
$widget->body('content', $contenido);
?>

<div id="main" role="main">
	<?php
	include("../inc/ribbon.php");
	?>

	<div id="content">
		<?php
		$widget->print_html();
		?>
	</div>
</div>

<?php
include("../inc/footer.php");
include("../inc/scripts.php");
?>


<script>
	$(document).ready(function() {
		var order = [0, "asc"];
		var columnasNoOrdenables = [3];
		inicializarDataTables('dataTable-codigosGenerales', order, columnasNoOrdenables);

		$('.btn-eliminarCodigoGeneral').on('click', function() {
			if (confirm('¿Desea eliminar este código general?')) {
				$.post("sql_cod.php", {
					eliminarCodigoGeneral: '1',
					idCodigoGeneral: $(this).data('id')
				}, function(data) {
					if (data.exito) {
						exito();
						location.reload();
					} else {
						error("Error: " + data.mensaje);
					}
				}, 'json');
			}
		});
	});
</script>

<?php
include("../inc/google-analytics.php");
?>