<?php
define('PERMITIDO', true);
$pantalla_actual = 'LIS_DOM';
require_once("../inc/init.php");
require_once("../inc/config.ui.php");
$page_title = $datos_pantallas[$pantalla_actual]['page_title'];
$page_css[] = "your_style.css";
include("../inc/header.php");
$page_nav['Admin_Sistema']['sub']['tablas']["active"] = true;
include("../inc/nav.php");

$stmt = $mysqli->prepare("SELECT * 
FROM tablas_generales 
WHERE ATRIBUTO1 != 'E' 
ORDER BY DESCRIPCION_TG ASC");
$stmt->execute();
$resultado = $stmt->get_result();
$datos = $resultado->fetch_all(MYSQLI_ASSOC);

ob_start();
?>

<table class="table table-hover table-bordered" id="dataTables-example">
  <thead>
    <tr>
      <th>Código de la tabla</th>
      <th>Descripción</th>
      <th style="width:9em;">Acciones</th>
    </tr>
  </thead>
  <tbody>
    <?php foreach ($datos as $data) { ?>
      <tr>
        <td><?= $data['COD_TABLA'] ?></td>
        <td><?= $data['DESCRIPCION_TG'] ?></td>
        <td align="center">
          <?php if ($data['ATRIBUTO1'] != 'A' || ($usuario_perfil == 'ADMINISTRADOR' && $data['ATRIBUTO1'] == 'A')) { ?>
            <a class="btn btn-link btn-sm" href="e_tabla.php?idTablaGeneral=<?= $data['ID_TG'] ?>"><i class="fa fa-edit fa-lg"></i></a>
            <a class="btn btn-link btn-sm" href="l_codigos.php?idTablaGeneral=<?= $data['ID_TG'] ?>"><i class="fa fa-list-ul fa-lg"></i></a>
          <?php } else {
            echo 'Tabla Arquitectura';
          } ?>
        </td>
      </tr>
    <?php } ?>
  </tbody>
</table>

<?php
$botonAgregar = '';
if ($usuario_perfil == 'ADMINISTRADOR') {
  $botonAgregar = '<a href="n_tabla.php" class="btn btn-success"><i class="fa fa-plus"></i> Ingresar</a>';
}

$contenido = ob_get_contents();
ob_end_clean();

$ui = new SmartUI;
$options = array("editbutton" => false);
$widget = $ui->create_widget($options);

$widget->header = array(
  "title" => $datos_pantallas[$pantalla_actual]['body_title'],
  "icon" => 'fa fa-cog',
  'toolbar' => array(
    array(
      "id" => "toolbar-id",
      "content" => $botonAgregar,
      "class" => 'smart-form'
    )
  )
);
$widget->body('content', $contenido);
?>

<div id="main" role="main">
  <?php include("../inc/ribbon.php");
  ?>

  <div id="content">
    <?php
    $widget->print_html();
    ?>
  </div>
</div>

<?php
include("../inc/footer.php");
include("../inc/scripts.php");
?>

<!-- PAGE RELATED PLUGIN(S)
<script src="<?= ASSETS_URL ?>/js/plugin/YOURJS.js"></script>-->

<script>
  // PAGE RELATED SCRIPTS
  $(document).ready(function() {
    $('#dataTables-example').DataTable({
      'lengthMenu': [
        [5, 10, 20, 50, 100],
        [5, 10, 20, 50, 100]
      ],
      'language': {
        "sProcessing": "Procesando...",
        "sZeroRecords": "No se encontraron resultados",
        "sInfoPostFix": "",
        "sUrl": "",
        "oPaginate": {
          "sFirst": "Primero",
          "sPrevious": "Anterior",
          "sNext": "Siguiente",
          "sLast": "Último"
        },
        "sInfo": "_START_ a _END_ de _TOTAL_ Registros",
        "sInfoEmpty": "0 Registros",
        "sInfoFiltered": "(de _MAX_ Registros en total)",
        "sLengthMenu": "Mostrar _MENU_ Registros",
        "sSearch": "Buscar: "
      },
      'pageLength': 50,
      'order': [0, "asc"],
      'columns': [
        null,
        null,
        {
          "orderable": false
        }
      ],
      'destroy': true
    }); //DataTables
  });
</script>


<?php
//include footer
include("../inc/google-analytics.php");
?>