<?php
$pantalla_actual = 'LIS_USU';
define('PERMITIDO', true);
require_once("../inc/init.php");
require_once("../inc/config.ui.php");
$page_title = $datos_pantallas[$pantalla_actual]['page_title'];
$page_css[] = "your_style.css";
include("../inc/header.php");
include("../inc/nav.php");

$filtroPaciente = " AND u.PERFIL != 'PACIENTE'";
if (isset($_GET['pacientes'])) $filtroPaciente = " AND u.PERFIL = 'PACIENTE'";

$qUsuarios = $mysqli->prepare("SELECT u.ID_USUARIO, u.NRO_RUT, u.DV_RUT, CONCAT_WS(' ',u.NOMBRES, u.APELLIDO_PATERNO, u.APELLIDO_MATERNO),
u.FONO, u.MAIL, u.USUARIO, cc.NOMBRE, u.PERFIL, u.CONTRASENA, u.ACTIVO
FROM usuarios u
LEFT JOIN centros_contacto cc ON u.ID_CENTRO_COSTOS = cc.ID_CENTRO_CONTACTO
WHERE u.USUARIO != 'ADMIN_RIPIT' $filtroPaciente");
echo $mysqli->error;
$qUsuarios->execute();
$qUsuarios->bind_result($u_id, $u_nroRut, $u_dvRut, $u_nombre, $u_fono, $u_mail, $u_usuario, $u_centroCostos, $u_perfil, $u_contrasena, $flag_activo);
$qUsuarios->store_result();

ob_start();
?>

<table class="table table-hover table-bordered" id="dataTables-usuarios">
	<thead>
		<tr>
			<th>RUT</th>
			<th>Nombre</th>
			<th>Nombre de usuario</th>
			<th>Perfil</th>
			<th>Fono</th>
			<th>E-mail</th>
			<th>Centro contacto</th>
			<th>Estado</th>
			<th>Acciones</th>
		</tr>
	</thead>
	<tbody>
		<?php while ($qUsuarios->fetch()) { ?>
			<tr>
				<td><?= number_format($u_nroRut, 0, ',', '.'); ?>-<?= $u_dvRut; ?></td>
				<td><?= $u_nombre ?></td>
				<td title="<?= $usuario_perfil == "ADMINISTRADOR" ? $u_contrasena : "" ?>"> <?= $u_usuario ?> </td>
				<td><?= $u_perfil ?></td>
				<td><?= $u_fono ? $u_fono : "-" ?></td>
				<td><?= $u_mail ? $u_fono : "-" ?></td>
				<td><?= $u_centroCostos ? $u_fono : "-" ?></td>
				<td><?= $flag_activo == "S" ? "<span class='badge bg-color-green'>Activo</span>" : "<span class='badge bg-color-red'>Eliminado</span>" ?></td>
				<td>
					<div class="btn-group" role="group">
						<a class="btn btn-link" href="e_usuario.php?idus=<?= $u_id ?>"><i class="fa fa-edit fa-lg"></i></a>
						<?php
						if ($flag_activo == "S") echo "<a class='btn btn-link btn-eliminar txt-color-red' data-id='$u_id'><i class='fa fa-trash-o fa-lg'></i></a>";
						else 										 echo "<a class='btn btn-link btn-restaurar txt-color-green' data-id='$u_id'><i class='fa fa-arrow-circle-up fa-lg'></i></a>";
						?>
					</div>
				</td>
			</tr>
		<?php }
		$qUsuarios->close(); ?>
	</tbody>
</table>

<?php
$contenido = ob_get_contents();
ob_end_clean();

if (isset($_GET['pacientes'])) $boton = '<a href="l_usuarios.php" class="btn btn-warning"><i class="fa fa-eye"></i> Ver Usuarios Internos </a>';
else 													 $boton = '<a href="l_usuarios.php?pacientes=1" class="btn btn-warning"><i class="fa fa-eye"></i> Ver Pacientes </a>';

$ui = new SmartUI;
$options = array("editbutton" => false);
$widget = $ui->create_widget($options);
$widget->header = array(
	"title" => $datos_pantallas[$pantalla_actual]['body_title'],
	"icon" => 'fa fa-cog',
	'toolbar' => array(
		array(
			"id" => "toolbar-id",
			"content" => '<a href="n_usuario.php" class="btn btn-success"><i class="fa fa-plus"></i> Agregar </a>',
			"class" => 'smart-form'
		),
		array(
			"id" => "toolbar-id",
			"content" => $boton,
			"class" => 'smart-form'
		)
	)
);
$widget->body('content', $contenido);
?>

<div id="main" role="main">
	<?php
	include("../inc/ribbon.php");
	?>

	<div id="content">
		<?php
		$widget->print_html();
		?>
	</div>
</div>

<?php
include("../inc/footer.php");
include("../inc/scripts.php");
?>

<script>
	$(document).ready(function() {

		var order = [2, "asc"];
		var columnasNoOrdenables = [7, 8];
		inicializarDataTables('dataTables-usuarios', order, columnasNoOrdenables);

		$('.btn-eliminar').on('click', function() {
			if (confirm('¿Desea eliminar al usuario?')) {
				$.post("sql_cod.php", {
					idus: $(this).data('id'),
					eliminarUsuario: '1'
				}, function(data) {
					if (data.exito) {
						exito();
						location.reload();
					} else {
						error("Error: " + data.mensaje);
					}
				}, 'json');
			}
		});

		$('.btn-restaurar').on('click', function() {
			if (confirm('¿Desea restaurar al usuario?')) {
				$.post("sql_cod.php", {
					idus: $(this).data('id'),
					restaurarUsuario: '1'
				}, function(data) {
					if (data.exito) {
						exito();
						location.reload();
					} else {
						error("Error: " + data.mensaje);
					}
				}, 'json');
			}
		});
	});
</script>


<?php
include("../inc/google-analytics.php");
?>