<?php
$pantalla_actual = 'ING_USU';
$hora = time();
define('PERMITIDO', true);
require_once("../inc/init.php");
require_once("../inc/config.ui.php");
$page_title = $datos_pantallas[$pantalla_actual]['page_title'];
$page_css[] = "your_style.css";
include("../inc/header.php");
include("../inc/nav.php");

$qPerfilesUsuario = $mysqli->prepare("SELECT CODIGO, DESCRIPCION_CG FROM codigos_generales WHERE COD_TABLA = 'SIS_PERFIL'");
$qPerfilesUsuario->execute();
$qPerfilesUsuario->bind_result($codigo, $descripcion_cg);
$qPerfilesUsuario->store_result();
while ($qPerfilesUsuario->fetch()) {
  $options_perfilesUsuario .= "<option value='$descripcion_cg'> $descripcion_cg </option>";
}
$qPerfilesUsuario->close();

$qCentrosContacto = $mysqli->prepare("SELECT ID_CENTRO_CONTACTO, NOMBRE FROM centros_contacto");
$qCentrosContacto->execute();
$qCentrosContacto->bind_result($id_centro_contacto, $nombre_centro_contacto);
$qCentrosContacto->store_result();
while ($qCentrosContacto->fetch()) {
  $options_centroContacto .= "<option value='$id_centro_contacto'> $nombre_centro_contacto </option>";
}
$qCentrosContacto->close();

$qUsuariosCreados = $mysqli->prepare("SELECT ID_USUARIO FROM usuarios 
WHERE ACTIVO = 'S'
AND PERFIL NOT IN ('ADMINISTRADOR', 'PACIENTE') 
AND USUARIO != ''");
$qUsuariosCreados->execute();
$qUsuariosCreados->store_result();
$totalRows_usuariosCreados = $qUsuariosCreados->num_rows;
$qUsuariosCreados->close();

ob_start();
?>

<form id="formAgregarUsuario" class="form-inline">
  <table style="width:50%" class="table table-bordered table-responsive">
    <tr>
      <td>Nombres:</td>
      <td><input type="text" class="form-control" required="required" placeholder="Nombres" Nombres name="NOMBRES"/></td>
    </tr>
    <tr>
      <td>Apellido Paterno:</td>
      <td><input type="text" class="form-control" required="required" placeholder="Apellido Paterno" name="APELLIDO_PATERNO"/></td>
    </tr>
    <tr>
      <td>Apellido Materno:</td>
      <td><input type="text" class="form-control" placeholder="Nombre Materno" name="APELLIDO_MATERNO"></td>
    </tr>
    <tr>
      <td>RUT:</td>
      <td>
        <input type="text" class="form-control" required="required" placeholder="RUT" name="NRO_RUT" style="width:120px" />
        -
        <input name="DV_RUT" class="form-control" required="required" type="text" style="width:4em" />
      </td>
    </tr>
    <tr>
      <td>Usuario:</td>
      <td>
        <input type="text" class="form-control" placeholder="Nombre de Usuario" name="USUARIO" required="required" value="" /> <?php echo $resultado; ?>
    </tr>
    <tr>
      <td>Contraseña:</td>
      <td>
        <input type="password" class="form-control" name="CONTRASENA" required="required" placeholder="Contraseña" value="" size="20" />
      </td>
    </tr>
    <tr>
      <td>Repetir Contraseña:</td>
      <td>
        <input type="password" class="form-control" placeholder="Repita Contraseña" required="required" name="CONTRASENA2" value="" size="20" />
      </td>
    </tr>
    <tr>
      <td>Perfil:</td>
      <td>
        <select name="PERFIL" class="form-control">
          <option value="">-</option>
          <?= $options_perfilesUsuario ?>
        </select>
      </td>
    </tr>
    <tr>
      <td>Centro de Costos</td>
      <td>
        <select name="ID_CENTRO_COSTOS" class="form-control">
          <option value="">-</option>
          <?= $options_centroContacto ?>
        </select>
      </td>
    </tr>
    <tr>
      <td colspan="2" align="center">
        <?php if ($usuario_perfil == 'ADMINISTRADOR' || $totalRows_usuariosCreados < $ps_nUsers) { ?>
          <a class="btn btn-primary btn-sm btn-grabar">
            <i class="fa fa-save"></i> Grabar
          </a>
        <?php } else {
          echo 'Capacidad Máxima de Usuarios Alcanzada!';
        } ?>
        <br>
        <div class="note">
          <?= "Usuarios Activos en Sistema: $totalRows_usuariosCreados de $ps_nUsers" ?>
        </div>
      </td>
    </tr>
  </table>
  <input type="hidden" name="formAgregarUsuario" value="formAgregarUsuario" />
  <input type="hidden" name="$id_nuevo_usuario" value="USUARIO" />
</form>

<?php
$contenido = ob_get_contents();
ob_end_clean();

$ui = new SmartUI;
$options = array("editbutton" => false);
$widget = $ui->create_widget($options);

$widget->header = array(
  "title" => $datos_pantallas[$pantalla_actual]['body_title'],
  "icon" => 'fa fa-cog'
);
$widget->body('content', $contenido);
?>

<div id="main" role="main">
  <?php
  include("../inc/ribbon.php");
  ?>

  <div id="content">
    <?php
    $widget->print_html();
    ?>
  </div>
</div>

<?php
include("../inc/footer.php");
include("../inc/scripts.php");
?>

<script>
  $(document).ready(function() {
    $('.btn-grabar').on('click', function() { //agregar actividad
      $.post('sql_cod.php', $('#formAgregarUsuario').serialize(), function(data) {
        if (data.exito) {
          exito();
          window.location.href = 'l_usuarios.php';
        } else {
          error("Error: " + data.mensaje);
        }
      }, 'json');
    });
  });
</script>


<?php
include("../inc/google-analytics.php");
?>