<?php
$pantalla_actual = 'CON_EGRE';
define('PERMITIDO', true);
require_once("../inc/init.php");
require_once("../inc/config.ui.php");
$tiempo = time(); 
$hoy=date('Y-m-d', $tiempo);
$page_title = $datos_pantallas[$pantalla_actual]['page_title'];
$page_css[] = "your_style.css";
include("../inc/header.php");
include("../inc/nav.php");



$qegresos=$mysqli->prepare('SELECT e.ID_EG, e.N_BOLETA, e.MONTO, e.TIPO_EGRESO, e.OBSERVACION, usuarios.USUARIO, DATE_FORMAT(e.FECHA,\'%d-%m-%Y\'), LEFT (OBSERVACION,20), em.NOMBRE_E 
							FROM egresos e
							INNER JOIN usuarios ON e.ID_CAJERO=usuarios.ID_USUARIO 
							LEFT JOIN empresas em ON e.ID_PROVEEDOR=em.ID_EMPRESA							 
							ORDER BY ID_EG DESC');
$qegresos->bind_param('i',$usuario_id);
$qegresos->execute();
$qegresos->bind_result($e_id, $e_nBoleta, $e_monto, $e_tipoEgreso, $e_obs, $e_usuario, $e_fecha, $e_obs, $e_proveedor);
$qegresos->store_result();
$totalRows_egresos=$qegresos->num_rows;


$qproveedores=$mysqli->prepare('SELECT ID_EMPRESA, NOMBRE_E FROM empresas WHERE empresas.FLAG_PROVEEOR=\'S\'');
$qproveedores->execute();
$qproveedores->bind_result($prov_id, $prov_nombre);
$options_proveedores='<option value="">--Seleccione--</option>';
	while($qproveedores->fetch()){
		$options_proveedores.='<option value="'.$prov_id.'">'.$prov_nombre.'</option>';
	}$qproveedores->close();


$qtiposEgresos=$mysqli->prepare('SELECT CODIGO, DESCRIPCION_CG FROM codigos_generales WHERE COD_TABLA=\'SIS_TIPEGR\' ORDER BY DESCRIPCION_CG');
$qtiposEgresos->execute();
$qtiposEgresos->bind_result($te_id, $te_nombre);
$options_tiposEgresos='<option value="">--Seleccione--</option>';
	while($qtiposEgresos->fetch()){
		$options_tiposEgresos.='<option value="'.$te_nombre.'">'.$te_nombre.'</option>';		
	}$qtiposEgresos->close();

ob_start();
?>

<table class="table table-hover table-bordered" id="DTE">
  <thead>
    <tr>
      <th>Fecha</th>
      <th>Usuario</th>
      <th>Tipo de Egreso</th>
      <th>Boleta</th>
      <th>Monto</th>
      <th>Proveedor</th>
      <th>Observaciones</th>
      <th>Acciones</th>
    </tr>
    </thead>
    <tbody>
    <?php 
	if($totalRows_egresos>0){
	while($qegresos->fetch()) { ?>
      <tr>
        <td><?php echo $e_fecha; ?></td>
        <td><?php echo $e_usuario; ?></td>
        <td><?php echo $e_tipoEgreso; ?></td>
        <td><?php echo $e_nBoleta; ?></td>
        <td><?php if($e_monto!='') echo '$'.number_format($e_monto,0,',','.'); ?></td>
        <td><?php echo $e_proveedor; ?></td>
        <td><?php echo $e_obs; ?></td>
        <td align="center">
        	<a style="padding:0" class="btn btn-link" data-toggle="modal" data-target="#myModalEdit" href="md_e_egreso.php?ideg=<?php echo $e_id; ?>"><i class="fa fa-edit fa-lg"></i></a>
			<a style="padding:0" class="btn btn-link" data-id=<?php echo $e_id?>><i class="fa fa-remove fa-lg"></i></a>
        </td>
      </tr>
      <?php 
	  }$qegresos->close();
	  } ?>   
      </tbody>
</table>

<?php
$contenido = ob_get_contents();
ob_end_clean();

$ui = new SmartUI;
$options = array("editbutton" => false);
$widget = $ui->create_widget($options);

$widget->header = array(
    "title" => $datos_pantallas[$pantalla_actual]['body_title'],
    "icon" => 'fa fa-cog',
	'toolbar' => array(
		array(
			"id" => "toolbar-id",
			"content" => '<a href="#" class="btn btn-success" data-toggle="modal" data-target="#myModalNew" >Agregar</a>',
			"class" => 'smart-form'
		)
	)
);
$widget->body('content', $contenido);
?>

<div id="main" role="main">
	<?php include("../inc/ribbon.php");	?>

	<!-- MAIN CONTENT -->
    <div id="content">	
		<?php
            $widget->print_html();
        ?>
	</div>
    		<!-- modal Edit-->
<!-- END MAIN PANEL -->
</div>
<!-- ==========================CONTENT ENDS HERE ========================== -->
<div class="modal fade Edit" id="myModalEdit" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
    <div class="modal-dialog">    
        <div class="modal-content"> 
        </div>
    </div>
</div>    

<div class="modal fade New" id="myModalNew" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
    <div class="modal-dialog">    
        <div class="modal-content">        
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-hidden="true">
                    &times;
                </button>
                <h4 class="modal-title" id="myModalLabel">Registro de Egreso</h4>
            </div>
            
            <div class="modal-body">	
        	<form action="sql_cod.php" name="formInsertE" id="formInsertE" method="post" class="smart-form"> 
            <fieldset style="padding-top:0;">                       	
				<div class="row">
                    <section class="col-md-2">
                        <label class="label">
                            Fecha
                        </label>
                    </section>
                    <section class="col-md-4">                     
                        <label class="input">
                             <input type="text" class="input-md"  data-mask="99-99-9999" id="fecha" name="FECHA" />
                        </label>    
                    </section>
                 </div>
                 <div class="row">
                    <section class="col-md-2">
                        <label class="label">
                            Tipo Egreso
                        </label>  
                    </section>
                    <section class="col-md-4">                                   
                        <label class="select">
                        	<select name="TIPO_EGRESO">
                        		<?php echo $options_tiposEgresos?>
                            </select> 
                            <i></i>
                        </label>
                    </section>
                    <section class="col-md-2"> 
                        <label class="label" style="padding-left:1em;">
                            Proveedor
                        </label>                       
                    </section>
                    <section class="col-md-4">                 
                        <label class="select">
                        	<select name="ID_PROVEEDOR">
                        		<?php echo $options_proveedores?>
                            </select> 
                            <i></i>
                        </label>
                    </section>
                 </div>    
                 <div class="row">
                    <section class="col-md-2">
                        <label class="label">
                            Nro Boleta
                        </label>  
                    </section>
                    <section class="col-md-4">                                   
                        <label class="input">
								<input type="text" class="input-sm" name="N_BOLETA" />
                        </label>
                    </section>
                    <section class="col-md-2"> 
                        <label class="label" style="padding-left:1em;">
                            Monto
                        </label>                       
                    </section>
                    <section class="col-md-4">                 
                        <label class="input">
							<input type="text" class="input-sm" name="MONTO" />
                        </label>
                    </section>
                 </div>  
                 <div class="row">
                    <section class="col-md-2">
                        <label class="label">
                            Observaciones
                        </label>  
                    </section>
                    <section class="col-md-10">                                   
                        <label class="textarea">
								<textarea rows="3" name="OBSERVACION" ></textarea>
                        </label>
                    </section>
                 </div>                                          
            <input type="hidden" name="insertEgreso" value="formInsertE" />   
            </fieldset>
            </form>               
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal">
                    Cancelar
                </button>
                <button type="submit" class="btn btn-success btn-sm pull-right" id="grabar">
                   <i class="fa fa-save"></i> Grabar
                </button>    
            </div>
        </div><!-- /.modal-content -->        
    </div><!-- /.modal-dialog -->
</div><!-- modal -->


<?php
	// include page footer
	include("../inc/footer.php");
?>
<!-- END PAGE FOOTER -->

<?php 
	//include required scripts
	include("../inc/scripts.php");
?>

<!-- PAGE RELATED PLUGIN(S) 
<script src="<?php echo ASSETS_URL; ?>/js/plugin/YOURJS.js"></script>-->
<script src="<?php echo ASSETS_URL; ?>/js/dtfecha.js"></script>
<script>
$(document).ready(function(){
    
	$('#DTE').DataTable({	
		 'lengthMenu': [[50, 100, 200], [50, 100, 200]],
		 'language': {
				"sProcessing":   "Procesando...",
				"sZeroRecords":  "No se encontraron resultados",
				"sInfoPostFix":  "",
				"sUrl":          "",
				"oPaginate": {
					"sFirst":    "Primero",
					"sPrevious": "Anterior",
					"sNext":     "Siguiente",
					"sLast":     "Último"
				},
			 "sInfo": "_START_ a _END_ de _TOTAL_ Registros",
			 "sInfoEmpty":    "0 Registros",
			 "sInfoFiltered": "(de _MAX_ Registros en total)",
			 "sLengthMenu":"Mostrar _MENU_ Registros",
			 "sSearch":"Buscar: "
		 },
		 'pageLength' : 50,
		 'order' : [ 0, "desc" ],
		 'columns': [
			 {type: 'date-eu'},
			 null,
			 null,
			 null,
			 null,
			 null,
			 null,
			 {"orderable": false}
		 ],
		 'destroy': true
	});//DataTables

	$(function() {			
			$("#fecha").datepicker();			
  	});
	
	$("#formInsertE").validate({
			rules : {				
				FECHA : {
					required : true
				},
				TIPO_EGRESO : {
					required : true
				},
				ID_PROVEEDOR : {
					required : true
				},
				N_BOLETA : {
					required : true
				},
				MONTO : {
					required : true
				}										
			},
			messages : {				
				FECHA : {
					required : 'Ingrese Fecha'
				},
				TIPO_EGRESO : {
					required : 'Seleccione'
				},
				ID_PROVEEDOR : {
					required : 'Seleccione'
				},
				N_BOLETA : {
					required : 'Ingrese Nro Boleta'
				},
				MONTO : {
					required : 'Ingrese Monto'
				}
										
			},
			onfocusout: true,
			onsubmit: true,
			// Do not change code below
			errorPlacement : function(error, element) {
				error.insertAfter(element.parent());
			}
	});	

	$('#formInsertE').on('submit', function(e){
		var form = $("#formInsertE");
		if(form.valid()){	
			$.post($(form).attr('action'), $(form).serialize(), function(data){
				if(data.exito){
					exito();
					location.reload();						
				}else{
					error(data.mensaje);
				}
			}, 'json');
		}
		e.preventDefault();	
		return false;			
	});

	$("#grabar").click(function(){
		$("#formInsertE").submit();
	});	
	
});
						
</script>

<?php 
	//include footer
	include("../inc/google-analytics.php");
?>