<?php
define('PERMITIDO', true);
$pagina = 0;
require_once("../inc/init.php");
require_once("../inc/config.ui.php");
require_once("../lib/datos_mysql.php");
require_once('../assets/php/ssp.php');
header('Content-Type: text/html; charset=UTF-8');

$dbDetails = array(
  'host' => $hostname_conexionlab,
  'user' => $username_conexionlab,
  'pass' => $password_conexionlab,
  'db'   => $database_conexionlab,
  'charset' => 'utf8'
);

$table = <<<EOT
(
  SELECT a.ID_ATENCION, DATE_FORMAT(a.FECHA,'%d/%m/%Y') AS FECHA, a.MONTO_ATENCION, a.MONTO_PAGADO, PCTJE_DESCUENTO, MONTO_DESCUENTO, MONTO_CONDONADO, (MONTO_ATENCION - MONTO_PAGADO - MONTO_DESCUENTO - MONTO_CONDONADO - (MONTO_ATENCION*PCTJE_DESCUENTO / 100)) AS SALDO,
  ID_COBRANZA_CONVENIO, MONTO_CONVENIO, CONCAT_WS(" ", p1.NOMBRES, p1.APELLIDO_PATERNO, p1.APELLIDO_MATERNO) AS P1, p1.NRO_RUT, p1.DV_RUT, c.NOMBRE, c.ID_CENTRO_CONTACTO, c.ID_EMPRESA, conv.NOMBRE_E, conv.NBR, a.ID_CLIENTE, a.FECHA as FECHA2
  FROM atenciones a
  INNER JOIN personas p1 ON a.ID_CLIENTE = p1.ID_PERSONA
  INNER JOIN centros_contacto c ON c.ID_CENTRO_CONTACTO = a.ID_CENTRO_CONTACTO
  LEFT JOIN empresas conv ON conv.ID_EMPRESA = a.ID_CONVENIO
  WHERE a.CIERRE_ATE = 'N' AND a.MONTO_ATENCION > 0 AND a.FLAG_ELIMINADO = 0
  ORDER BY a.ID_ATENCION DESC
) temp
EOT;

// Table's primary key 
$primaryKey = 'ID_ATENCION';

// Array of database columns which should be read and sent back to DataTables. 
// The `db` parameter represents the column name in the database.  
// The `dt` parameter represents the DataTables column identifier. 
$columns = array(
  array('db' => 'ID_ATENCION', 'dt' => 0),
  array('db' => 'FECHA', 'dt' => 1),
  array('db' => 'NOMBRE', 'dt' => 2),
  array('db' => 'NBR', 'dt' => 3),
  array('db' => 'P1', 'dt' => 4),
  array(
    'db' => 'MONTO_ATENCION',
    'dt' => 5,
    'formatter' => function ($d, $row) {
      return "$ " . number_format($d, 0, ',', '.');
    }
  ),
  array(
    'db' => 'PCTJE_DESCUENTO', 
    'dt' => 6
  ),
  array(
    'db' => 'MONTO_DESCUENTO',
    'dt' => 7,
    'formatter' => function ($d, $row) {
      return "$ " . number_format($d, 0, ',', '.');
    }
  ),
  array(
    'db' => 'MONTO_CONVENIO',
    'dt' => 8,
    'formatter' => function ($d, $row) {
      if ($row['ID_COBRANZA_CONVENIO']) {
        return "$ " . number_format($d, 0, ',', '.') . "<a class='btn btn-link pull-right' data-toggle='tooltip' data-content='Cobrado' data-trigger='hover'> <i class='fa fa-check txt-color-green'></i> </a>";
      } else {
        return "$ " . number_format($d, 0, ',', '.') . "<a class='btn btn-link pull-right' data-toggle='tooltip' data-content='Cobro Pendiente' data-trigger='hover'> <i class='fa fa-exclamation txt-color-red'></i> </a>";
      }
    }
  ),
  array(
    'db' => 'MONTO_CONDONADO',
    'dt' => 9,
    'formatter' => function ($d, $row) {
      return "$ " . number_format($d, 0, ',', '.');
    }
  ),
  array(
    'db' => 'MONTO_PAGADO',
    'dt' => 10,
    'formatter' => function ($d, $row) {
      return "$ " . number_format($d, 0, ',', '.');
    }
  ),
  array(
    'db' => 'SALDO',
    'dt' => 11,
    'formatter' => function ($d, $row) {
      if ($row['ID_COBRANZA_CONVENIO']) {
        $saldo = $row['SALDO'] - $row['MONTO_CONVENIO'];
        return "$ " . number_format($saldo, 0, ',', '.');
      } else {
        return "$ " . number_format($d, 0, ',', '.');
      }
    }
  ),
  array(
    'db' => 'ID_ATENCION',
    'dt' => 12,
    'formatter' => function ($d, $row) {
      return '<a class="btn btn-link" href="d_pagos.php?idate=' .  $d . '&f_desde=' . $_POST['f_desde'] . '&f_hasta=' . $_POST['f_hasta'] . '&id_cc=' . $_POST['id_cc'] . '&id_con=' . $_POST['id_con'] . '" title="Detalle de Pagos"><i class="fa fa-list-ul fa-lg"></i></a>';
    }
  ),
  array(
    'db' => 'ID_EMPRESA', 
    'dt' => 13
  ),
  array(
    'db' => 'ID_COBRANZA_CONVENIO',
    'dt' => 14,
    'formatter' => function ($d, $row) {
      return number_format($d, 0, ',', '.');
    }
  )
);

$filtros = "";
$f_desde = isset($_POST["f_desde"]) && $_POST["f_desde"] != "" ? " AND FECHA2 >= '{$_POST["f_desde"]}'"         : "";
$f_hasta = isset($_POST['f_hasta']) && $_POST['f_hasta'] != "" ? " AND FECHA2 <= '{$_POST['f_hasta']}'"         : "";
$id_cc   = isset($_POST['id_cc'])   && $_POST['id_cc']   != "" ? " AND ID_CENTRO_CONTACTO = {$_POST['id_cc']}" : "";
$id_con  = isset($_POST['id_con'])  && $_POST['id_con']  != "" ? " AND ID_EMPRESA = {$_POST['id_con']}"        : "";


echo json_encode(
  SSP::simple(
    $_POST,
    $dbDetails,
    $table,
    $primaryKey,
    $columns,
    null,
    "1 $f_desde
    $f_hasta
    $id_cc
    $id_con"
  ),
  JSON_UNESCAPED_UNICODE
);