<?php
define('PERMITIDO', true);
$pantalla_actual = 'DET_PAG';
require_once("../inc/init.php");
require_once("../inc/config.ui.php");
$page_title = $datos_pantallas[$pantalla_actual]['page_title'];
$page_css[] = "your_style.css";
include("../inc/header.php");
include("../inc/nav.php");

$idate = isset($_GET['idate']) ? $_GET['idate'] : -1;
$filtro_desde    = isset($_GET["f_desde"]) && $_GET["f_desde"] != "" ? " AND a.FECHA >= '{$_GET["f_desde"]}'"         : "";
$filtro_hasta    = isset($_GET['f_hasta']) && $_GET['f_hasta'] != "" ? " AND a.FECHA <= '{$_GET['f_hasta']}'"         : "";
$filtro_local    = isset($_GET['id_cc'])   && $_GET['id_cc']   != "" ? " AND c.ID_CENTRO_CONTACTO = {$_GET['id_cc']}" : "";
$filtro_convenio = isset($_GET['id_con'])  && $_GET['id_con']  != "" ? " AND c.ID_EMPRESA = {$_GET['id_con']}"        : "";

$antPos = $mysqli->prepare("SELECT a.ID_ATENCION
FROM atenciones a
INNER JOIN personas p1 ON a.ID_CLIENTE = p1.ID_PERSONA
INNER JOIN centros_contacto c ON c.ID_CENTRO_CONTACTO = a.ID_CENTRO_CONTACTO
WHERE a.CIERRE_ATE = 'N' AND MONTO_ATENCION > 0 $filtro_desde $filtro_hasta $filtro_local $filtro_convenio
ORDER BY a.ID_ATENCION DESC");
$antPos->execute();
$antPos->bind_result($antpos_atenciones);

$lista = [array()];
$i = 0;
while ($antPos->fetch()) {
  if ($antpos_atenciones == $idate) $pos_act = $i;
  $lista[] = $antpos_atenciones;
  $i++;
}
$antPos->close();
# atencion anterior y posterior
$at_ant = '';
if ($pos_act != 0) $at_ant = $lista[$pos_act - 1];
$at_post = $lista[$pos_act + 1];

##############################################################################################################################################
##############################################################################################################################################
##############################################################################################################################################

$qAtencion = $mysqli->prepare("SELECT a.OBS, a.ID_PREVISION, a.ID_COBRANZA_CONVENIO, a.MONTO_ATENCION, a.MONTO_DESCUENTO, a.PCTJE_DESCUENTO, a.MONTO_CONVENIO, a.MONTO_PAGADO, a.MONTO_CONDONADO,
prev.NOMBRE_E, prev.NBR, CONCAT_WS(' ', p.NOMBRES, p.APELLIDO_PATERNO, p.APELLIDO_MATERNO), DATE_FORMAT(p.FECHA_NACIMIENTO, '%d/%m/%Y'), p.DIRECCION, p.FONO_1, p.GENERO,
cc.ID_CENTRO_CONTACTO, cc.NOMBRE 
FROM atenciones a
LEFT JOIN empresas prev ON prev.ID_EMPRESA = a.ID_PREVISION
INNER JOIN personas p ON p.ID_PERSONA = a.ID_CLIENTE
LEFT JOIN centros_contacto cc ON a.ID_CENTRO_CONTACTO = cc.ID_CENTRO_CONTACTO
WHERE ID_ATENCION = ?");
$qAtencion->bind_param('i', $idate);
$qAtencion->execute();
$qAtencion->bind_result($ate_obs, $ate_idPrevision, $ate_idCobranzaConvenio, $ate_montoAtencion, $ate_montoDescuento, $ate_pctjeDescuento, $ate_montoConvenio, $ate_montoPagado, $ate_montoCondonado,
$ate_nombrePrevision, $ate_nbrPrevision, $ate_nombrePaciente, $ate_fechaNaciemiento, $ate_direccion, $ate_fono, $ate_genero, $ate_idCentroContacto, $ate_nombreCentroContacto);
$qAtencion->store_result();
$qAtencion->fetch();
$qAtencion->close();
$labelCobranza = $ate_idCobranzaConvenio != "" ? "<span class='label label-success'>Cobrado</span>" : "<span class='label label-danger'>Cobro Pendiente</span>";
$montoAPagar = $ate_montoAtencion - $ate_montoDescuento - $ate_montoConvenio - ($ate_montoAtencion * $ate_pctjeDescuento / 100);
$montoSaldo = $montoAPagar - $ate_montoPagado;

$qPagosAtencion = $mysqli->prepare("SELECT ID_PAGOS, DATE_FORMAT(FECHA_PAGO, '%d/%m/%Y'), p.MONTO_PAGADO, NRO_DOCTO, CIERRE_INGRESO, FLAG_CIERRECAJA, FLAG_BONO_ANULADO,
cg.DESCRIPCION_CG, cg2.DESCRIPCION_CG, CONCAT_WS(' ', u.NOMBRES, u.APELLIDO_PATERNO, u.APELLIDO_MATERNO), cc.NOMBRE
FROM pagos p
INNER JOIN centros_contacto cc ON p.ID_CC = cc.ID_CENTRO_CONTACTO
LEFT JOIN codigos_generales cg ON p.FORMA_PAGO = cg.CODIGO AND cg.COD_TABLA = 'SIS_FORPAG'
LEFT JOIN codigos_generales cg2 ON p.FORMA_PAGO_IMED = cg2.ATRIBUTO1 AND cg2.COD_TABLA = 'SIS_MET_PAGO_IMED'
LEFT JOIN usuarios u ON p.ID_CAJERO = u.ID_USUARIO
INNER JOIN atenciones a ON p.ID_ATENCION = a.ID_ATENCION AND a.ID_ATENCION = ?
ORDER BY FECHA_PAGO DESC");
$qPagosAtencion->bind_param('i', $idate);
$qPagosAtencion->execute();
$qPagosAtencion->bind_result($p_id, $p_fecha, $p_monto, $p_nroDoc, $p_cierreIngreso, $p_flagCierreCaja, $p_flagBonoAnulado, $p_formaPago, $p_formaPagoImed, $p_nombreUsuario, $p_local);
$qPagosAtencion->store_result();

$options_local = "<option value=''>--Seleccione--</option>";
$qLocales = $mysqli->prepare("SELECT ID_CENTRO_CONTACTO, NOMBRE FROM centros_contacto WHERE NOMBRE != '' ORDER BY NOMBRE ASC");
$qLocales->execute();
$qLocales->bind_result($cc_idCentroContacto, $cc_nombreCentroContacto);
$qLocales->store_result();
while ($qLocales->fetch()) {
  $selected = "";
  $selected = $ate_idCentroContacto == $cc_idCentroContacto ? "selected" : "";
  $options_local .= "<option value='$cc_idCentroContacto' $selected> $cc_nombreCentroContacto </option>";
}
$qLocales->close();

$options_prevision = "<option value=''>--Seleccione--</option>";
$qPrevision = $mysqli->prepare("SELECT ID_EMPRESA, NOMBRE_E, NBR FROM empresas WHERE FLAG_COMISION_MEDICA = 'S' ORDER BY NBR ASC");
$qPrevision->execute();
$qPrevision->bind_result($idPrevision, $nombrePrevision, $nbrPrevision);
$qPrevision->store_result();
while ($qPrevision->fetch()) {
  $options_prevision .= "<option value='$idPrevision'> $nbrPrevision </option>";
}
$qPrevision->close();

$options_localHuellero = "<option value=''>--Seleccione--</option>";
$qLocalHuellero = $mysqli->prepare("SELECT CODIGO_HUELLERO_IMED, NOMBRE FROM centros_contacto WHERE CODIGO_HUELLERO_IMED != '' ORDER BY NOMBRE ASC");
$qLocalHuellero->execute();
$qLocalHuellero->bind_result($codigoLocalHuellero, $nombreLocalHuellero);
$qLocalHuellero->store_result();
while ($qLocalHuellero->fetch()) {
  $options_localHuellero .= "<option value='$codigoLocalHuellero'> $nombreLocalHuellero </option>";
}
$qLocalHuellero->close();

$options_formaPago = "<option value=''>--Seleccione--</option>";
$qFormaPago = $mysqli->prepare("SELECT CODIGO, DESCRIPCION_CG FROM codigos_generales WHERE COD_TABLA = 'SIS_FORPAG' AND CODIGO NOT IN (1,9,10) ORDER BY DESCRIPCION_CG ASC"); # 10 
$qFormaPago->execute();
$qFormaPago->bind_result($codigoFormaPago, $descripcionFormaPago);
$qFormaPago->store_result();
while ($qFormaPago->fetch()) {
  $options_formaPago .= "<option value='$codigoFormaPago'> $descripcionFormaPago </option>";
}
$qFormaPago->close();

$options_formaPagoMontoAPagar = "<option value=''>--Seleccione--</option>";
$qFormaPagoMontoAPagar = $mysqli->prepare("SELECT CODIGO, DESCRIPCION_CG FROM codigos_generales WHERE COD_TABLA = 'SIS_FORPAG' AND CODIGO NOT IN (1,7,9,10,11,12) ORDER BY DESCRIPCION_CG ASC"); # 10 
$qFormaPagoMontoAPagar->execute();
$qFormaPagoMontoAPagar->bind_result($codigoFormaPago, $descripcionFormaPago);
$qFormaPagoMontoAPagar->store_result();
while ($qFormaPagoMontoAPagar->fetch()) {
  $options_formaPagoMontoAPagar .= "<option value='$codigoFormaPago'> $descripcionFormaPago </option>";
}
$qFormaPagoMontoAPagar->close();

$options_formaPagoImed = "<option value=''>--Seleccione--</option>";
$qFormaPagoImed = $mysqli->prepare("SELECT CODIGO, DESCRIPCION_CG FROM codigos_generales WHERE COD_TABLA = 'SIS_MET_PAGO_IMED' ORDER BY DESCRIPCION_CG ASC");
$qFormaPagoImed->execute();
$qFormaPagoImed->bind_result($codigoFormaPago, $descripcionFormaPago);
$qFormaPagoImed->store_result();
while ($qFormaPagoImed->fetch()) {
  $options_formaPagoImed .= "<option value='$codigoFormaPago'> $descripcionFormaPago </option>";
}
$qFormaPagoImed->close();

ob_start();
?>

<p class="font-md text-center">
  <b>
    <a class="btn btn-link <?php if ($at_ant == "") echo "hidden" ?>" title="Anterior" onclick="location.href='d_pagos.php?idate=<?= $at_ant . '&f_desde=' . $_GET['f_desde'] . '&f_hasta=' . $_GET['f_hasta'] . '&id_cc=' . $_GET['id_cc'] . '&id_con=' . $_GET['id_con'] ?>'"> <i class="fa fa-arrow-circle-left fa-2x"></i> </a>
    Atención N° <?= $idate ?>
    <a class="btn btn-link <?php if ($at_post == "") echo "hidden" ?>" title="Siguiente" onclick="location.href='d_pagos.php?idate=<?= $at_post . '&f_desde=' . $_GET['f_desde'] . '&f_hasta=' . $_GET['f_hasta'] . '&id_cc=' . $_GET['id_cc'] . '&id_con=' . $_GET['id_con'] ?>'"> <i class="fa fa-arrow-circle-right fa-2x"></i> </a>
  </b>
</p>

<!-- <div class="font-md">
  <div style="display: flex; justify-content: space-around;">
    Paciente: <?= $ate_nombrePaciente ?>
  </div>
  <div style="display: flex; justify-content: space-around;">
    Previsión: <?= $ate_nombrePrevision ?> (<?= $ate_nbrPrevision ?>)
  </div>
  <div style="display: flex; justify-content: space-around;">
    Local: <?= $ate_nombreCentroContacto ?>
  </div>
  <div style="display: flex; justify-content: space-around;">
    <?= $ate_obs ? "<span class='bg-color-yellow txt-color-white'>Observaciones: </span>" : "Observaciones:" ?> <?= $ate_obs ? $ate_obs : "-" ?>
  </div>
</div> -->

<div class="font-sm">
  <div class="row">
    <div class="col-md-2">
      Paciente:
    </div>
    <div class="col-md-8">
      <?= $ate_nombrePaciente ?>
    </div>
  </div>
  <div class="row">
    <div class="col-md-2">
      Previsión:
    </div>
    <div class="col-md-8">
      <?= $ate_nombrePrevision ?> (<?= $ate_nbrPrevision ?>)
    </div>
  </div>
  <div class="row">
    <div class="col-md-2">
      Local:
    </div>
    <div class="col-md-8">
      <?= $ate_nombreCentroContacto ?>
    </div>
  </div>
  <!-- <div class="row">
      <div class="col-md-12">
        Fecha de Nacimiento:
        <?= $ate_fechaNaciemiento; ?>
      </div>
    </div>
    <div class="row">
      <div class="col-md-12">
        Fono:
        <?= $ate_fono; ?>
      </div>
    </div>
    <div class="row">
      <div class="col-md-12">
        Dirección:
        <?= $ate_direccion; ?>
      </div>
    </div> -->
  <div class="row">
    <div class="col-md-2">
      <?= $ate_obs ? "<span class='bg-color-yellow txt-color-white'>Observaciones: </span>" : "Observaciones:" ?>
    </div>
    <div class="col-md-8">
      <?= $ate_obs ? $ate_obs : "-" ?>
    </div>
  </div>

</div>

<br>
<div class="row">
  <div class="col-md-12">
    <div class="panel panel-default">
      <div class="panel-heading font-md"> Registro de Pagos Realizados </div>
      <div class="panel-body">
        <?php if ($qPagosAtencion->num_rows == 0) { ?>
          <p> Esta atención no registra pagos </p>
        <?php } else { ?>
          <table class="table table-hover table-bordered">
            <thead>
              <tr>
                <th>Fecha pago</th>
                <th>Cajero</th>
                <th>Local de pago</th>
                <th>Forma de pago</th>
                <th>Forma de pago Imed</th>
                <th>Monto del pago</th>
                <th>N° documento</th>
                <!-- <th>Cierre Caja</th> -->
                <th style="width: 10%">Acciones</th>
              </tr>
            </thead>
            <tbody>
              <?php while ($qPagosAtencion->fetch()) { ?>
                <tr>
                  <td><?= $p_fecha; ?></td>
                  <td><?= $p_nombreUsuario; ?></td>
                  <td><?= $p_local; ?></td>
                  <td> <?= $p_flagBonoAnulado == "S" ? "$p_formaPago <b class='pull-right' style='color:red;'>Anulado</b>" : $p_formaPago ?> </td>
                  <td>
                    <?= $p_formaPagoImed; ?></td>
                  </td>
                  <td><?= "$ " . number_format($p_monto, 0, ',', '.'); ?></td>
                  <td><?= $p_nroDoc; ?></td>
                  <!-- <td><?= ($p_flagCierreCaja == 'S') ? 'Sí' : 'No'; ?></td> -->
                  <td>
                    <a class="btn btn-link" href="m_pago.php?idp=<?= $p_id ?>&idate=<?= $idate ?>"><i class="fa fa-edit fa-lg"></i></a>
                    <?php if (in_array($usuario_perfil, ["ADMINISTRADOR", "SUPERVISOR"])) { ?>
                      <a class="btn btn-sm btn-link btn-eliminarPago" data-id="<?= $p_id ?>"><i class="fa fa-trash-o fa-lg txt-color-red"></i></a>
                    <?php } ?>
                  </td>
                </tr>
              <?php }
              $qPagosAtencion->close(); ?>
            </tbody>
          </table>
        <?php } ?>
        <b class="text-success"> Monto total pagado: $ <?= number_format($ate_montoPagado, 0, ',', '.'); ?> </b>
      </div>
    </div>
  </div>
</div>

<div class="row">
  <div class="col-md-5">
    <div class="panel panel-default">
      <div class="panel-heading font-md"> Resumen de montos, pagos y saldo </div>
      <div class="panel-body">
        <div class="row" style="padding-bottom:10px">
          <div class="col-md-8"> Monto atención: </div>
          <div class="col-md-4" style="text-align:right"> $ <?= number_format($ate_montoAtencion, 0, ',', '.'); ?> </div>
        </div>
        <div class="row" style="padding-bottom:10px">
          <div class="col-md-8"> Monto descuento: </div>
          <div class="col-md-4" style="text-align:right"> - $ <?= number_format($ate_montoDescuento, 0, ',', '.'); ?> </div>
        </div>
        <div class="row" style="padding-bottom:10px">
          <div class="col-md-8"> Monto convenio: <?= $labelCobranza  ?></div>
          <div class="col-md-4" style="text-align:right">
            - $ <?= number_format($ate_montoConvenio, 0, ',', '.') ?>
          </div>
        </div>
        <div class="row" style="padding-bottom:10px">
          <div class="col-md-8"> Porcentaje descuento: </div>
          <div class="col-md-4" style="text-align:right"> <?= $ate_pctjeDescuento ?> % </div>
        </div>
        <div class="row" style="padding-bottom:10px">
          <div class="col-md-8"> <b> Monto a pagar: </b> </div>
          <div class="col-md-4" style="text-align:right"> <b>$ <?= number_format($montoAPagar, 0, ',', '.'); ?> </b> </div>
        </div>
        <div class="row text-success" style="padding-bottom:10px">
          <b>
            <div class="col-md-8"> Monto total pagado: </div>
            <div class="col-md-4" style="text-align:right"> - $ <?= number_format($ate_montoPagado, 0, ',', '.'); ?> </div>
          </b>
        </div>
        <div class="row <?php if ($montoSaldo > 0) echo "text-danger" ?>" style="padding-bottom:10px">
          <b>
            <div class="col-md-8"> <b> Saldo: </b> </div>
            <div class="col-md-4" style="text-align:right"> $ <?= number_format($montoSaldo, 0, ',', '.'); ?> </div>
          </b>
        </div>
        <?php if ($ate_montoCondonado != 0) { ?>
          <div class="row" style="padding-bottom:10px">
            <div class="col-md-8"> Monto condonado: </div>
            <div class="col-md-4" style="text-align:right"> - $ <?= number_format($ate_montoCondonado, 0, ',', '.'); ?> </div>
          </div>
        <?php } ?>
      </div>
    </div>
  </div>
</div>

<h3>Ingresar nuevo pago</h3>
<ul id="myTab1" class="nav nav-tabs bordered">
  <li class="active">
    <a href="#tab-ingresoRapidoBonoElectronico" data-toggle="tab"></i>Ingreso bono electrónico</a>
  </li>
  <li>
    <a href="#tab-ingresoNormal" data-toggle="tab">Otros ingresos</a>
  </li>

</ul>
<div id="myTabContent1" class="tab-content padding-10">
  <div class="tab-pane fade active in" id="tab-ingresoRapidoBonoElectronico">
    <form id="formIngresarPagosBono" action="sql_cod.php" class="smart-form">
      <table class="table table-bordered">
        <tr>
          <td>Local de pago:</td>
          <td>
            <label class="select">
              <select name="ID_CC" class="select2">
                <?= $options_local ?>
              </select>
            </label>
          </td>
          <td>N° documento:</td>
          <td>
            <label class="input">
              <input name="NRO_DOCTO" type="text" value="" size="20" /> <i></i>
            </label>
          </td>
        </tr>
        </tr>
        <tr>
          <td>Monto bonificación:</td>
          <td>
            <label class="input">
              <input type="number" name="MONTO_BONO" value="" /> <i></i>
            </label>
          </td>
          <td>Local del lector de huella:</td>
          <td>
            <label class="select">
              <select name="CODIGO_HUELLERO_IMED" class="select2">
                <?= $options_localHuellero ?>
              </select>
            </label>
          </td>
        </tr>
        <tr>
        <tr>
          <td>Monto bonificación adicional (seguros):</td>
          <td>
            <label class="input">
              <input type="number" name="MONTO_BONO_ADICIONAL" value="" /> <i></i>
            </label>
          </td>
          <td colspan="2">
          </td>
        </tr>
        <tr>
          <td>Monto a pagar:</td>
          <td>
            <label class="input">
              <input type="number" name="MONTO_A_PAGAR" value="" /> <i></i>
            </label>
          </td>
          <td>Forma de pago (monto a pagar):</td>
          <td>
            <label class="select">
              <select disabled name="FORMA_PAGO" class="select2">
                <?= $options_formaPagoMontoAPagar ?>
              </select>
            </label>
          </td>
        </tr>
        <tr>
          <td>Monto pago directo Imed:</td>
          <td>
            <label class="input">
              <input type="number" name="MONTO_PAGO_DIRECTO_IMED" value="" /> <i></i>
            </label>
          </td>
          <td>Forma pago directo Imed:</td>
          <td>
            <label class="select">
              <select disabled name="FORMA_PAGO_IMED" class="select2">
                <?= $options_formaPagoImed ?>
              </select>
            </label>
          </td>
        </tr>
      </table>
      <footer>
        <a type="submit" class="btn btn-primary btn-ingresarPagosBono"> <i class="fa fa-lg fa-save"></i> Grabar</a>
      </footer>
      <input type="hidden" name="ID_ATENCION" value="<?= $idate ?>" />
      <input type="hidden" name="ID_PREVISION" value="<?= $ate_idPrevision ?>" />
      <input type="hidden" name="ingresarPagosBono" value="ingresarPagosBono" />
    </form>
  </div>
  <div class="tab-pane fade" id="tab-ingresoNormal">
    <form id="formIngresarPagoNormal" action="sql_cod.php" class="smart-form">
      <table class="table table-bordered">
        <tr>
          <td>Local de pago:</td>
          <td>
            <label class="select">
              <select name="ID_CC" class="select2">
                <?= $options_local ?>
              </select>
            </label>
          </td>
          <td>N° documento:</td>
          <td>
            <label class="input">
              <input name="NRO_DOCTO" type="text" value="" size="20" /> <i></i>
            </label>
          </td>
        </tr>
        <tr>
          <td>Forma de pago:</td>
          <td>
            <label class="select">
              <select name="FORMA_PAGO" class="select2">
                <?= $options_formaPago ?>
              </select>
            </label>
          </td>
          <td>Empresa de bono comisión médica:</td>
          <td>
            <label class="select">
              <select disabled name="ID_PREVISION" class="select2">
                <?= $options_prevision ?>
              </select>
            </label>
          </td>
        </tr>
        <tr>
          <td>Monto del pago:</td>
          <td>
            <label class="input">
              <input type="number" name="MONTO_PAGADO" value="" /> <i></i>
            </label>
          </td>
          <td colspan="2">
          </td>
        </tr>
      </table>
      <footer>
        <a class="btn btn-primary btn-ingresarPagoNormal"> <i class="fa fa-lg fa-save"></i> Grabar</a>
      </footer>
      <input type="hidden" name="ID_ATENCION" value="<?= $idate ?>" />
      <input type="hidden" name="ID_PREVISION_ATENCION" value="<?= $ate_idPrevision ?>" />
      <input type="hidden" name="ingresarPagoNormal" value="ingresarPagoNormal" />
    </form>
  </div>
</div>

<?php
$contenido = ob_get_contents();
ob_end_clean();

$ui = new SmartUI;
$options = array("editbutton" => false);
$widget = $ui->create_widget($options);

$widget->header = array(
  "title" => $datos_pantallas[$pantalla_actual]['body_title'],
  "icon" => 'fa fa-file-text-o',
  "toolbar" => array(
    array(
      "id" => 'toolbar-id',
      "content" => '',
      "class" => 'smart-form'
    )
  )
);
$widget->body('content', $contenido);
?>

<div id="main" role="main">
  <?php
  include("../inc/ribbon.php");
  ?>

  <div id="content">
    <?php
    $widget->print_html();
    ?>
  </div>
</div>

<?php
include("../inc/footer.php");
include("../inc/scripts.php");
?>

<script>
  $(document).ready(function(e) {
    $('.btn-ingresarPagoNormal').click(function() {
      var form = $("#formIngresarPagoNormal");
      if (form.valid()) {
        $.post(form.attr('action'), form.serialize(), function(data) {
          if (data.exito) {
            exito();
            location.reload();
          } else {
            $(this).removeAttr('disabled');
            error(data.mensaje);
          }
        }, 'json');
      }
    });

    $('.btn-ingresarPagosBono').click(function() {
      var form = $("#formIngresarPagosBono");
      if (form.valid()) {
        $.post(form.attr('action'), form.serialize(), function(data) {
          if (data.exito) {
            exito();
            location.reload();
          } else {
            $(this).removeAttr('disabled');
            error(data.mensaje);
          }
        }, 'json');
      }
    });

    $("#formIngresarPagosBono input[name='MONTO_PAGO_DIRECTO_IMED']").on("input", function() {
      var booleanDisabled = (this).value > 0 ? false : true;
      $("#formIngresarPagosBono select[name='FORMA_PAGO_IMED']").prop("disabled", booleanDisabled);
    });

    $("#formIngresarPagosBono input[name='MONTO_A_PAGAR']").on("input", function() {
      var booleanDisabled = (this).value > 0 ? false : true;
      $("#formIngresarPagosBono select[name='FORMA_PAGO']").prop("disabled", booleanDisabled);
    });

    $("#formIngresarPagoNormal select[name='FORMA_PAGO']").change(function() {
      var booleanDisabled = (this).value == 11 ? false : true;
      $("#formIngresarPagoNormal select[name='ID_PREVISION']").prop("disabled", booleanDisabled);
    });

    $('.btn-eliminarPago').click(function() {
      if (confirm("El pago será eliminado ¿Desea continuar?")) {
        $.post('sql_cod.php', {
          eliminarPago: 1,
          idPago: $(this).data('id'),
          idAtencion: '<?= $_GET['idate'] ?>'
        }, function(data) {
          if (data.exito) {
            exito("Se ha guardado con exito!");
            location.reload();
          } else {
            error(data.mensaje);
          }
        }, 'json');
      }
    })

    $("#formIngresarPagoNormal").validate({
      rules: {
        ID_CC: {
          required: true
        },
        NRO_DOCTO: {
          required: true
        },
        FORMA_PAGO: {
          required: true
        },
        ID_PREVISION: {
          required: true
        },
        MONTO_PAGADO: {
          required: true
        }
      },
      messages: {
        ID_CC: {
          required: 'Campo obligatorio'
        },
        NRO_DOCTO: {
          required: 'Campo obligatorio'
        },
        FORMA_PAGO: {
          required: 'Campo obligatorio'
        },
        ID_PREVISION: {
          required: 'Campo obligatorio'
        },
        MONTO_PAGADO: {
          required: 'Campo obligatorio'
        }
      },
      onfocusout: false,
      errorPlacement: function(error, element) {
        error.insertAfter(element.parent());
      }
    });

    $("#formIngresarPagosBono").validate({
      rules: {
        ID_CC: {
          required: true
        },
        NRO_DOCTO: {
          required: true
        },
        CODIGO_HUELLERO_IMED: {
          required: true
        },
        FORMA_PAGO: {
          required: true
        },
        ID_PREVISION: {
          required: true
        },
        MONTO_BONO: {
          required: true
        },
        MONTO_BONO_ADICIONAL: {
          required: true
        },
        MONTO_A_PAGAR: {
          required: true
        },
        MONTO_PAGO_DIRECTO_IMED: {
          required: true
        },
        FORMA_PAGO_IMED: {
          required: true
        }
      },
      messages: {
        ID_CC: {
          required: 'Campo obligatorio'
        },
        NRO_DOCTO: {
          required: 'Campo obligatorio'
        },
        CODIGO_HUELLERO_IMED: {
          required: 'Campo obligatorio'
        },
        FORMA_PAGO: {
          required: 'Campo obligatorio'
        },
        ID_PREVISION: {
          required: 'Campo obligatorio'
        },
        MONTO_BONO: {
          required: 'Campo obligatorio'
        },
        MONTO_BONO_ADICIONAL: {
          required: 'Campo obligatorio'
        },
        MONTO_A_PAGAR: {
          required: 'Campo obligatorio'
        },
        MONTO_PAGO_DIRECTO_IMED: {
          required: 'Campo obligatorio'
        },
        FORMA_PAGO_IMED: {
          required: 'Campo obligatorio'
        }
      },
      onfocusout: false,
      errorPlacement: function(error, element) {
        error.insertAfter(element.parent());
      }
    });
  });
</script>

<?php
include("../inc/google-analytics.php");
?>