<?php
$pagina = 10;
define('PERMITIDO', true);
require_once("../inc/init.php");
require_once("../inc/config.ui.php");
$page_title = "Ingreso de Pagos";
$page_css[] = "your_style.css";
include("../inc/header.php");
$page_nav['Caja']['sub']['pagos']["active"] = true;
include("../inc/nav.php");


//filtro
$busqueda='';
if(isset($_GET['busq'])&&($_GET['busq']!='')){
	$b=$_GET['busq'];
	$busqueda='  AND (CONCAT(IFNULL(CONCAT(p1.NOMBRES,\' \'),\'\'),IFNULL(CONCAT(p1.APELLIDO_PATERNO,\' \'),\'\'), IFNULL(p1.APELLIDO_MATERNO,\'\')) LIKE \'%'.$b.'%\' OR p1.NRO_RUT = \''.$b.'\' OR atenciones.ID_ATENCION = \''.$b.'\')';
}//

$cant_reg = 100;		//Limito la busqueda
$inicio = 0;
$pagina = 1;
if(isset($_GET["pag"])){//examino la página a mostrar y el inicio del registro a mostrar
	$pagina = $_GET["pag"];	
   	$inicio = ($pagina - 1) * $cant_reg;
}
/* Consulta para saber total de paginas */
	if(isset($_GET['tpag'])){
		$total_paginas=$_GET['tpag'];
	}else{
		$consultaTotal='SELECT ID_ATENCION FROM atenciones 
						INNER JOIN personas p1 ON atenciones.ID_CLIENTE=p1.ID_PERSONA
						WHERE atenciones.CIERRE_ATE=\'N\' AND MONTO_ATENCION>0 '.$busqueda.'';
		$qtotal=$mysqli->prepare($consultaTotal);
		$qtotal->execute();
		$qtotal->store_result();
		$totalRows_total=$qtotal->num_rows;
		$qtotal->close();
		$total_paginas = ceil($totalRows_total / $cant_reg);
}

$consulta='SELECT atenciones.ID_ATENCION, DATE_FORMAT(atenciones.FECHA,\'%d/%m/%Y\') AS FECHA, atenciones.MONTO_ATENCION, atenciones.MONTO_PAGADO, PCTJE_DESCUENTO, MONTO_DESCUENTO, MONTO_CONDONADO, (MONTO_ATENCION - (MONTO_ATENCION*PCTJE_DESCUENTO / 100)) - MONTO_PAGADO - MONTO_DESCUENTO - MONTO_CONDONADO, 
			CONCAT(IFNULL(p1.NOMBRES, \'\'),\' \', IFNULL(p1.APELLIDO_PATERNO, \'\'),\' \', IFNULL(p1.APELLIDO_MATERNO, \'\')), p1.NRO_RUT, p1.DV_RUT
			FROM atenciones 
			INNER JOIN personas p1 ON atenciones.ID_CLIENTE=p1.ID_PERSONA 
			WHERE atenciones.CIERRE_ATE=\'N\' AND MONTO_ATENCION>0 '.$busqueda.'
			ORDER BY atenciones.ID_ATENCION DESC
			LIMIT ?, ?
			';
$qatenciones=$mysqli->prepare($consulta);
$qatenciones->bind_param('ii', $inicio, $cant_reg);
$qatenciones->execute();
$qatenciones->bind_result($at_id, $at_fecha, $at_monto, $at_montoPagado, $at_pDescuento, $at_montoDescuento, $at_montoCondonado, $at_saldo, $at_paciente, $at_nroRut, $at_dvRut);
$qatenciones->store_result();
$totalRows_atenciones=$qatenciones->num_rows;


ob_start();
?>
<!-- ==========================CONTENT STARTS HERE ========================== -->
<!-- MAIN PANEL -->

	<!-- MAIN CONTENT -->

<form id="formBuscar" name="formBuscar" method="get" action="" class="smart-form">
<table class="table table-responsive">
  <tr>
	<td align="left" style="width:6em;"><h5>Busqueda:</h5> </td>  
    <td style="width:16em;">
    <label class="input">
      	<input type="search" name="busq" class="input-sm" autofocus="autofocus" placeholder="Atención, Nombre, RUT, Local" value="<?php if(isset($_GET['busq']))echo $_GET['busq']?>"/>
    </label>
    </td>        
    <td style="width:6em;">
    	<a id="buscar" class="btn btn-link" title=""><i class="fa fa-search fa-lg"></i></a>         
    </td>
    <td style="width:6em;">
    	<a class="btn btn-info btn-sm" tittle="Ver Todo" onclick="location.href='l_atenciones.php'"> Ver Todo </a>
    </td>
    <td>
     <div class="text-right"><?php if ($total_paginas > 1) {echo paginacion('l_atenciones.php?', $_SERVER['QUERY_STRING'], $total_paginas, $pagina,2,2);}?></div>
    </td>
  </tr>
</table>
</form>

<table class="table table-hover table-bordered">
<thead>
    <tr>
      <th>Nro Atención</th>
      <th>Fecha</th>
      <th>Paciente</th>
      <th>Monto</th>
      <th>Desc. %</th>
      <th>Desc. $</th>
      <th>Cond.</th>
      <th>Pagado</th>
      <th>Saldo</th>
      <th align="center"><em>Acciones</em></th>
    </tr>
   </thead>
   <tbody>
  <?php while($qatenciones->fetch()) { ?>
    <tr>
        <td><?php echo $at_id; ?></td>
        <td nowrap><?php echo $at_fecha; ?></td>
        <td nowrap><?php echo $at_paciente ?></td>
        <td width="75" align="right">$<?php echo number_format($at_monto,0,',','.'); ?></td>
        <td width="75" align="right"><?php echo $at_pDescuento; ?></td>
        <td width="75" align="right">$<?php echo number_format($at_montoDescuento,0,',','.'); ?></td>
        <td width="75" align="right">$<?php echo number_format($at_montoCondonado,0,',','.'); ?></td>
        <td nowrap align="right">$ <?php echo number_format($at_montoPagado,0,',','.'); ?></td>
        <td nowrap  align="right">$ <?php echo number_format($at_saldo,0,',','.'); ?></td>
        <td align="center">
        <input name="image" src="../imagenes/payment_icon.png" height="22" width="22" type="image" onclick= "location.href = 'n_pago.php?idate=<?php echo $at_id; ?>'" value="Pagar" title="Registrar Pago" />
        </td>
      </tr>
    <?php }$qatenciones->close(); ?>
    </tbody>
</table>


<?php if ($total_paginas > 1) {echo '<div class="text-center" style="padding-top:1em;">'.paginacion('l_atenciones.php?', $_SERVER['QUERY_STRING'], $total_paginas, $pagina).'</div>';}?>

<?php
$contenido = ob_get_contents();
ob_end_clean();

$ui = new SmartUI;
$options = array("editbutton" => false);
$widget = $ui->create_widget($options);

$widget->header = array(
    "title" => '<h2><strong>Ingreso de Pagos</strong><em></em></h2>',
    "icon" => 'fa fa-cog',
	'toolbar' => array(
		array(
			"id" => "toolbar-id",
			"content" => '<a href="#"  data-toggle="modal" data-target="#myModalNew"></a>',
			"class" => 'smart-form'
		)
	)
);
$widget->body('content', $contenido);
?>

<div id="main" role="main">
	<?php
	
		include("../inc/ribbon.php");
	?>

	<!-- MAIN CONTENT -->
    <div id="content">	
		<?php
            $widget->print_html();
        ?>
	</div>
    		><!-- modal Edit-->
<!-- END MAIN PANEL -->
</div>
<!-- END MAIN PANEL -->
<!-- ==========================CONTENT ENDS HERE ========================== -->

<!-- PAGE FOOTER -->
<?php
	// include page footer
	include("../inc/footer.php");
?>
<!-- END PAGE FOOTER -->

<?php 
	//include required scripts
	include("../inc/scripts.php");
?>

<!-- PAGE RELATED PLUGIN(S) 
<script src="<?php echo ASSETS_URL; ?>/js/plugin/YOURJS.js"></script>-->

<script>

$(document).ready(function() {
	$('#buscar').click(function(){
		$('#formBuscar').submit();
	})
})

</script>

<?php 
	//include footer
	include("../inc/google-analytics.php");
?>