<?php
define('PERMITIDO', true);
$pantalla_actual = 'REG_PAG';

require_once("../inc/init.php");
require_once("../inc/config.ui.php");
$page_title = $datos_pantallas[$pantalla_actual]['page_title'];
$page_css[] = "your_style.css";
include("../inc/header.php");
include("../inc/nav.php");

$opciones_local = '<option value="">-</option>';
$qCentrosContacto = $mysqli->prepare("SELECT ID_CENTRO_CONTACTO, NOMBRE
FROM centros_contacto 
ORDER BY NOMBRE ASC");
$qCentrosContacto->execute();
$qCentrosContacto->bind_result($l_idLocal, $l_nombre);
while ($qCentrosContacto->fetch()) {
  $selected = $l_idLocal == $_GET['id_cc'] ? 'selected' : '';
  $opciones_local .= "<option value='$l_idLocal' $selected> $l_nombre </option>";
}
$qCentrosContacto->close();

$opciones_convenio = '<option value="">-</option>';
$qConvenios = $mysqli->prepare("SELECT ID_EMPRESA, NBR
FROM empresas 
WHERE FLAG_CONVENIO = 'S'
ORDER BY NBR ASC");
$qConvenios->execute();
$qConvenios->bind_result($e_idEmpresa, $e_nbr);
while ($qConvenios->fetch()) {
  $selected = $e_idEmpresa == $_GET['id_con'] ? 'selected' : '';
  $opciones_convenio .= "<option value='$e_idEmpresa' $selected> $e_nbr </option>";
}
$qConvenios->close();

$f_desde  = isset($_GET['f_desde']) && $_GET['f_desde'] != '' ? $_GET['f_desde'] : "";
$f_hasta  = isset($_GET['f_hasta']) && $_GET['f_hasta'] != '' ? $_GET['f_hasta'] : "";
$id_cc    = isset($_GET['id_cc'])   && $_GET['id_cc']   != '' ? $_GET['id_cc']   : "";
$id_con   = isset($_GET['id_con'])  && $_GET['id_con']  != '' ? $_GET['id_con']  : "";

ob_start();
?>

<form action="" method="get" class="smart-form">
  <section>
    <div class="row">
      <div class="col col-2">
        <label class="input">
          <input name="f_desde" class="input-sm" type="date" value="<?php if (isset($_GET['f_desde'])) echo $_GET['f_desde'] ?>" />
          <div class="note">Fecha Desde</div>
        </label>
      </div>
      <div class="col col-2">
        <label class="input">
          <input name="f_hasta" class="input-sm" type="date" value="<?php if (isset($_GET['f_hasta'])) echo $_GET['f_hasta'] ?>" />
          <div class="note">Fecha Hasta</div>
        </label>
      </div>
      <div class="col col-2">
        <select name="id_cc" class="select2">
          <?= $opciones_local ?>
        </select>
        <div class="note">Local</div>
      </div>
      <div class="col col-2">
        <select name="id_con" class="select2">
          <?= $opciones_convenio ?>
        </select>
        <div class="note">Convenio</div>
      </div>
      <div class="col-md-2">
        <div class="btn-group">
          <button class="btn btn-sm btn-success" type="submit"> <i class="fa fa-search"> </i> Filtrar </button>
          <a class="btn btn-sm btn-info" href="r_pagos.php" style="margin-left: 5px">Ver todo</a>
        </div>
      </div>
    </div>
  </section>
</form>

<div class="table-responsive">
  <table class="table table-hover table-bordered" id="dataTable-pagos" style="width:100%">
    <thead>
      <tr>
        <th>Atención</th>
        <th>Fecha</th>
        <th>Local</th>
        <th>Convenio</th>
        <th>Paciente</th>
        <th>Monto</th>
        <th>Descuento (%)</th>
        <th>Descuento ($)</th>
        <th>Monto Convenio</th>
        <th>Monto Condonado</th>
        <th>Monto Pagado</th>
        <th>Saldo</th>
        <th class="text-center">Acciones</th>
      </tr>
    </thead>
  </table>
</div>

<?php
$contenido = ob_get_contents();
ob_end_clean();

$ui = new SmartUI;
$options = array("editbutton" => false);
$widget = $ui->create_widget($options);

$widget->header = array(
  "title" => $datos_pantallas[$pantalla_actual]['body_title'],
  "icon" => 'fa fa-cog',
  'toolbar' => array(
    array(
      "id" => "toolbar-id",
      "content" => '',
      "class" => 'smart-form'
    )
  )
);
$widget->body('content', $contenido);
?>

<div id="main" role="main">
  <?php

  include("../inc/ribbon.php");
  ?>

  <div id="content">
    <?php
    $widget->print_html();
    ?>
  </div>

</div>

<?php
include("../inc/footer.php");
include("../inc/scripts.php");
?>

<script>
  $(document).ready(function() {
    var dataTable = $('#dataTable-pagos').DataTable({
      // searchDelay: 350,
      'lengthMenu': [
        [50, 100, 200, 500],
        [50, 100, 200, 500]
      ],
      "language": {
        "sProcessing": "Procesando...",
        "sZeroRecords": "No se encontraron resultados",
        "sInfoPostFix": "",
        "sUrl": "",
        "oPaginate": {
          "sFirst": "Primero",
          "sPrevious": "Anterior",
          "sNext": "Siguiente",
          "sLast": "Último"
        },
        "sInfo": "_START_ a _END_ de _TOTAL_ Registros",
        "sInfoEmpty": "0 Registros",
        "sInfoFiltered": "(de _MAX_ Registros en total)",
        "sLengthMenu": "Mostrar _MENU_ Registros",
        "sSearch": "Buscar: "
      },
      "processing": true,
      "serverSide": true,
      "order": [0, 'asc'],
      'columns': [
        null,
        null,
        null,
        null,
        null,
        null,
        null,
        null,
        null,
        null,
        null,
        null,
        {
          "orderable": false
        }
      ],
      "ajax": {
        url: "ajax_pagos.php",
        type: "POST",
        data: {
          'f_desde': "<?= $f_desde ?>",
          'f_hasta': "<?= $f_hasta ?>",
          'id_cc': "<?= $id_cc ?>",
          'id_con': "<?= $id_con ?>",
        },
      },
      drawCallback: function() {
        console.log("a");
        $('[data-toggle="tooltip"]').popover();
      }
    });
  });
</script>

<?php
//include footer
include("../inc/google-analytics.php");
?>

<a style="padding:0;" class="btn btn-link" rel="popover" data-placement="left" data-original-title="Resultados Anteriores" data-content="" data-html="true">
  <i class="fa fa-folder-open-o"></i>
</a>

<a style="padding:0;" class="btn btn-link" rel="popover" data-placement="left" data-original-title="Resultados Anteriores" data-content="" data-html="true">
  <i class="fa fa-folder-open-o"></i>
</a>