<?php
$pagina = 49;
define('PERMITIDO', true);
require_once("../inc/init.php");
$hoy = date('Y-m-d', time());

if (isset($_POST["ingresarPagoNormal"]) && $_POST["ingresarPagoNormal"] != "") {
    $flag_cierreCaja = "N";
    $cobrado = "N";

    $idPrevision = $_POST['ID_PREVISION'] ? $_POST['ID_PREVISION'] : $_POST['ID_PREVISION_ATENCION'];

    $query = $mysqli->prepare("INSERT INTO pagos (ID_ATENCION, ID_CC, FECHA_PAGO, FORMA_PAGO, MONTO_PAGADO, ID_PREVISION, NRO_DOCTO, ID_CAJERO, FLAG_CIERRECAJA, COBRADO)
    VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
    $query->bind_param('iisiiisiss', $_POST['ID_ATENCION'], $_POST['ID_CC'], $hoy, $_POST['FORMA_PAGO'], $_POST['MONTO_PAGADO'], $idPrevision, $_POST['NRO_DOCTO'], $usuario_id, $flag_cierreCaja, $cobrado);
    $query->execute();
    $query->close();

    $qUpdateMontoPagado = $mysqli->prepare("UPDATE atenciones SET MONTO_PAGADO = MONTO_PAGADO + ?  WHERE ID_ATENCION = ?");
    $qUpdateMontoPagado->bind_param('ii', $_POST['MONTO_PAGADO'], $_POST['ID_ATENCION']);
    $qUpdateMontoPagado->execute();
    $qUpdateMontoPagado->close();

    $respuesta = array('exito' => true);
    echo json_encode($respuesta);
    exit(0);
}

if (isset($_POST["ingresarPagosBono"]) && $_POST["ingresarPagosBono"] != "") {
    $flag_cierreCaja = "N";
    $cobrado = "N";
    $codigoBonoElectrónico = 1;
    $codigoBonificacionAdicional = 9;
    $codigoPagoDirectoImed = 10;

    $query = $mysqli->prepare("INSERT INTO pagos (ID_ATENCION, ID_CC, FECHA_PAGO, FORMA_PAGO, MONTO_PAGADO, ID_PREVISION,
    NRO_DOCTO, ID_CAJERO, FLAG_CIERRECAJA, COBRADO)
    VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
    $query->bind_param('iisiiisiss', $_POST['ID_ATENCION'], $_POST['ID_CC'], $hoy, $codigoBonoElectrónico, $_POST['MONTO_BONO'], $_POST['ID_PREVISION'],
    $_POST['NRO_DOCTO'], $usuario_id, $flag_cierreCaja, $cobrado);
    $query->execute();
    $query->close();
    
    if ($_POST['MONTO_BONO_ADICIONAL'] > 0) {
        $query = $mysqli->prepare("INSERT INTO pagos (ID_ATENCION, ID_CC, FECHA_PAGO, FORMA_PAGO, MONTO_PAGADO, ID_PREVISION, 
        NRO_DOCTO, ID_CAJERO, FLAG_CIERRECAJA, COBRADO) 
        VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
        $query->bind_param('iisiiisiss', $_POST['ID_ATENCION'], $_POST['ID_CC'], $hoy, $codigoBonificacionAdicional, $_POST['MONTO_BONO_ADICIONAL'],
        $_POST['ID_PREVISION'], $elec, $_POST['NRO_DOCTO'], $usuario_id, $cierreIngreso, $flag_cierreCaja, $cobrado);
        $query->execute();
        $query->close();
    }

    if ($_POST['MONTO_A_PAGAR'] > 0) { # COPAGO
        $query = $mysqli->prepare("INSERT INTO pagos (ID_ATENCION, ID_CC, FECHA_PAGO, FORMA_PAGO, MONTO_PAGADO, ID_PREVISION, 
        NRO_DOCTO, ID_CAJERO, FLAG_CIERRECAJA, COBRADO, FLAG_COPAGO_BONO) 
        VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, 1)");
        $query->bind_param('iisiiisiss', $_POST['ID_ATENCION'], $_POST['ID_CC'], $hoy, $_POST['FORMA_PAGO'], $_POST['MONTO_A_PAGAR'], $_POST['ID_PREVISION'],
        $_POST['NRO_DOCTO'], $usuario_id, $flag_cierreCaja, $cobrado);
        $query->execute();
        $query->close();
    }

    if ($_POST['MONTO_PAGO_DIRECTO_IMED'] > 0) {
        $query = $mysqli->prepare("INSERT INTO pagos (ID_ATENCION, ID_CC, FECHA_PAGO, FORMA_PAGO, FORMA_PAGO_IMED, MONTO_PAGADO, ID_PREVISION, 
        NRO_DOCTO, ID_CAJERO, FLAG_CIERRECAJA, COBRADO) 
        VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
        $query->bind_param('iisiiiisiss', $_POST['ID_ATENCION'], $_POST['ID_CC'], $hoy, $codigoPagoDirectoImed, $_POST['FORMA_PAGO_IMED'], $_POST['MONTO_PAGO_DIRECTO_IMED'], $_POST['ID_PREVISION'],
        $_POST['NRO_DOCTO'], $usuario_id, $flag_cierreCaja, $cobrado);
        $query->execute();
        $query->close();
    }

    $montoPagado = $_POST['MONTO_BONO'] + $_POST['MONTO_BONO_ADICIONAL'] + $_POST['MONTO_A_PAGAR'] + $_POST['MONTO_PAGO_DIRECTO_IMED'];
    $qUpdateMontoPagado = $mysqli->prepare("UPDATE atenciones SET MONTO_PAGADO = MONTO_PAGADO + ?, CODIGO_HUELLERO_IMED = ? WHERE ID_ATENCION = ?");
    $qUpdateMontoPagado->bind_param('iii', $montoPagado, $_POST['CODIGO_HUELLERO_IMED'], $_POST['ID_ATENCION']);
    $qUpdateMontoPagado->execute();
    $qUpdateMontoPagado->close();

    $respuesta = array('exito' => true);
    echo json_encode($respuesta);
    exit(0);
}

if (isset($_POST["eliminarPago"]) && $_POST["eliminarPago"] != "") {
    $qDeletePago = $mysqli->prepare("DELETE FROM pagos WHERE ID_PAGOS = ? AND FLAG_CIERRECAJA = 'N' AND CIERRE_INGRESO = 'N'");
    $qDeletePago->bind_param('i', $_POST['idPago']);
    $qDeletePago->execute();
    $qDeletePago->close();

    $qUpdateMontoPagado = $mysqli->prepare("UPDATE atenciones SET MONTO_PAGADO = (select COALESCE(SUM(MONTO_PAGADO), 0) FROM pagos WHERE ID_ATENCION = ?) WHERE ID_ATENCION = ?");
    $qUpdateMontoPagado->bind_param('ii', $_POST['idAtencion'], $_POST['idAtencion']);
    $qUpdateMontoPagado->execute();
    $qUpdateMontoPagado->close();

    $respuesta = array('exito' => true);
    echo json_encode($respuesta);
    exit(0);
}
