<?php
define('PERMITIDO', true);
$pantalla_actual = 'CAR_RES';
require_once("../inc/init.php");
require_once("../inc/config.ui.php");
$page_title = $datos_pantallas[$pantalla_actual]['page_title'];
$page_css[] = "your_style.css";
include("../inc/header.php");
include("../inc/nav.php");

set_time_limit(300);

function getResultWithPosition($resultField, $resultFieldSeparator, $resultPositionInResultField)
{
	if (!strpos($resultField, $resultFieldSeparator) !== false) return $resultField;
	$resultFieldArray = explode($resultFieldSeparator, $resultField);
	return $resultFieldArray[$resultPositionInResultField - 1];
}

function grabarResultadosFila($data, $resultField, $attentionId, $resultFieldSeparator, $equipmentId)
{
	global $mysqli;

	if (!$data['COD_INTERNO'] || $data['COD_INTERNO'] == "") return "<tr><td colspan='5'>Error COD_INTERNO</td></tr>";

	$resultado = getResultWithPosition($resultField, $resultFieldSeparator, $data['POSICION_RESULTADO']);

	if ($data['FECHA_VAL'] != "") {
		return "
		<tr>
			<td>$attentionId</td>
			<td>{$data['COD_INTERNO']}</td>
			<td>{$data['NOMBRE']}</td>
			<td>$resultado</td>
			<td>No se actualiza, examen validado el {$data['FECHA_VAL']} </td>
		</tr>";
	}

	if ($resultado == $data['RESULTADO']) {
		return "
		<tr>
			<td>$attentionId</td>
			<td>{$data['COD_INTERNO']}</td>
			<td>{$data['NOMBRE']}</td>
			<td>$resultado</td>
			<td>No se actualiza, resultado repetido</td>
		</tr>";
	}

	if ($attentionId == "Invalid") {
		return "
		<tr>
			<td>$attentionId</td>
			<td>{$data['COD_INTERNO']}</td>
			<td>{$data['NOMBRE']}</td>
			<td>$resultado</td>
			<td>No se actualiza, n° de atención inválido</td>
		</tr>";
	}

	if ($resultField == "No Result") {
		return "
		<tr>
			<td>$attentionId</td>
			<td>{$data['COD_INTERNO']}</td>
			<td>{$data['NOMBRE']}</td>
			<td>$resultado</td>
			<td>No se actualiza, resultado inválido</td>
		</tr>";
	}

	$query = $mysqli->prepare("UPDATE examenes_atenciones SET RESULTADO = ?, ID_USUARIO_REG = 1000 WHERE ID_ATENCION = ? AND ID_EXATE = ? AND USUARIO_VAL IS NULL LIMIT 1");
	$query->bind_param("sis", $resultado, $attentionId, $data['ID_EXATE']);
	$query->execute();


	return "
	<tr>
		<td>$attentionId</td>
		<td>{$data['COD_INTERNO']}</td>
		<td>{$data['NOMBRE']}</td>
		<td>$resultado</td>
		<td>Actualizado</td>
	</tr>";
}

function recorrerArchivoResultados($archivoResultados, $nombreEquipo)
{
	global $mysqli;

	$tableData = "";
	$file = fopen($archivoResultados, "r") or exit("NO SE PUEDE ABRIR EL ARCHIVO!");

	if ($nombreEquipo == 'V5600') {
		$equipmentId = 13;
		$segmentIdPositionInFile = 0;
		$equipmentExamCodeFieldSeparator = "+";
		$resultFieldSeparator = "^";
		$limsIdFieldPositionInFile = 3;
		$equipmentExamCodeFieldPositionInFile = 3;
		$resultFieldPositionInFile = 5;
		$limsIdSegmentCode = "SAC";
		$resultSegmentCode = "OBX";
	}

	if ($nombreEquipo == 'H50P') {
		$equipmentId = 14;
		$segmentIdPositionInFile = 0;
		$equipmentExamCodeFieldSeparator = "+";
		$resultFieldSeparator = "^";
		$limsIdFieldPositionInFile = 3;
		$equipmentExamCodeFieldPositionInFile = 3;
		$resultFieldPositionInFile = 5;
		$limsIdSegmentCode = "OBR";
		$resultSegmentCode = "OBX";
	}

	if ($nombreEquipo == "BC780" || $nombreEquipo == "BC700") {
		$equipmentId = 15;
		$segmentIdPositionInFile = 0;
		$equipmentExamCodeFieldSeparator = "+";
		$resultFieldSeparator = "^";
		$limsIdFieldPositionInFile = 3;
		$equipmentExamCodeFieldPositionInFile = 3;
		$resultFieldPositionInFile = 5;
		$limsIdSegmentCode = "OBR";
		$resultSegmentCode = "OBX";
	}

	if ($nombreEquipo == 'COR50') {
		$equipmentId = 16;
		$segmentIdPositionInFile = 0;
		$equipmentExamCodeFieldSeparator = "+";
		$resultFieldSeparator = "^";
		$limsIdFieldPositionInFile = 2;
		$equipmentExamCodeFieldPositionInFile = 4;
		$resultFieldPositionInFile = 5;
		$limsIdSegmentCode = "OBR";
		$resultSegmentCode = "OBX";
	}

	if ($nombreEquipo == 'V3600') {
		$equipmentId = 17;
		$segmentIdPositionInFile = 0;
		$equipmentExamCodeFieldSeparator = "+";
		$resultFieldSeparator = "^";
		$limsIdFieldPositionInFile = 3;
		$equipmentExamCodeFieldPositionInFile = 3;
		$resultFieldPositionInFile = 5;
		$limsIdSegmentCode = "SAC";
		$resultSegmentCode = "OBX";
	}

	while (!feof($file)) {
		$currentLine = explode("|", fgets($file));
		$currentSegmentCode = $currentLine[$segmentIdPositionInFile];

		if (strstr($currentSegmentCode, $limsIdSegmentCode)) {
			$limsIdField = $currentLine[$limsIdFieldPositionInFile];
			if ($limsIdField == "") {
				$tableData .= "<tr><td colspan='5'>Error (2): N° atención vacío</td></tr>";
				$attentionId = "";
				$tubeCode = "";
				continue;
			}

			$limsIdFieldArray = explode("-", $limsIdField);

			if (count($limsIdFieldArray) < 2) {
				$tableData .= "<tr><td colspan='5'>Error (3): N° atención con formato incorrecto</td></tr>";
				$attentionId = "";
				$tubeCode = "";
				continue;
			}

			$attentionId = $limsIdFieldArray[0];
			$tubeCode = $limsIdFieldArray[1];
		}

		if (strstr($currentSegmentCode, $resultSegmentCode)) {
			$equipmentExamCodeField = $currentLine[$equipmentExamCodeFieldPositionInFile];
			$resultField = $currentLine[$resultFieldPositionInFile];

			if ($equipmentExamCodeField == "") {
				$tableData .= "<tr><td colspan='5'>Error (4): Código de examen en equipo vacío</td></tr>";
				continue;
			}

			if ($resultField == "") {
				$tableData .= "<tr><td colspan='5'>Error (5): Resultado vacío</td></tr>";
				continue;
			}

			$equipmentExamCode = $equipmentExamCodeField;
			if ($equipmentId == 13 || $equipmentId == 17) { # ej: OBX|||^^^1.0000+004+1.0|
				$aux = explode($equipmentExamCodeFieldSeparator, $equipmentExamCodeField);
				$equipmentExamCode = $aux[1];
			}

			$reactiveArray = ['069', '017', '023']; /* Transformación de resultado de examen de VIH, HEP B o HEP C a texto. */

			if (($equipmentId == 13 || $equipmentId == 17) && in_array($equipmentExamCode, $reactiveArray) && is_numeric($resultField)) {
				if (in_array($equipmentExamCode, ['023', '069'])) {
					$resultField = $resultField < 1 ? 'NO REACTIVO' : 'REACTIVO';
				} else {
					if ($resultField < 0.9) {
						$resultField = 'NO REACTIVO';
					} else if ($resultField < 5.0) {
						$resultField = 'DUDOSO';
					} else {
						$resultField = 'REACTIVO';
					}
				}
			}

			if ($attentionId == "" || $tubeCode == "") continue;

			$query = $mysqli->prepare("SELECT ea.ID_EXATE, ea.RESULTADO, DATE_FORMAT(ea.FECHA_VAL, '%d-%m-%Y %H:%i') AS FECHA_VAL, ex.NOMBRE, exeq.COD_INTERNO, exeq.POSICION_RESULTADO
			FROM atenciones a
			INNER JOIN examenes_atenciones ea ON ea.ID_ATENCION = a.ID_ATENCION
			INNER JOIN examenes ex ON ex.COD_INTERNO = ea.COD_EXAMEN
			INNER JOIN examenes_eq exeq ON exeq.COD_INTERNO = ea.COD_EXAMEN AND exeq.COD_EXAMEN_EQUIPO = ? AND exeq.ID_EQUIPO = ? AND exeq.TIPO_TUBO = ?
			WHERE a.ID_ATENCION = ?");
			$query->bind_param("siii", $equipmentExamCode, $equipmentId, $tubeCode, $attentionId);
			$query->execute();
			$queryResult = $query->get_result();

			# $tableData .= "<tr><td colspan='5'> $equipmentExamCode $equipmentId $tubeCode $attentionId $queryResult->num_rows </td></tr>";
			if ($queryResult->num_rows > 0) {
				while ($data = $queryResult->fetch_array(MYSQLI_ASSOC)) {
					$tableData .= grabarResultadosFila($data, $resultField, $attentionId, $resultFieldSeparator, $equipmentId);
				}
			}
		}
	}
	return $tableData;
}

if (isset($_REQUEST['resultados'])) {
	$nombreArchivo = $_REQUEST['resultados'];
	$nombreArchivoArray = explode("_", $nombreArchivo);
	$tipoArchivo = $nombreArchivoArray[0];
	$nombreEquipo = $nombreArchivoArray[1];

	if ($tipoArchivo == "S") return false;

	if ($tipoArchivo == "R") {
		$archivoResultados = "../Archivos_in/$nombreEquipo/$nombreArchivo";
		$tableData = recorrerArchivoResultados($archivoResultados, $nombreEquipo);
		fclose($file);
	}

	# unlink();
}
ob_start();
?>

<div>
	<a class="btn btn-primary" href="carga.php"> <i class="fa fa-lg fa-arrow-circle-left"></i> Volver a cargar</a>
</div>
<br>
<p class="font-md text-center" style='width:80%'>Archivo de resultados proveniente de equipo: <?= $nombreEquipo ?></p>
<table class='table table-bordered table-hover' style='width:80%'>
	<thead>
		<tr>
			<th>N° atención</th>
			<th>Código examen</th>
			<th>Nombre examen</th>
			<th>Resultado</th>
			<th>Estado de carga de resultado</th>
		</tr>
	</thead>
	<tbody>
		<?= $tableData ?>
	</tbody>
</table>


<?php
$contenido = ob_get_contents();
ob_end_clean();

$ui = new SmartUI;
$options = array("editbutton" => false);
$widget = $ui->create_widget($options);

$widget->header = array(
	"title" => $datos_pantallas[$pantalla_actual]['body_title'],
	"icon" => 'fa fa-cog'
);
$widget->body('content', $contenido);
?>

<div id="main" role="main">
	<?php
	include("../inc/ribbon.php");
	?>

	<div id="content">
		<?php
		$widget->print_html();
		?>
	</div>
</div>

<?php
include("../inc/footer.php");
include("../inc/scripts.php");
?>