<?php
define('PERMITIDO', true);

$pantalla_actual = 'CAR_PAC';

require_once __DIR__ . '/../inc/init.php';
require_once __DIR__ . '/../inc/config.ui.php';
require_once __DIR__ . '/../inc/header.php';
require_once __DIR__ . '/../inc/nav.php';

$page_title = $datos_pantallas[$pantalla_actual]['page_title'];
$page_css[] = 'your_style.css';

$sql_convenios = "SELECT ID_EMPRESA, NBR FROM empresas WHERE FLAG_CONVENIO = 'S' ORDER BY NBR ASC";
$resultado_convenios = $mysqli->query($sql_convenios);
$opciones_convenios = '';
while ($convenio = $resultado_convenios->fetch_assoc()) {
	$opciones_convenios .= '<option value="' . $convenio['ID_EMPRESA'] . ' ">' .  $convenio['NBR'] . '</option>';
}

$sql_procedencias = "SELECT ID_CENTRO_CONTACTO, NOMBRE FROM centros_contacto ORDER BY NOMBRE ASC";
$resultado_procedencias = $mysqli->query($sql_procedencias);
$opciones_procedencias = '';
while ($procedencia = $resultado_procedencias->fetch_assoc()) {
	$opciones_procedencias .= '<option value="' . $procedencia['ID_CENTRO_CONTACTO'] . ' ">' .  $procedencia['NOMBRE'] . '</option>';
}

ob_start();
?>

<form id="formulario" action="sql_cod.php" method="post" autocomplete="off">
	<div class="row">
		<div class="col-sm-4 col-sm-offset-1">
			<h5>Datos archivo</h5>

			<div class="form-group">
				<label for="archivo">Archivo Excel (.xlsx):</label>
				<input type="file" class="form-control" id="archivo" name="archivo" accept=".xlsx">
			</div>
			<button type="button" id="validar" class="btn btn-success btn-sm">
				Validar
				<i class="fa fa-check"></i>
			</button>
		</div>

		<div class="col-sm-4 col-sm-offset-1">
			<h5>Datos plantilla</h5>

			<div class="form-group">
				<label for="nombre">Nombre:</label>
				<input type="text" class="form-control" name="nombre">
			</div>
			<div class="form-group">
				<label for="id_convenio">Convenio:</label>
				<select class="form-control" name="id_convenio">
					<option value="0">--Seleccione--</option>
					<?= $opciones_convenios ?>
				</select>
			</div>
			<div class="form-group">
				<label for="id_procedencia">Procedencia:</label>
				<select class="form-control" name="id_procedencia">
					<option value="">--Seleccione--</option>
					<?= $opciones_procedencias ?>
				</select>
			</div>
			<div class="form-group">
				<label for="obs">Observación:</label>
				<input type="text" class="form-control" name="obs">
			</div>
			<button type="button" id="crear" class="btn btn-primary btn-sm" disabled>
				Crear plantilla
				<i class="fa fa-plus"></i>
		</div>
	</div>
</form>

<br>

<div class="row">
	<div class="col-sm-8 col-sm-offset-2">
		<table style="display: none" class="table table-hover table-bordered" id="tabla-errores">
			<thead>
				<tr>
					<th>Celda</th>
					<th>Descripción</th>
				</tr>
			</thead>

			<tbody>
			</tbody>
		</table>
	</div>
</div>

<?php
$contenido = ob_get_contents();
ob_end_clean();

$ui = new SmartUI;
$options = ['editbutton' => false];
$widget = $ui->create_widget($options);

$widget->header = [
	'title' => $datos_pantallas[$pantalla_actual]['body_title'],
	'icon' => 'fa fa-file-excel-o'
];
$widget->body('content', $contenido);
?>

<div id="main" role="main">
	<?php
	require_once '../inc/ribbon.php';
	?>

	<div id="content">
		<?php
		$widget->print_html();
		?>
	</div>
</div>

<?php
require_once '../inc/footer.php';
require_once '../inc/scripts.php';
?>

<script>
	var tabla = null;

	function actualizarTabla(errores) {
		var htmlErrores = '';

		if (errores.length == 0) {
			htmlErrores += '<tr><td></td><td>El archivo no registra errores</td></tr>';
		} else {
			for (var coordenada in errores) {
				htmlErrores += '<tr>';
				htmlErrores += '<td>' + coordenada + '</td>';
				htmlErrores += '<td>' + errores[coordenada] + '</td>';
				htmlErrores += '</tr>';
			}
		}

		$('#tabla-errores').hide();

		if (tabla != null) {
			tabla.destroy();
		}

		$('#tabla-errores tbody').html(htmlErrores);

		tabla = $('#tabla-errores').DataTable({
			'lengthMenu': [
				[10, 25, 50],
				[10, 25, 50]
			],
			'language': {
				'sProcessing': 'Procesando...',
				'sZeroRecords': 'No se encontraron resultados',
				'sInfoPostFix': '',
				'sUrl': '',
				'oPaginate': {
					'sFirst': 'Primero',
					'sPrevious': 'Anterior',
					'sNext': 'Siguiente',
					'sLast': 'Último'
				},
				'sInfo': '_START_ a _END_ de _TOTAL_ Registros',
				'sInfoEmpty': '0 Registros',
				'sInfoFiltered': '(de _MAX_ Registros en total)',
				'sLengthMenu': 'Mostrar _MENU_ Registros',
				'sSearch': 'Buscar: '
			},
			'pageLength': 10,
			'order': [0, 'asc'],
			'columns': [
				null,
				null
			],
			'destroy': true
		});

		$('#tabla-errores').show();
	}

	$(document).ready(function() {
		$('#validar').click(function() {
			var formulario = $('#formulario')[0];
			var datos = new FormData(formulario);

			$.ajax({
				type: 'POST',
				url: 'sql_cod.php?validar=true',
				data: datos,
				dataType: 'json',
				processData: false,
				contentType: false,
				success: function(jsonRespuesta) {
					if (jsonRespuesta.éxito) {
						exito();

						actualizarTabla(jsonRespuesta.errores);

						if (jsonRespuesta.errores.length == 0) {
							$('#crear').prop('disabled', false);
						} else {
							$('#archivo').val('');
							$('#crear').prop('disabled', true);
						}
					} else {
						error(jsonRespuesta.mensaje);
						$('#crear').prop('disabled', true);
					}
				},
				timeout: 60 * 1000
			});
		});

		$('#crear').click(function() {
			var formulario = $('#formulario')[0];
			var datos = new FormData(formulario);

			$.ajax({
				type: 'POST',
				url: 'sql_cod.php?crear=true',
				data: datos,
				dataType: 'json',
				processData: false,
				contentType: false,
				success: function(jsonRespuesta) {
					if (jsonRespuesta.éxito) {
						exito();
						window.location.replace('../m_plantillas/e_plantilla.php?idp=' + jsonRespuesta.id_plantilla);
					} else {
						error(jsonRespuesta.mensaje);
					}
				},
				timeout: 60 * 1000
			});
		});
	});
</script>

<?php
include_once '../inc/google-analytics.php';
?>