<?php
define('PERMITIDO', true);
$pantalla_actual = 'CAR_PAC';
require_once __DIR__ . '/../inc/init.php';
require_once __DIR__ . '/vendor/autoload.php';
require_once __DIR__ . '/lib.php';

$lector = new PHPExcel_Reader_Excel2007();

if (!isset($_FILES['archivo']['tmp_name']) || $_FILES['archivo']['tmp_name'] === '') {
	$respuesta = ['éxito' => false, 'mensaje' => 'Debe seleccionar un archivo.'];
	echo json_encode($respuesta);
	die();
}

$ruta = $_FILES['archivo']['tmp_name'];
PHPExcel_Settings::setZipClass(PHPExcel_Settings::PCLZIP);
$libro = $lector->load($ruta);

if ($libro->getSheetCount() === 0) {
	$respuesta = ['éxito' => false, 'mensaje' => 'El archivo seleccionado no es válido.'];
	echo json_encode($respuesta);
	die();
}

$hoja = $libro->getSheet(0);

// Se consulta si la plantilla es derivada (cuenta con la columna de identificador de muestra)
$esDerivada = esDerivada($hoja);

$cantidadPacientes = obtenerCantidadPacientes($hoja);
if ($cantidadPacientes === 0) {
	$respuesta = ['éxito' => false, 'mensaje' => 'El primer campo RUT está vacio.'];
	echo json_encode($respuesta);
	die();
}

$previsiones = obtenerPrevisiones();
$comunas = obtenerComunas();
$países = obtenerPaíses();

$errores = validarHoja($hoja, $cantidadPacientes, $esDerivada);
if (sizeof($errores) === 0) {
	try {
		$pacientesExcel = obtenerPacientesExcel($hoja, $cantidadPacientes, $esDerivada);
		$pacientesBaseDatos = obtenerPacientesBaseDatos($pacientesExcel);
	} catch (Exception $e) {
		$errores = ['-' => $e->getMessage()];
	}
	
	if (sizeof($errores) === 0) {
		$errores = obtenerDiferencias($pacientesBaseDatos, $pacientesExcel);
	}
}

if (isset($_GET['validar'])) {
	$respuesta = ['éxito' => true, 'errores' => $errores];
	echo json_encode($respuesta);
	die();
}

if (isset($_GET['crear'])) {
	if (sizeof($errores) > 0) {
		$respuesta = ['éxito' => false, 'mensaje' => 'No se puede crear la plantilla si el archivo presenta errores.'];
		echo json_encode($respuesta);
		die();
	}
	
	if (!isset($_POST['nombre']) || $_POST['nombre'] == '') {
		$respuesta = ['éxito' => false, 'mensaje' => 'Se debe especificar un nombre para la plantilla.'];
		echo json_encode($respuesta);
		die();
	}
	
	if (!isset($_POST['id_procedencia']) || $_POST['id_procedencia'] == '') {
		$respuesta = ['éxito' => false, 'mensaje' => 'Se debe especificar una procedencia para la plantilla.'];
		echo json_encode($respuesta);
		die();
	}
	
	if ($esDerivada) {
		if (!isset($_POST['id_convenio']) || $_POST['id_convenio'] == '') {
			$respuesta = ['éxito' => false, 'mensaje' => 'Se debe especificar un convenio para la plantilla.'];
			echo json_encode($respuesta);
			die();
		}
		

		$datos_convenio = obtenerDatosEmpresa($_POST['id_convenio']);
		// echo $datos_convenio['NBR'];
		// exit(0);
		if (!in_array($datos_convenio['NBR'], ['HOSP G FRICKE', 'MINSAL', 'HOSPITAL DE NIÑOS'])) {
			$respuesta = ['éxito' => false, 'mensaje' => 'El convenio seleccionado no es válido para plantillas derivadas.'];
			echo json_encode($respuesta);
			die();
		}

		$datos_procedencia = obtenerDatosProcedencia($_POST['id_procedencia']);
		// echo $datos_procedencia['NOMBRE'];
		// exit(0);
		if (!in_array($datos_procedencia['NOMBRE'], ['HOSP FRICKE', 'MINSAL', 'HOSP. DE NIÑOS'])) {
			$respuesta = ['éxito' => false, 'mensaje' => 'La procedencia seleccionada no es válida para plantillas derivadas.'];
			echo json_encode($respuesta);
			die();
		}
	}
	
	$nombre = $_POST['nombre'];
	$id_convenio = $_POST['id_convenio'];
	$id_procedencia = $_POST['id_procedencia'];
	$obs = $_POST['obs'];
	
	$datos_atencion = grabarPacientes($pacientesBaseDatos, $pacientesExcel, $id_convenio, $esDerivada);
	
	$id_plantilla = crearPlantilla($datos_atencion, $nombre, $id_convenio, $id_procedencia, $obs, $esDerivada);
	
	$respuesta = ['éxito' => true, 'id_plantilla' => $id_plantilla];
	echo json_encode($respuesta);
	die();
}
?>