<?php
$pantalla_actual = 'CRE_INF_MUE_RECH';
define('PERMITIDO', true);

require_once('../inc/init.php');
require_once('../inc/config.ui.php');
$page_title = $datos_pantallas[$pantalla_actual]['page_title'];
$page_css[] = 'your_style.css';
include('../inc/header.php');
include('../inc/nav.php');

ob_start();
?>

<div class="row">
	<div class="col-md-3">
	</div>
	<div class="col-md-6">
		<div class="panel panel-info">
			<div class="panel-body">
				<form id="formGenerarInformeMuestrasRechazadas" name="formGenerarInformeMuestrasRechazadas" class="smart-form" method="get" action="">
					<?php
					if ($_SESSION['MM_UserGroup'] == 'ADMINISTRADOR' || $usuario_id == 1011) { # id:1011 - joselyn valencia
						$sql_centros_contacto = "SELECT ID_CENTRO_CONTACTO, NOMBRE FROM centros_contacto";
						$resultado_centros_contacto = $mysqli->query($sql_centros_contacto);
					?>
						<section>
							<div class="row">
								<div class="col col-6">
									<h4>Procedencia:</h4>
								</div>
								<div class="col col-6">
									<label class="input">
										<select id="centro_contacto" class="select2" style="width: 100%;">
											<?php
											while ($datos_centro_contacto = $resultado_centros_contacto->fetch_assoc()) {
											?>
												<option value="<?= $datos_centro_contacto['ID_CENTRO_CONTACTO']; ?>"><?= $datos_centro_contacto['NOMBRE']; ?></option>
											<?php
											}
											?>
										</select>
									</label>
								</div>
							</div>
						</section>
					<?php	}	?>
					<section>
						<div class="row">
							<div class="col col-6">
								<h4>Fecha Inicio:</h4>
							</div>
							<div class="col col-6">
								<label class="input">
									<input type="text" data-mask="99-99-9999" data-mask-placeholder="*" class="input-sm" name="f_inicio" id="f_inicio" value="<?php if (isset($_GET['f_inicio'])) echo $_GET['f_inicio']; ?>" placeholder="**-**-****" />
								</label>
							</div>
						</div>
					</section>
					<section>
						<div class="row">
							<div class="col col-6">
								<h4>Fecha Término:</h4>
							</div>

							<div class="col col-6">
								<label class="input">
									<input type="text" data-mask="99-99-9999" data-mask-placeholder="*" class="input-sm" name="f_termino" id="f_termino" value="<?php if (isset($_GET['f_termino'])) echo $_GET['f_termino']; ?>" placeholder="**-**-****" />
								</label>
							</div>
						</div>
					</section>
					<section>
						<div class="row">
							<div class="col-md-12 text-center">
								<a class="btn btn-sm btn-primary" id="generar">Generar informe</a>
							</div>
						</div>
					</section>
					<section id="spinner" style="display:none;">
						<div align="center">
							<i class="fa fa-spinner fa-spin fa-2x"></i>
						</div>
					</section>
					<section id="descarga" style="display:none;">
						<div class="row">
							<div class="col-md-12 text-center">
								<h4>Descargar Informe de Muestras Rechazadas</h4>
								<br />
								<a class="btn btn-default btn-sm" id="btnDescargar" target="_blank">
									<i class="fa fa-cloud-download fa-lg"></i> Descargar PDF
								</a>
							</div>
						</div>
					</section>
				</form>
			</div>
		</div>
	</div>
</div>

<?php
$contenido = ob_get_contents();
ob_end_clean();

$ui = new SmartUI;
$options = array('editbutton' => false);
$widget = $ui->create_widget($options);

$widget->header = array(
	'title' => $datos_pantallas[$pantalla_actual]['body_title'],
	'icon' => 'fa fa-ban'
);
$widget->body('content', $contenido);
?>

<div id="main" role="main">
	<?php
	include("../inc/ribbon.php");
	?>

	<div id="content">
		<?php
		$widget->print_html();
		?>
	</div>
</div>

<?php
include('../inc/footer.php');
include('../inc/scripts.php');
?>

<script>
	$(document).ready(function() {

		$(function() {
			$('#f_inicio').datepicker({
				onClose: function(selectedDate) {
					$('#f_termino').datepicker('option', 'minDate', selectedDate);
				}
			});

			$('#f_termino').datepicker({
				onClose: function(selectedDate) {
					$('#f_inicio').datepicker('option', 'maxDate', selectedDate);
				}
			});
		});

		$.validator.addMethod(
			'fecha',
			function(value, element) {
				return value.match(/^(0?[1-9]|[12][0-9]|3[0-1])[/., -](0?[1-9]|1[0-2])[/., -](19|20)?\d{2}$/);
			},
			'Ingrese un fecha en formato dd-mm-yyyy.'
		);

		$('#formGenerarInformeMuestrasRechazadas').validate({
			rules: {
				f_inicio: {
					required: true,
					fecha: true
				},
				f_termino: {
					required: true,
					fecha: true
				}
			},

			messages: {
				f_inicio: {
					required: 'Ingrese una fecha',
					date: 'Ingrese una fecha válida'
				},
				f_termino: {
					required: 'Ingrese una fecha',
					date: 'Ingrese una fecha válida'
				}
			},

			onfocusout: false,
			onsubmit: true,

			errorPlacement: function(error, element) {
				error.insertAfter(element.parent());
			}
		});

		$('#generar').on('click', function() {
			var form = $("#formGenerarInformeMuestrasRechazadas");
			if (form.valid()) {
				$('#spinner').fadeIn(100).delay(1000).fadeOut(100);
				$('#descarga').delay(1210).fadeIn(100);
				$('#btnDescargar').attr('href', 'muestras_rechazadas_pdf.php?f_inicio=' + $('#f_inicio').val() + '&f_termino=' + $('#f_termino').val() + '&centro_contacto=' + $('#centro_contacto').val());
			}
		});
	})
</script>

<?php
include('../inc/google-analytics.php');
?>