<?php
$pagina = 0;
define('PERMITIDO', true);
require_once('../inc/init.php');
require_once('../assets/tcpdf/tcpdf.php');

$qUrlSitioWeb = $mysqli->prepare("SELECT VALOR FROM parametros_sistema WHERE COD_PARAMETRO = 9");
$qUrlSitioWeb->execute();
$qUrlSitioWeb->bind_result($urlSitioWeb);
$qUrlSitioWeb->fetch();
$qUrlSitioWeb->store_result();
$qUrlSitioWeb->close();

class ResultadosDialisis extends TCPDF
{

	public function Header()
	{
		global $urlSitioWeb;

		$this->setImageScale(13);
		$this->setJPEGQuality(100);
		$this->Image('../imagenes/new_logo.jpg', '10', '10');
		# $this->Image('../assets/img/logo_informes.png', '10', '10'); TO DO: LOGO CON ESLOGAN

		$titulo = '<b>INFORME DE RECHAZO DE MUESTRAS POR PROCENDENCIA</b>';
		$this->SetFont('times', '', 10);
		$this->writeHTMLCell('75', '', 68, 10, $titulo, 0, 1, 0, true, 'C', true);

		$this->SetFont('times', '', 9);
		$this->writeHTMLCell('', '', 150, 12, $urlSitioWeb, 0, 1, 0, true, 'L', true);
	}

	public function Footer()
	{
		$this->SetFont('times', '', 9);

		$paginas = 'Página ' . $this->getAliasNumPage() . ' de ' . $this->getAliasNbPages();
		$this->writeHTMLCell('', '', '', '', $paginas, 0, 1, 0, true, 'C', true);

		$datos = 'Arlegui 440<br />Oficina 218<br />(32) 2714189<br />Viña del Mar';
		$this->writeHTMLCell('', '', '180', '275', $datos, 0, 1, 0, true, 'L', true);

		$estilo_linea = array('width' => 0.5, 'cap' => 'butt', 'join' => 'miter', 'dash' => 0, 'color' => array(255, 0, 0));
		$this->Line(178, 275, 178, 291, $estilo_linea);
	}
}

if (($_SESSION['MM_UserGroup'] == 'ADMINISTRADOR' || $usuario_id = 1011) && isset($_GET['centro_contacto'])) { // id:1011 - joselyn valencia
	$sql_centro_contacto = "SELECT NOMBRE FROM centros_contacto WHERE ID_CENTRO_CONTACTO = {$_GET['centro_contacto']}";
	$resultado_centro_contacto = $mysqli->query($sql_centro_contacto);

	if ($resultado_centro_contacto->num_rows > 0) {
		$usuario_centro = $_GET['centro_contacto'];
		$usuario_centroContacto = $resultado_centro_contacto->fetch_assoc()['NOMBRE'];
	}
}

$pdf = new ResultadosDialisis('P', 'mm', 'letter', true, 'UTF-8', false);

$pdf->SetMargins(10, 30, 10);
$pdf->SetHeaderMargin(10);
$pdf->SetFooterMargin(10);
$pdf->SetAutoPageBreak(true, 40);
$pdf->setFontSubsetting(true);
$pdf->AddPage();

$inicio = date('Y-m-d', strtotime('-1 week'));
$fin = date('Y-m-d');
if (isset($_GET['f_inicio']) && $_GET['f_inicio'] != '' && isset($_GET['f_termino']) && $_GET['f_termino'] != '') {
	$inicio = implode('-', array_reverse(explode('-', $_GET['f_inicio'])));
	$fin = implode('-', array_reverse(explode('-', $_GET['f_termino'])));
}

$qAtencioneslocal = $mysqli->prepare("SELECT COUNT(DISTINCT a.ID_ATENCION, ea.TIPO_TUBO)
FROM atenciones a
INNER JOIN examenes_atenciones ea ON ea.ID_ATENCION = a.ID_ATENCION
INNER JOIN toma_recepcion_muestras trm ON ea.ID_ATENCION = trm.ID_ATENCION AND ea.TIPO_TUBO = trm.TIPO_TUBO AND trm.RESPONSABLE_RM IS NOT NULL # que los tubos tengan registro de recepcion de muestra
WHERE (a.FECHA_R BETWEEN ? AND ?) AND a.ID_CENTRO_CONTACTO = ? AND a.FLAG_ELIMINADO = 0");
$qAtencioneslocal->bind_param('sss', $inicio, $fin, $usuario_centro);
$qAtencioneslocal->execute();
$qAtencioneslocal->bind_result($countTubosRecepcionados);
$qAtencioneslocal->store_result();
$qAtencioneslocal->fetch();
$qAtencioneslocal->close();

# atenciones rechazadas
$muestras_rechazadas = $mysqli->prepare("SELECT DISTINCT DATE_FORMAT(a.FECHA_R, '%d/%m/%Y') FECHA_RECEPCION, a.ID_ATENCION, cg.DESCRIPCION_CG AS TUBO, cg2.DESCRIPCION_CG AS MOTIVO, rt.OBS_RECHAZO,
CONCAT_WS(' ', p.NOMBRES, p.APELLIDO_PATERNO, p.APELLIDO_MATERNO) AS PACIENTE
FROM atenciones a
INNER JOIN personas p ON p.ID_PERSONA = a.ID_CLIENTE
INNER JOIN examenes_atenciones ea ON ea.ID_ATENCION = a.ID_ATENCION
INNER JOIN rechazos_tubos rt ON rt.ID_ATENCION = a.ID_ATENCION AND rt.TUBO_RECHAZO = ea.TIPO_TUBO
INNER JOIN toma_recepcion_muestras trm ON ea.ID_ATENCION = trm.ID_ATENCION AND ea.TIPO_TUBO = trm.TIPO_TUBO AND trm.RESPONSABLE_RM IS NOT NULL
LEFT JOIN codigos_generales cg ON ea.TIPO_TUBO = cg.CODIGO AND cg.COD_TABLA = 'SIS_TIPTUB' 
LEFT JOIN codigos_generales cg2 ON rt.MOTIVO_RECHAZO = cg2.CODIGO AND cg2.COD_TABLA = 'SIS_MOTREC'
WHERE (a.FECHA_R BETWEEN ? AND ?) AND a.ID_CENTRO_CONTACTO = ? AND a.FLAG_ELIMINADO = 0
ORDER BY FECHA_R, HORA_R, ID_ATENCION ASC");
echo $mysqli->error;
$muestras_rechazadas->bind_param('sss', $inicio, $fin, $usuario_centro);
$muestras_rechazadas->execute();
$muestras_rechazadas->bind_result($fecha, $atencion, $tipo_tubo, $motivo_rechazo, $obs_rechazo, $paciente);
$muestras_rechazadas->store_result();

$hoy = date('d-m-Y');
$porcentajeRechazadas = number_format(($muestras_rechazadas->num_rows / $countTubosRecepcionados) * 100, 2);

# tabla de encabezado
$encabezado = "
	<table border=\"1\" cellpadding=\"40\">
		<tbody>
			<tr>
				<td style=\"width: 25%\">PROCENDENCIA</td>
				<td style=\"width: 25%\">{$usuario_centroContacto}</td>
				<td style=\"width: 25%\">FECHA</td>
				<td style=\"width: 25%\">{$hoy}</td>
			</tr>
			<tr>
				<td style=\"width: 25%\">PERIODO A INFORMAR</td>
				<td style=\"width: 25%\">DE {$_GET['f_inicio']} A {$_GET['f_termino']}</td>
				<td style=\"width: 25%\">TOTAL MUESTRAS</td>
				<td style=\"width: 25%\">{$countTubosRecepcionados}</td>
			</tr>
			<tr>
				<td style=\"width: 25%\">MUESTRAS RECHAZADAS</td>
				<td style=\"width: 25%\">{$muestras_rechazadas->num_rows}</td>
				<td style=\"width: 25%\">PORCENTAJE RECHAZO</td>
				<td style=\"width: 25%\">{$porcentajeRechazadas}%</td>
			</tr>
		</tbody>
	</table>";
$pdf->SetFont('times', '', 10);
$pdf->writeHTML($encabezado, true, false, false, false, '');

if ($muestras_rechazadas->num_rows == 0) {
	$mensaje = '<h4>No hubo rechazo de muestras en el periodo indicado.</h4><br>';
	$pdf->SetFont('times', '', 10);
	$pdf->writeHTML($mensaje, true, false, false, false, '');
} else {
	$tbl =
		'<table border="1" cellpadding="2" style="text-align: center">
			<thead>
				<tr style="background-color: #f8f8f8">
					<th style="width: 10%">FECHA</th>
					<th style="width: 10%">N° ATENCIÓN</th>
					<th style="width: 30%">PACIENTE</th>
					<th style="width: 15%">TIPO TUBO</th>
					<th style="width: 35%">MOTIVO</th>
				</tr>
			</thead>
			<tbody>';

	while ($muestras_rechazadas->fetch()) {
		$tbl .= "
				<tr nobr=\"true\">
					<td style=\"width: 10%\">{$fecha}</td>
					<td style=\"width: 10%\">{$atencion}</td>
					<td style=\"width: 30%\">{$paciente}</td>
					<td style=\"width: 15%\">{$tipo_tubo}</td>
					<td style=\"width: 35%\">{$motivo_rechazo}</td>
				</tr>";
	}
	$muestras_rechazadas->close();

	$tbl .= '
			</tbody>
		</table>';

	$pdf->SetFont('times', '', 8);
	$pdf->writeHTML($tbl, true, false, false, false, '');
}

// Firma
$pdf->setImageScale(2.5);
$pdf->setJPEGQuality(100);
$pdf->writeHTML('<br />');
$pdf->Image('../firmas/firmas_informe_muestras_rechazadas.jpg', 50, null, 100, 0, 0, '', null, 'C');
$pdf->writeHTML('<br><br><br><br><br><br>');

$itemsListaCriterio = "";
$qCriterios = $mysqli->prepare("SELECT CODIGO, DESCRIPCION_CG FROM codigos_generales WHERE COD_TABLA = 'SIS_MOTREC' # AND FLAG_ELIMINADO != 1");
$qCriterios->execute();
$qCriterios->bind_result($codigo, $descripcion_cg);
$qCriterios->store_result();
while ($qCriterios->fetch()) {
	$itemsListaCriterio .= "<li>$descripcion_cg</li>";
}

$criterios = "
<div style=\"page-break-inside: avoid\">
	<h3>Criterios de Rechazo y Repetición de Muestras</h3>
	<ol>
		$itemsListaCriterio
	</ol>
</div>";
$pdf->SetFont('times', '', 10);
$pdf->writeHTML($criterios, true, false, false, false, '');

ob_end_clean();

$pdf->Output('muestras_rechazadas.pdf', 'I');
