<?php
$pantalla_actual = 'CRE_PLA_RES';
define('PERMITIDO', true);
require_once("../inc/init.php");
require_once("../inc/config.ui.php");
$page_title = $datos_pantallas[$pantalla_actual]['page_title'];
$page_css[] = "your_style.css";
include("../inc/header.php");
include("../inc/nav.php");

ob_start();
?>

<div class="row">
    <div class="col-md-3">
    </div>
    <div class="col-md-6">
        <div class="panel panel-info">
            <div class="panel-body">

                <form id="formBuscar" name="formBuscar" class="smart-form" method="get" action="">
                    <section>
                        <div class="row">
                            <div class="col col-6">
                                <h4>Fecha Inicio:</h4>
                            </div>
                            <div class="col col-6">
                                <label class="input">
                                    <input type="text" data-mask="99-99-9999" data-mask-placeholder="*" class="input-sm" name="f_inicio" id="f_inicio" value="<?php if (isset($_GET['f_inicio'])) echo $_GET['f_inicio']; ?>" placeholder="**-**-****" />
                                </label>
                            </div>
                        </div>
                    </section>
                    <section>
                        <div class="row">
                            <div class="col col-6">
                                <h4>Fecha Término:</h4>
                            </div>
                            <div class="col col-6">
                                <label class="input">
                                    <input type="text" data-mask="99-99-9999" data-mask-placeholder="*" class="input-sm" name="f_termino" id="f_termino" value="<?php if (isset($_GET['f_termino'])) echo $_GET['f_termino']; ?>" placeholder="**-**-****" />
                                </label>
                            </div>
                        </div>
                    </section>
                    <section>
                        <div class="row">
                            <div class="col-md-12 text-center">
                                <a class="btn btn-sm btn-primary" id="Generar">Generar</a>
                            </div>
                        </div>
                    </section>

                    <section id="spinner" style="display:none;">
                        <div align="center"><i class="fa fa-spinner fa-spin fa-2x"></i></div>
                    </section>

                    <section id="Descarga" style="display:none;">
                        <div class="row">

                            <div class="col-md-4 text-center">
                                <h4>Resultados Excel</h4>
                                <br />
                                <a target="_blank" class="btn btn-default btn-sm" title="Descargar Excel" id="btnDescargar1"><i class="fa fa-cloud-download fa-lg"></i> Descargar Excel</a>
                            </div>

                            <div class="col-md-4 text-center">
                                <h4>Resultados PDF 1</h4>
                                <br />
                                <a target="_blank" class="btn btn-default btn-sm" title="Descargar PDF" id="btnDescargar2"><i class="fa fa-cloud-download fa-lg"></i> Descargar PDF</a>
                            </div>

                            <div class="col-md-4 text-center">
                                <h4>Resultados PDF 2</h4>
                                <br />
                                <a target="_blank" class="btn btn-default btn-sm" title="Descargar PDF" id="btnDescargar22"><i class="fa fa-cloud-download fa-lg"></i> Descargar PDF</a>
                            </div>
                            <?php if (1 == 2) { ?>
                                <div class="col-md-4 text-center">
                                    <h4>Informe de Rechazo de Muestras</h4>
                                    <br />
                                    <a target="_blank" class="btn btn-default btn-sm" title="Descargar PDF" id="btnDescargar3"><i class="fa fa-cloud-download fa-lg"></i> Descargar PDF</a>
                                </div>
                            <?php } ?>

                        </div>
                    </section>

                    <input type="hidden" name="buscar" />
                </form>
            </div>
        </div>
    </div>
</div>

<?php
$contenido = ob_get_contents();
ob_end_clean();

$ui = new SmartUI;
$options = array("editbutton" => false);
$widget = $ui->create_widget($options);

$widget->header = array(
    "title" => $datos_pantallas[$pantalla_actual]['body_title'],
    "icon" => 'fa fa-group'
);
$widget->body('content', $contenido);
?>

<div id="main" role="main">
    <?php
    include("../inc/ribbon.php");

    ?>

    <div id="content">
        <?php
        $widget->print_html();
        ?>
    </div>
</div>

<?php
include("../inc/footer.php");
?>

<?php
include("../inc/scripts.php");
?>

<script>
    $(document).ready(function() {
        $(function() {
            $("#f_inicio").datepicker({
                onClose: function(selectedDate) {
                    $("#f_termino").datepicker("option", "minDate", selectedDate);
                }
            });
            $("#f_termino").datepicker({
                onClose: function(selectedDate) {
                    $("#f_inicio").datepicker("option", "maxDate", selectedDate);
                }
            });
        });

        $.validator.addMethod(
            "fecha",
            function(value, element) {
                return value.match(/^(0?[1-9]|[12][0-9]|3[0-1])[/., -](0?[1-9]|1[0-2])[/., -](19|20)?\d{2}$/);
            },
            "Ingrese un fecha en formato dd-mm-yyyy."
        );


        $("#formBuscar").validate({
            rules: {
                f_inicio: {
                    required: true,
                    fecha: true
                },
                f_termino: {
                    required: true,
                    fecha: true
                }
            },
            messages: {
                f_inicio: {
                    required: 'Ingrese una fecha',
                    date: 'Ingrese una fecha válida'
                },
                f_termino: {
                    required: 'Ingrese una fecha',
                    date: 'Ingrese una fecha válida'
                }
            },
            onfocusout: false,
            onsubmit: true,
            // Do not change code below
            errorPlacement: function(error, element) {
                error.insertAfter(element.parent());
            }
        });

        $('#Generar').on('click', function() {
            var form = $("#formBuscar");
            var valuesStart = $('#f_inicio').val().split("-");
            var valuesEnd = $('#f_termino').val().split("-");
            var dateStart = new Date(valuesStart[2], (valuesStart[1] - 1), valuesStart[0]);
            var dateEnd = new Date(valuesEnd[2], (valuesEnd[1] - 1), valuesEnd[0]);
            var fecha1 = moment(dateStart);
            var fecha2 = moment(dateEnd);

            if (fecha2.diff(fecha1, 'days') > 31) {
                alert("Debe seleccionar un rango de fechas inferior a 31 días");
                return false;
            }

            if (form.valid()) {

                $('#spinner').fadeIn(100).delay(1000).fadeOut(100);
                $('#Descarga').delay(1210).fadeIn(100);
                $('#btnDescargar1').attr('href', 'xls_resultados.php?f_inicio=' + $('#f_inicio').val() + '&f_termino=' + $('#f_termino').val() + '');
                $('#btnDescargar2').attr('href', 'resultados_dialisis_pdf.php?f_inicio=' + $('#f_inicio').val() + '&f_termino=' + $('#f_termino').val() + '');
                $('#btnDescargar22').attr('href', 'resultados_dialisis_2_pdf.php?f_inicio=' + $('#f_inicio').val() + '&f_termino=' + $('#f_termino').val() + '');
                $('#btnDescargar3').attr('href', 'atenciones_pdf.php?f_inicio=' + $('#f_inicio').val() + '&f_termino=' + $('#f_termino').val() + '');
            }
        });
    });
</script>

<?php
//include footer
include("../inc/google-analytics.php");
?>