<?php
$pagina = 0;

define('PERMITIDO', true);
require_once("../inc/init.php");
require_once('../assets/tcpdf/tcpdf.php');

class ResultadosDialisis extends TCPDF
{

	public function Header()
	{
		global $titulo;
		global $usuario_centroContacto;
		global $textoFiltro;
		$this->SetFont('times', '', 11);
		if ($usuario_centroContacto != '') $this->writeHTMLCell(200, '', 110, 15, 'Centro de Toma de Muestras: ' . $usuario_centroContacto, 0, 1, 0, true, 'L', true);
		$this->writeHTMLCell(200, '', 100, 20, $textoFiltro, 0, 1, 0, true, 'L', true);
		$this->SetFont('times', '', 9);
		$this->writeHTMLCell('50', '', 230, 8, $titulo, 0, 1, 0, true, 'C', true);

		$this->setImageScale(2.5);
		$this->setJPEGQuality(100);
		$this->Image('../assets/img/new_logo.jpg', '10', '10');
	}
	public function Footer()
	{

		$this->SetFont('times', '', 10);
		$paginas = "Página " . $this->getAliasNumPage() . ' de ' . $this->getAliasNbPages();
		$this->writeHTMLCell('', '', '', '', $paginas, 0, 1, 0, true, 'C', true);
		$this->setImageScale(2.5);
		$this->setJPEGQuality(100);
		$this->Image('../firmas/andoni.jpg', '210', '180');
	}
}

// Obtención de parámetros URL.
$inicio = date('Y-m-d', strtotime('-1 week'));
$fin = date('Y-m-d');
if (isset($_GET['f_inicio']) && $_GET['f_inicio'] != '' && isset($_GET['f_termino']) && $_GET['f_termino'] != '') {
	$inicio = implode('-', array_reverse(explode('-', $_GET['f_inicio'])));
	$fin = implode('-', array_reverse(explode('-', $_GET['f_termino'])));
}

// Generación de la consulta que obtiene las atenciones correspondientes a los filtros activados.
$qresultados = $mysqli->prepare("SELECT DATE_FORMAT(FECHA_R,'%d/%m/%Y'), cg.DESCRIPCION_CG, a.HORA_R, a.ID_ATENCION,
CONCAT_WS(' ', pac.NOMBRES, pac.APELLIDO_PATERNO, pac.APELLIDO_MATERNO) AS paciente, obsr.OBS
FROM atenciones a
INNER JOIN personas pac ON a.ID_CLIENTE = pac.ID_PERSONA
LEFT JOIN codigos_generales cg ON a.TURNO_DIALISIS = cg.CODIGO AND cg.COD_TABLA='SIS_TURDIA'
LEFT JOIN obs_resultados obsr ON a.ID_ATENCION = obsr.ID_ATENCION
WHERE (a.FECHA BETWEEN ? AND ?) AND a.ID_CENTRO_CONTACTO = ? AND a.FLAG_ELIMINADO = 0 
ORDER BY a.ID_ATENCION, a.HORA_R");
echo $mysqli->error;
$qresultados->bind_param('sss', $inicio, $fin, $usuario_centro);
$qresultados->execute();
$qresultados->bind_result($at_fecha, $at_turno_dialisis, $at_hora, $at_idAtencion, $at_paciente, $at_obs);
$qresultados->store_result();
$npaginas = floor($qresultados->num_rows / 22);

$titulo = 'Laboratorio Central<br>Arlegui 440 - Oficina 218<br>Viña del Mar<br>Fono: 32-2714189';
$textoFiltro = "Atenciones entre {$_GET['f_inicio']} y {$_GET['f_termino']} - N° Atenciones: $qresultados->num_rows";

$pdf = new ResultadosDialisis('L', 'mm', 'letter', true, 'UTF-8', false);

$pdf->SetMargins(10, 30, 10);
$pdf->SetHeaderMargin(10);
$pdf->SetFooterMargin(10);
$pdf->SetAutoPageBreak(true, 40);
$pdf->setFontSubsetting(true);
$pdf->SetFont('times', '', 10);

$resultados = array();
$analisis_disponibles = array();

while ($qresultados->fetch()) {
	$resultados[$at_idAtencion] = array(
		'at_fecha' => $at_fecha,
		'at_turno_dialisis' => $at_turno_dialisis,
		'at_hora' => $at_hora,
		'at_paciente' => $at_paciente,
		'at_obs' => $at_obs,
		'at_idAtencion' => $at_idAtencion
	);

	$qanalisis = $mysqli->prepare("SELECT examenes_atenciones.COD_EXAMEN, ex.NOMBRE, RESULTADO, cg.DESCRIPCION_CG AS unidad, N_DECIMALES
FROM examenes_atenciones
INNER JOIN examenes ex ON examenes_atenciones.COD_EXAMEN=ex.COD_INTERNO
INNER JOIN codigos_generales cg ON ex.UNIDAD_MEDIDA=cg.CODIGO AND cg.COD_TABLA='SIS_UNIMED'
WHERE ID_ATENCION=? AND USUARIO_VAL IS NOT NULL");
	$qanalisis->bind_param('i', $at_idAtencion);
	$qanalisis->execute();
	$qanalisis->bind_result($ana_codExamen, $ana_nombre, $ana_resultado, $ana_unidad, $ana_ndecimales);
	$qanalisis->store_result();

	while ($qanalisis->fetch()) {
		if (is_numeric($ana_resultado)) {
			if ($ana_ndecimales == "") {
				$ana_resultado = number_format($ana_resultado, '2', ',', '.');
			} else {
				$ana_resultado = number_format($ana_resultado, $ana_ndecimales, ',', '.');
			}
		}

		if (strpos($ana_codExamen, '04.01.026') !== false) {
			$resultados[$at_idAtencion]['FERRI'] = $ana_resultado;
			$analisis_disponibles['FERRI'] = true;
		} elseif (strpos($ana_codExamen, '04.03.018') !== false) {
			$resultados[$at_idAtencion]['PARAT'] = $ana_resultado;
			$analisis_disponibles['PARAT'] = true;
		} elseif (strpos($ana_codExamen, '11.06.16') !== false) {
			$resultados[$at_idAtencion]['VIH'] = $ana_resultado;
			$analisis_disponibles['VIH'] = true;
		} elseif (strpos($ana_codExamen, '05.06.077') !== false) {
			$resultados[$at_idAtencion]['HEPB'] = $ana_resultado;
			$analisis_disponibles['HEPB'] = true;
		} elseif (strpos($ana_codExamen, '05.06.081') !== false) {
			$resultados[$at_idAtencion]['HEPC'] = $ana_resultado;
			$analisis_disponibles['HEPC'] = true;
		} elseif (strpos($ana_codExamen, '00.00.086') !== false) {
			$resultados[$at_idAtencion]['COVID'] = $ana_resultado;
			$analisis_disponibles['COVID'] = true;
		}
	}
	$qanalisis->close();
}
$qresultados->close();

$lista_resultados = array_values($resultados);
//for($i = 0; $i < $npaginas; $i++) {
$pdf->AddPage();
$tbl =
	'<table border="1" cellpadding="2" style="text-align: center">
		<thead>
			<tr style="background-color:#F8F9F9">
				<th>FECHA</th>
				<th>TURNO</th>
				<th>ATENCIÓN</th>
				<th colspan="4">PACIENTE</th>';

if (isset($analisis_disponibles['FERRI'])) {
	$tbl .= '<th>FERRI</th>';
}
if (isset($analisis_disponibles['PARAT'])) {
	$tbl .= '<th>PARAT</th>';
}
if (isset($analisis_disponibles['VIH'])) {
	$tbl .= '<th>VIH</th>';
}
if (isset($analisis_disponibles['HEPB'])) {
	$tbl .= '<th>HEPB</th>';
}
if (isset($analisis_disponibles['HEPC'])) {
	$tbl .= '<th>HEPC</th>';
}
if (isset($analisis_disponibles['COVID'])) {
	$tbl .= '<th>COVID</th>';
}
$tbl .= '
			</tr>
		</thead>
	<tbody>';

for ($j = 0; $j < count($lista_resultados); $j++) {
	//		$j = $i * 22 + $j;
	$tbl .= '<tr nobr="true">
			<td>' . $lista_resultados[$j]['at_fecha'] . '</td>
			<td>' . $lista_resultados[$j]['at_turno_dialisis'] . '</td>
			<td>' . $lista_resultados[$j]['at_idAtencion'] . '</td>
			<td colspan="4" style="text-align: left">' . $lista_resultados[$j]['at_paciente'] . '</td>';

	if (isset($analisis_disponibles['FERRI'])) {
		$tbl .= '<td>' . $lista_resultados[$j]['FERRI'] . '</td>';
	}
	if (isset($analisis_disponibles['PARAT'])) {
		$tbl .= '<td>' . $lista_resultados[$j]['PARAT'] . '</td>';
	}
	if (isset($analisis_disponibles['VIH'])) {
		$tbl .= '<td>' . $lista_resultados[$j]['VIH'] . '</td>';
	}
	if (isset($analisis_disponibles['HEPB'])) {
		$tbl .= '<td>' . $lista_resultados[$j]['HEPB'] . '</td>';
	}
	if (isset($analisis_disponibles['HEPC'])) {
		$tbl .= '<td>' . $lista_resultados[$j]['HEPC'] . '</td>';
	}
	if (isset($analisis_disponibles['COVID'])) {
		$tbl .= '<td>' . $lista_resultados[$j]['COVID'] . '</td>';
	}
	$tbl .= '</tr>';
}

$tbl .= '</tbody></table>';


$pdf->SetFont('times', '', 8);
$pdf->writeHTML($tbl, true, false, false, false, '');

ob_end_clean();
$pdf->Output('resumen2.pdf', 'I');
