<?php
define('PERMITIDO', true);
require_once('../inc/init.php');
require_once('../assets/tcpdf/tcpdf.php');

class DetalleCaja extends TCPDF {
	public function Header() {
		$this->setImageScale(13);
		$this->setJPEGQuality(100);
		$this->Image('../imagenes/new_logo.jpg', '5', '5');
		# $this->Image('../assets/img/logo_informes.png', '10', '10'); TO DO: LOGO CON ESLOGAN
		$this->SetFont('times', '', 13);
		$this->writeHTMLCell(null, null, 10, 10, "<b>Detalle de caja</b>", 0, 0, false, true, 'C', true);
	}
	
	public function Footer() {
		$this->SetFont('times', '', 10);
		$paginas = '<b>Página ' . $this->getAliasNumPage() . ' de ' . $this->getAliasNbPages(). '</b>';
    $this->writeHTMLCell(null, null, 10, 285, $paginas, 0, 0, false, true, 'C', true);
	}
}

$pdf = new DetalleCaja('P', 'mm', 'letter', true, 'UTF-8', false);
$pdf->SetMargins(10, 20, 10);
# $pdf->SetHeaderMargin(20);
$pdf->SetFooterMargin(15);
$pdf->SetAutoPageBreak(true, 15);
$pdf->setFontSubsetting(true);
$pdf->AddPage();

$qDatosCajero = $mysqli->prepare("SELECT CONCAT_WS(' ', NOMBRES, APELLIDO_PATERNO, APELLIDO_MATERNO)
FROM usuarios
WHERE ID_USUARIO = ?");
$qDatosCajero->bind_param('i', $_GET['id_c']);
$qDatosCajero->execute();
$qDatosCajero->bind_result($nombreCajero);
$qDatosCajero->store_result();
$qDatosCajero->fetch();
$qDatosCajero->close();

$qAtencionesMetodoPagoCajero = $mysqli->prepare("SELECT a.ID_ATENCION, p.MONTO_PAGADO, p.NRO_DOCTO, p.FLAG_BONO_ANULADO,
cg.DESCRIPCION_CG, cg2.DESCRIPCION_CG
FROM atenciones a
LEFT JOIN pagos p ON p.ID_ATENCION = a.ID_ATENCION
LEFT JOIN codigos_generales cg ON cg.CODIGO = p.FORMA_PAGO AND cg.COD_TABLA = 'SIS_FORPAG'
LEFT JOIN codigos_generales cg2 ON cg2.CODIGO = p.FORMA_PAGO_IMED AND cg2.COD_TABLA = 'SIS_MET_PAGO_IMED'
WHERE p.FECHA_PAGO = ? AND p.ID_CAJERO = ? AND p.ID_CC = ?
ORDER BY cg.DESCRIPCION_CG ASC, a.ID_ATENCION ASC");
$qAtencionesMetodoPagoCajero->bind_param('sii', $_GET['fecha'], $_GET['id_c'], $_GET['id_cc']);
$qAtencionesMetodoPagoCajero->execute();
$qAtencionesMetodoPagoCajero->bind_result($p_idAtencion, $p_montoPagado, $p_nroDocumento, $p_flagBonoAnulado, 
$p_formaPago, $p_formaPagoImed);
$qAtencionesMetodoPagoCajero->store_result();
$data = "";
while ($qAtencionesMetodoPagoCajero->fetch()) {
  $p_formaPagoImed = $p_formaPagoImed ? $p_formaPagoImed : "-";
  $p_montoPagado = number_format($p_montoPagado, 0, ',', '.');
  $data .= "
      <tr>
        <td style=\"width: 35%\">{$p_formaPago}</td>
        <td style=\"width: 15%\">{$p_idAtencion}</td>
        <td style=\"width: 15%\">$ {$p_montoPagado}</td>
        <td style=\"width: 15%\">{$p_nroDocumento}</td>
        <td style=\"width: 20%\">{$p_formaPagoImed}</td>
      </tr>";
}
$qAtencionesMetodoPagoCajero->close();

########################################################################################################
########################################################################################################

$pdf->SetFont('times', '', 10);
$datosCaja = "
	<table border=\"0\" cellpadding=\"40\">
		<tbody>
			<tr>
				<td style=\"width: 10%\">CAJERO:</td>
				<td style=\"width: 90%\">$nombreCajero</td>
			</tr>
      <tr>
      <td style=\"width: 10%\">FECHA:</td>
      <td style=\"width: 90%\">{$_GET['fecha']}</td>
			</tr>
		</tbody>
	</table>";
$pdf->writeHTML($datosCaja, true, false, false, false, '');

if ($data == "") $pdf->writeHTML("Error, No hay resultados", true, false, false, false, '');
else {
	$tbl =
		"<table border=\"1\" cellpadding=\"40\">
			<thead>
				<tr style=\"background-color: #f8f8f8\">
          <th style=\"width: 35%\">Forma de pago</th>
          <th style=\"width: 15%\">N° atención</th>
          <th style=\"width: 15%\">Monto pagado</th>
          <th style=\"width: 15%\">N° documento</th>
          <th style=\"width: 20%\">Método pago imed</th>
				</tr>
			</thead>
			<tbody>
        $data
			</tbody>
		</table>";

	$pdf->SetFont('times', '', 9);
	$pdf->writeHTML($tbl, false, false, true, false, 'L');
}

ob_end_clean();
$pdf->Output("Detalle caja $nombreCajero $fechaNombreArchivo.pdf", 'I');
?>
