<?php
define('PERMITIDO', true);
require_once("../inc/init.php");
require_once('../lib/valido.php');
require_once('../lib/util.php');
require_once("../lib/func.global.php");
require_once('../lib/connection.php');
require_once("../lib/config.php");
require_once("../assets/php/PHPExcel.php");
date_default_timezone_set("America/Santiago");

error_reporting(E_ALL);
ini_set('display_errors', TRUE);
ini_set('display_startup_errors', TRUE);

if (PHP_SAPI == 'cli') die('This file should only be run from a Web Browser');
$objPHPExcel = new PHPExcel(); // Create new PHPExcel object
$objPHPExcel->getProperties()->setCreator('RIPIT')->setTitle('Detalle de caja'); // Set document properties

# $f_de = (isset($_GET['f_de']) && $_GET['f_de'] != "") ? $_GET['f_de'] : date('Y-m-d', strtotime('-1 week'));

$qDatosCajero = $mysqli->prepare("SELECT CONCAT_WS(' ', NOMBRES, APELLIDO_PATERNO, APELLIDO_MATERNO)
FROM usuarios
WHERE ID_USUARIO = ?");
$qDatosCajero->bind_param('i', $_GET['id_c']);
$qDatosCajero->execute();
$qDatosCajero->bind_result($nombreCajero);
$qDatosCajero->store_result();
$qDatosCajero->fetch();
$qDatosCajero->close();

$qAtencionesMetodoPagoCajero = $mysqli->prepare("SELECT a.ID_ATENCION, p.MONTO_PAGADO, p.NRO_DOCTO, p.FLAG_BONO_ANULADO,
cg.DESCRIPCION_CG, cg2.DESCRIPCION_CG
FROM atenciones a
LEFT JOIN pagos p ON p.ID_ATENCION = a.ID_ATENCION
LEFT JOIN codigos_generales cg ON cg.CODIGO = p.FORMA_PAGO AND cg.COD_TABLA = 'SIS_FORPAG'
LEFT JOIN codigos_generales cg2 ON cg2.CODIGO = p.FORMA_PAGO_IMED AND cg2.COD_TABLA = 'SIS_MET_PAGO_IMED'
WHERE p.FECHA_PAGO = ? AND p.ID_CAJERO = ? AND p.ID_CC = ?
ORDER BY cg.DESCRIPCION_CG ASC, a.ID_ATENCION ASC");
$qAtencionesMetodoPagoCajero->bind_param('sii', $_GET['fecha'], $_GET['id_c'], $_GET['id_cc']);
$qAtencionesMetodoPagoCajero->execute();
$qAtencionesMetodoPagoCajero->bind_result($p_idAtencion, $p_montoPagado, $p_nroDocumento, $p_flagBonoAnulado, 
$p_formaPago, $p_formaPagoImed);
$qAtencionesMetodoPagoCajero->store_result();
$numRows = $qAtencionesMetodoPagoCajero->num_rows;

//////////////////////// PARA QUE SE ACOMODE EL WIDTH DE LAS COLUMNAS //////////////////////////////
$objPHPExcel->getActiveSheet()->getColumnDimension('A')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('B')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('C')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('D')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('E')->setAutoSize(true);
// $objPHPExcel->getActiveSheet()->getColumnDimension('F')->setAutoSize(true);
// $objPHPExcel->getActiveSheet()->getColumnDimension('G')->setAutoSize(true);
// $objPHPExcel->getActiveSheet()->getColumnDimension('H')->setAutoSize(true);

//////////////////////// ESTILO PARA LA CABECERA //////////////////////////////
$styleArray = array(
  'font'  => array(
    'bold'  => true,
    'color' => array('rgb' => 'FFFFFF'),
    'size'  => 11
    //'name'  => 'Verdana'
  ),
  'fill' => array(
    'type' => PHPExcel_Style_Fill::FILL_SOLID,
    'color' => array('rgb' => '4F81BD')
  ),
  'alignment' => array(
    'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
    'vertical' => PHPExcel_Style_Alignment::VERTICAL_CENTER,
  ),
  'borders' => array(
    'allborders' => array(
      'style' => PHPExcel_Style_Border::BORDER_THIN
    )
  )
);

// $objPHPExcel->getActiveSheet()->getStyle('A1:H1')->applyFromArray($styleArray);

$aux = $numRows + 1;
$objPHPExcel->getActiveSheet()
  ->getStyle('A2:'.'H'.$aux)
  ->getNumberFormat()
  ->setFormatCode( PHPExcel_Style_NumberFormat::FORMAT_TEXT );

////////////////////////     ESCRITURA EN CELDAS      //////////////////////////////
$objPHPExcel->setActiveSheetIndex(0)
  ->setCellValue('A1', 'Forma de pago')
  ->setCellValue('B1', 'N° atención')
  ->setCellValue('C1', 'Monto pagado')
  ->setCellValue('D1', 'N° documento')
  ->setCellValue('E1', 'Método pago imed');
  // ->setCellValue('F1', 'Edad Paciente')
  // ->setCellValue('G1', 'Previsión')
  // ->setCellValue('H1', 'Resultado PCR');

// PARA ALINEAR CON LOS SALTOS DE LINEA
$objPHPExcel->getActiveSheet()->getStyle('A1')->getAlignment()->setWrapText(true);
$objPHPExcel->getActiveSheet()->getStyle('B1')->getAlignment()->setWrapText(true);
$objPHPExcel->getActiveSheet()->getStyle('C1')->getAlignment()->setWrapText(true);
$objPHPExcel->getActiveSheet()->getStyle('D1')->getAlignment()->setWrapText(true);
$objPHPExcel->getActiveSheet()->getStyle('E1')->getAlignment()->setWrapText(true);
// $objPHPExcel->getActiveSheet()->getStyle('F1')->getAlignment()->setWrapText(true);
// $objPHPExcel->getActiveSheet()->getStyle('G1')->getAlignment()->setWrapText(true);
// $objPHPExcel->getActiveSheet()->getStyle('H1')->getAlignment()->setWrapText(true);

$f=2;
while ($qAtencionesMetodoPagoCajero->fetch()) {
  $objPHPExcel->setActiveSheetIndex(0)
  ->setCellValue('A' . $f, $p_formaPago)
  ->setCellValue('B' . $f, $p_idAtencion)
  ->setCellValue('C' . $f, $p_montoPagado)
  ->setCellValue('D' . $f, $p_nroDocumento)
  ->setCellValue('E' . $f, $p_formaPagoImed ? $p_formaPagoImed : "-");
	$f++;
}
$qAtencionesMetodoPagoCajero->close();

# $objPHPExcel->setActiveSheetIndex(0)->setCellValue('A1', number_format($p_montoPagado, '0', ',', '.'));

$objPHPExcel->getActiveSheet()->setTitle("Detalle Caja"); // Rename worksheet
$objPHPExcel->setActiveSheetIndex(0); // Set active sheet index to the first sheet, so Excel opens this as the first sheet


// Redirect output to a client’s web browser (Excel5)
header('Content-Type: application/vnd.ms-excel');

// header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet'); # Para xlsx, no funciona en servidor
$fechaNombreArchivo = date("d-m-Y", strtotime($_GET['fecha']));
header("Content-Disposition: attachment;filename=Detalle caja $nombreCajero $fechaNombreArchivo.xls");
header('Cache-Control: max-age=0');

// // If you're serving to IE 9, then the following may be needed
header('Cache-Control: max-age=1');

// If you're serving to IE over SSL, then the following may be needed
header ('Expires: Mon, 26 Jul 1997 05:00:00 GMT'); // Date in the past
header ('Last-Modified: '.gmdate('D, d M Y H:i:s').' GMT'); // always modified
header ('Cache-Control: cache, must-revalidate'); // HTTP/1.1
header ('Pragma: public'); // HTTP/1.0

$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
$objWriter->setPreCalculateFormulas(false);
$objWriter->save('php://output');
exit();
