<?php
#$pagina = 8;
define('PERMITIDO', true);
require_once("../inc/init.php");
require_once("../inc/config.ui.php");

$cierresCaja = $mysqli->prepare("SELECT cg.DESCRIPCION_CG
FROM codigos_generales cg WHERE cg.CODIGO = ? AND COD_TABLA = 'SIS_FORPAG'");
$cierresCaja->bind_param('i', $_GET['fp']);
$cierresCaja->execute();
$cierresCaja->bind_result($formaPago);
$cierresCaja->store_result();
$cierresCaja->fetch();
$cierresCaja->close();

$qAtencionesMetodoPagoCajero = $mysqli->prepare("SELECT a.ID_ATENCION, p.MONTO_PAGADO, p.NRO_DOCTO, p.FLAG_BONO_ANULADO, cg.DESCRIPCION_CG
FROM atenciones a
LEFT JOIN pagos p ON p.ID_ATENCION = a.ID_ATENCION
LEFT JOIN codigos_generales cg ON cg.CODIGO = p.FORMA_PAGO_IMED AND COD_TABLA = 'SIS_MET_PAGO_IMED'
WHERE p.FECHA_PAGO = ? AND p.ID_CAJERO = ? AND p.ID_CC = ? AND FORMA_PAGO = ?
ORDER BY a.ID_ATENCION ASC");
$qAtencionesMetodoPagoCajero->bind_param('siii', $_GET['fecha'], $_GET['id_c'], $_GET['id_cc'], $_GET['fp']);
$qAtencionesMetodoPagoCajero->execute();
$qAtencionesMetodoPagoCajero->bind_result($p_idAtencion, $p_montoPagado, $p_nroDocumento, $p_flagBonoAnulado, $p_formaPagoImed);
$qAtencionesMetodoPagoCajero->store_result();
$numRows = $qAtencionesMetodoPagoCajero->num_rows;

ob_start();
?>

<div class="modal-header">
  <button type="button" class="close" data-dismiss="modal" aria-hidden="true">
    &times;
  </button>
  <h4 class="modal-title" id="myModalLabel">Detalle de pagos de atenciones</h4>
</div>

<div class="modal-body">
  <h3>Forma de pago: <?= $formaPago ?></h3>
  <table class="table table-bordered">
    <thead>
      <tr>
        <th>N° Atención</th>
        <th>Monto Pagado</th>
        <th>N° Documento</th>
        <th>Método Pago I-MED</th>
      </tr>
    </thead>
    <tbody>
      <?php if ($numRows == 0) echo '<tr><td colspan="15" align="center">No Existen Ingresos en la fecha seleccionada</td></tr>'; ?>
      <?php while ($qAtencionesMetodoPagoCajero->fetch()) {
      ?>
        <tr>
          <td><?= $p_idAtencion ?></td>
          <td>$ <?= number_format($p_montoPagado, '0', ',', '.'); ?></td>
          <td> <?= $p_flagBonoAnulado == "S" ? "$p_nroDocumento <b class='pull-right' style='color:red;'>Anulado</b>" : $p_nroDocumento ?> </td>
          <td><?= $p_formaPagoImed ? $p_formaPagoImed : "-" ?></td>
        </tr>
      <?php  }
      $qAtencionesMetodoPagoCajero->close(); ?>
    </tbody>
  </table>
</div>

<div class="modal-footer">
  <button type="button" class="btn btn-default" data-dismiss="modal">
    Cerrar
  </button>
</div>


<script>
  $(document).ready(function() {

  });
</script>