<?php
$pagina = 14;
define('PERMITIDO', true);
require_once("../inc/init.php");


//recibo id local

$idlocal=$_GET['idlocal'];
$fechaBusqueda=$_GET['fecha'];
$fPago=$_GET['idfp'];
$electronico=$_GET['e'];
$usuario_id=$_GET['idu'];//sacar despues de pruebas
$idcc=$_GET['idcc'];

//tipo de pago seleccionado: bono=1, efectivo=2, cheque=4, td=5, tc=6
$qformaPago=$mysqli->prepare("SELECT DESCRIPCION_CG FROM codigos_generales WHERE COD_TABLA = 'SIS_FORPAG' AND CODIGO=?");
$qformaPago->bind_param('i', $fPago);
$qformaPago->execute();
$qformaPago->bind_result($fp_descripcion);
$qformaPago->fetch();
$qformaPago->close();

//pagos realizados segun tipo de pago, que no estan cerrados y que pertenecen al local seleccionado
if($idcc!='-1'){
    $filtro="AND p.N_CIERRECAJA=".$idcc;
}else{
$filtro="AND p.FLAG_CIERRECAJA='N' AND p.ID_CAJERO=".$usuario_id." AND DATE_FORMAT(p.FECHA_PAGO,'%d-%m-%Y')='".$fechaBusqueda."'";
}
$qPagos = $mysqli->prepare("SELECT p.ID_ATENCION, DATE_FORMAT(p.FECHA_PAGO,'%d-%m-%Y') AS FECHA, p.MONTO_PAGADO,
p.NRO_DOCTO, p.CIERRE_INGRESO, us.USUARIO, em.NBR, CONCAT_WS(' ',pe.NOMBRES, pe.APELLIDO_PATERNO, pe.APELLIDO_MATERNO)
FROM pagos p
LEFT JOIN usuarios us ON p.ID_CAJERO=us.ID_USUARIO
LEFT JOIN empresas em ON p.ID_PREVISION=em.ID_EMPRESA
LEFT JOIN atenciones a ON a.ID_ATENCION=p.ID_ATENCION
LEFT JOIN personas pe ON pe.ID_PERSONA=a.ID_CLIENTE
WHERE p.FORMA_PAGO=? AND p.ID_CC=? AND FLAG_ELEC=? $filtro");
$qPagos->bind_param('iis',$fPago, $idlocal, $electronico);
$qPagos->execute();
$qPagos->bind_result($p_idAtencion, $p_fecha, $p_montoPagado, $p_nroDocto, $p_cierreIngreso, $p_usuario, $p_prevision, $p_paciente);
$qPagos->store_result();
$num_rows_pagos=$qPagos->num_rows;

$tipoPago='';
if($electronico=='S'){
    $tipoPago=" Electrónico";
}

?>
<div class="modal-header">
    <button type="button" class="close" data-dismiss="modal" aria-hidden="true">
        &times;
    </button>
    <h4 class="modal-title" id="myModalLabel">Detalle de Pagos con <?php echo $fp_descripcion.$tipoPago ?></h4>
</div>
<div class="modal-body">
    <table class="table table-responsive table-hover">
        <thead>
            <tr>
                <th>Atención</th>
                <th>Fecha</th>
                <th>Paciente</th>
                <th>Previsión</th>
                <th>Nro Documento</th>
                <th>Monto Pagado ($)</th>
            </tr>
        </thead>
        <tbody>
            <?php
                $suma=0;
                while($qPagos->fetch()){ ?>
                <tr>
                    <td><?php echo $p_idAtencion; ?></td>
                    <td><?php echo $p_fecha; ?></td>
                    <td><?php echo $p_paciente; ?></td>
                    <td><?php echo $p_prevision; ?></td>
                    <td><?php echo $p_nroDocto; ?></td>
                    <td nowrap align="right"><?php echo number_format($p_montoPagado,'0',',','.'); ?></td>
                </tr>
            <?php
                $suma+=$p_montoPagado;
                }$qPagos->close(); ?>
        </tbody>
        <tfoot>
            <?php if($num_rows_pagos>0){ ?>
            <tr>
                <td colspan="7"><div class="pull-right">Total: <?php echo number_format($suma,'0',',','.'); ?></div></td>
            </tr>
            <?php }else{?>
            <tr>
                <td colspan="7"><div class="text-center">No se registraron pagos</div></td>
            </tr>
            <?php } ?>
        </tfoot>
    </table>

</div>
