<?php
$pagina = 0;

define('PERMITIDO', true);
require_once("../inc/init.php");
require_once('../assets/tcpdf/tcpdf.php');

$titulo = 'Laboratorio Central<br>Arlegui 440 - Oficina 218<br>Viña del Mar<br>Fono: 32-2714189';
$firma = 'QF Andoni Etcheverry<br>Director Técnico';
$nombre_centro_contacto = '';

$fechaBusqueda=date('d-m-Y');
if(isset($_GET['fecha'])){$fechaBusqueda=$_GET['fecha'];}

class documento extends TCPDF {

	public function Header() {
		global $titulo;
		global $fechaBusqueda;
		$this->SetFont('times', '', 10);
		$this->writeHTMLCell('50', '', 230, 10, $titulo, 0, 1, 0, true, 'C', true);
		$this->writeHTMLCell('', '', '', '20', "Fecha: ".$fechaBusqueda, 0, 1, 0, true, 'C', true);
		$this->SetFont('times', '', 12);
		$this->writeHTMLCell('', '', '', '15', "Resumen Cierres de Caja", 0, 1, 0, true, 'C', true);
		$this->setImageScale(2);
		$this->setJPEGQuality(100);
		$this->Image(ASSETS_URL.'/img/logo.jpg', '10', '10');
	}
	public function Footer() {
		global $firma;
		$this->SetFont('times', '', 10);
		#$this->writeHTMLCell('50', '', 230, 180, $firma, 0, 1, 0, true, 'C', true);
		$paginas = "Página ".$this->getAliasNumPage().' de '.$this->getAliasNbPages();
		$this->writeHTMLCell('', '', '', '', $paginas, 0, 1, 0, true, 'C', true);
		#$this->setImageScale(2.5);
		#$this->setJPEGQuality(100);
		#$this->Image('firma.jpg', '235', '160');
	}
}

$pdf = new documento('L', 'mm', 'letter', true, 'UTF-8', false);

$pdf->SetMargins(10, 35, 10);
$pdf->SetHeaderMargin(10);
$pdf->SetFooterMargin(10);
$pdf->SetAutoPageBreak(true, 58);
$pdf->setFontSubsetting(true);
$pdf->SetFont('times', '', 8);




$cierresCaja = $mysqli->prepare("SELECT c.ID_CENTRO_CONTACTO, c.NOMBRE, cc.ID_CC, FECHA, HORA, SUM(iBONOS), SUM(iBONOSE), SUM( iBolTC), SUM( iBolTD), SUM(iBolEF), SUM( iBolCH),
	SUM(iBonTC), SUM( iBonTD), SUM( iBonEF), SUM( iBonCH), SUM( EGRESOS), SUM( INGRESOS_CAJA_CHICA), SUM( SALDO_EFECTIVO), SUM( SALDO_CAJA)
	FROM centros_contacto c
	LEFT JOIN cierres_caja cc on cc.ID_CENTRO_CONTACTO=c.ID_CENTRO_CONTACTO
	WHERE DATE_FORMAT(FECHA,'%d-%m-%Y')=?
	GROUP BY c.ID_CENTRO_CONTACTO
ORDER BY c.NOMBRE");
                echo $mysqli->error;
$cierresCaja->bind_param('s', $fechaBusqueda);
$cierresCaja->execute();
$cierresCaja->bind_result($cc_idCentroContacto, $cc_centroContacto, $cc_idCC, $cc_fecha, $cc_hora, $cc_iBonos, $cc_iBonosE, $cc_iBolTC, $cc_iBolTD, $cc_ibolEF, $cc_iBolCH,
                        $cc_iBonTC, $cc_iBonTD, $cc_iBonEF, $cc_iBonCH, $cc_egresos, $cc_ingresosCajaChica, $cc_saldoEfectivo, $cc_saldoCaja);
$cierresCaja->store_result();
$numRows=$cierresCaja->num_rows;

$tbl= '
	<table border="1" cellpadding="3">
		<thead>
			<tr>
				<th></th>
				<th></th>
				<th colspan="6" style="text-align:center">Bonos Electrónicos</th>
				<th colspan="5" style="text-align:center">Boletas Electrónicas</th>
				<th></th>
				<th></th>
				<th></th>
			</tr>
			<tr>
				<th>Caja</th>
				<th style="text-align:center">Bonos</th>
				<!-- Bonos Electronicos-->
				<th style="text-align:center">Monto</th>
				<th style="text-align:center">Copago</th>
				<th style="text-align:center">Efectivo</th>
				<th style="text-align:center">Cheque</th>
				<th style="text-align:center">Tc</th>
				<th style="text-align:center">Td</th>
				<!-- Boletas Elec-->
				<th style="text-align:center">Monto</th>
				<th style="text-align:center">Efectivo</th>
				<th style="text-align:center">Cheque</th>
				<th style="text-align:center">Tc</th>
				<th style="text-align:center">Td</th>
				<th style="text-align:center">Gastos</th>
				<th style="text-align:center">Fondo Caja</th>
				<th style="text-align:center">Depósito</th>

			</tr>
		</thead>
		<tbody>';
	if($numRows>0){

		$tt_iBonos=0;
		$tt_iBonosE=0;
		$tt_iBolTC=0;
		$tt_iBolTD=0;
		$tt_ibolEF=0;
		$tt_iBolCH=0;
		$tt_iBonTC=0;
		$tt_iBonTD=0;
		$tt_iBonEF=0;
		$tt_iBonCH=0;
		$tt_egresos=0;
		$tt_ingresosCajaChica=0;
		$tt_saldoEfectivo=0;
		$tt_saldoCaja=0;
		while($cierresCaja->fetch()){
			$tt_iBonos+=$cc_iBonos;
			$tt_iBonosE+=$cc_iBonosE;
			$tt_iBolTC+=$cc_iBolTC;
			$tt_iBolTD+=$cc_iBolTD;
			$tt_ibolEF+=$cc_ibolEF;
			$tt_iBolCH+=$cc_iBolCH;
			$tt_iBonTC+=$cc_iBonTC;
			$tt_iBonTD+=$cc_iBonTD;
			$tt_iBonEF+=$cc_iBonEF;
			$tt_iBonCH+=$cc_iBonCH;
			$tt_egresos+=$cc_egresos;
			$tt_ingresosCajaChica+=$cc_ingresosCajaChica;
			$tt_saldoEfectivo+=$cc_saldoEfectivo;
			$tt_saldoCaja+=$cc_saldoCaja;

				if($usuario_id==1 || ($usuario_id==$cc_idUsuario)){$disabled='';}else{$disabled='disabled';}

	$tbl.='		<tr>
					<td>'.$cc_centroContacto.'</td>';
				if($cc_idCC!=''){
	$tbl.='			<td style="text-align:right">'.number_format($cc_iBonos,'0',',','.').'</td>
					<td style="text-align:right">'.number_format($cc_iBonosE,'0',',','.').'</td>
					<td style="text-align:right">'.number_format($cc_iBonTC+$cc_iBonTD+$cc_iBonEF+$cc_iBonCH,'0',',','.').'</td>
					<td style="text-align:right">'.number_format($cc_iBonEF,'0',',','.').'</td>
					<td style="text-align:right">'.number_format($cc_iBonCH,'0',',','.').'</td>
					<td style="text-align:right">'.number_format($cc_iBonTC,'0',',','.').'</td>
					<td style="text-align:right">'.number_format($cc_iBonTD,'0',',','.').'</td>
					<td style="text-align:right">'.number_format($cc_iBolTC+$cc_iBolTD+$cc_ibolEF+$cc_iBolCH,'0',',','.').'</td>
					<td style="text-align:right">'.number_format($cc_ibolEF,'0',',','.').'</td>
					<td style="text-align:right">'.number_format($cc_iBolCH,'0',',','.').'</td>
					<td style="text-align:right">'.number_format($cc_iBolTC,'0',',','.').'</td>
					<td style="text-align:right">'.number_format($cc_iBolTD,'0',',','.').'</td>
					<td style="text-align:right">'.number_format($cc_egresos,'0',',','.').'</td>
					<td style="text-align:right">'.number_format($cc_ingresosCajaChica,'0',',','.').'</td>
					<td style="text-align:right">'.number_format($cc_saldoEfectivo,'0',',','.').'</td>';
			 	}else{
	$tbl.='			<td colspan="15" style="text-align:center"><span class="label label label-danger">Pendiente</span></td>';
				}
	$tbl.='		</tr>';


		}$cierresCaja->close();
		//fila totales
$tbl.='			<tr style="background-color: #f2f2f2;">
					<td>TOTALES</td>
					<td style="text-align:right">'.number_format($tt_iBonos,'0',',','.').'</td>
					<td style="text-align:right">'.number_format($tt_iBonosE,'0',',','.').'</td>
					<td style="text-align:right">'.number_format($tt_iBonTC+$tt_iBonTD+$tt_iBonEF+$tt_iBonCH,'0',',','.').'</td>
					<td style="text-align:right">'.number_format($tt_iBonEF,'0',',','.').'</td>
					<td style="text-align:right">'.number_format($tt_iBonCH,'0',',','.').'</td>
					<td style="text-align:right">'.number_format($tt_iBonTC,'0',',','.').'</td>
					<td style="text-align:right">'.number_format($tt_iBonTD,'0',',','.').'</td>
					<td style="text-align:right">'.number_format($tt_iBolTC+$tt_iBolTD+$tt_ibolEF+$tt_iBolCH,'0',',','.').'</td>
					<td style="text-align:right">'.number_format($tt_ibolEF,'0',',','.').'</td>
					<td style="text-align:right">'.number_format($tt_iBolCH,'0',',','.').'</td>
					<td style="text-align:right">'.number_format($tt_iBolTC,'0',',','.').'</td>
					<td style="text-align:right">'.number_format($tt_iBolTD,'0',',','.').'</td>
					<td style="text-align:right">'.number_format($tt_egresos,'0',',','.').'</td>
					<td style="text-align:right">'.number_format($tt_ingresosCajaChica,'0',',','.').'</td>
					<td style="text-align:right">'.number_format($tt_saldoEfectivo,'0',',','.').'</td>
				</tr>';

	}else{#else $numRows>0
$tbl.='			<tr><td colspan="16" style="text-align:center">No se encontraron registros</td></tr>';
	}



$tbl.='	</tbody>
	</table>';

$pdf->AddPage();


$pdf->writeHTML($tbl, true, false, false, false, '');

ob_end_clean();
$pdf->Output('documento_pdf_nuevo.pdf', 'I');
?>
