<?php
$pantalla_actual = 'LIS_CONV';
define('PERMITIDO', true);
require_once("../inc/init.php");
require_once("../inc/config.ui.php");
$page_title = $datos_pantallas[$pantalla_actual]['page_title'];
$page_css[] = "your_style.css";
include("../inc/header.php");
include("../inc/nav.php");

$filtro = ""; 
if(isset($_GET['desde']) && $_GET['desde']!="") $filtro .= " AND a.FECHA >= '{$_GET['desde']}'"; 
if(isset($_GET['hasta']) && $_GET['hasta']!="") $filtro .= " AND a.FECHA <= '{$_GET['hasta']}'"; 

$qConvenios=$mysqli->prepare("SELECT e.ID_EMPRESA, e.NOMBRE_E, e.NBR, SUM(a.MONTO_CONVENIO), COUNT(a.ID_ATENCION)
FROM empresas e
LEFT JOIN atenciones a ON a.ID_CONVENIO = e.ID_EMPRESA AND a.ID_COBRANZA_CONVENIO IS NULL AND a.FLAG_ELIMINADO = 0 AND a.FECHA >= '2021-04-07' 
# FECHA DE CORTE ES 07-04-2021, NO QUITAR CONDICION
WHERE e.FLAG_CONVENIO = 'S' $filtro
GROUP BY e.ID_EMPRESA
ORDER BY e.NOMBRE_E ASC");
$qConvenios->execute();
$qConvenios->bind_result($e_idEmpresa, $e_nombre, $e_nbr, $e_saldoTotalConvenio, $e_countAtenciones);
$qConvenios->execute();
$qConvenios->store_result();

ob_start();
?>

<!-- ==========================CONTENT STARTS HERE ========================== -->
<!-- MAIN PANEL -->
<!-- MAIN CONTENT -->

<table class="table table-responsive table-hover table-bordered datatable-convenios" >
  <thead>
    <tr>
      <th>Convenio</th>
      <th>Abreviación</th>
      <th>N° de Atenciones por Cobrar</th>
      <th>Monto Total a Cobrar</th>
      <th>Generar Cobranza</th>
      <th>Historial Cobranzas</th>
    </tr>
  </thead>
  <tbody>
  <?php while($qConvenios->fetch()) { ?>
    <tr>
      <td><?=$e_nombre?></td>
      <td><?=$e_nbr?></td>
      <td><?=$e_countAtenciones?></td>
      <td>$ <?=number_format($e_saldoTotalConvenio,0,',','.')?></td>
      <?php 
        if ($e_countAtenciones != 0) echo '<td><a class="btn btn-link" href="cobro_convenio.php?id_conv='.$e_idEmpresa.'"><i class="fa fa-money fa-lg"></i></a></td>';
        else                         echo '<td><a disabled class="btn btn-link" href="cobro_convenio.php?id_conv='.$e_idEmpresa.'"><i class="txt-color-lighten fa fa-money fa-lg"></i></a></td>';
      ?>
      <td><a class="btn btn-link" href="historial_cobros_convenio.php?id_conv=<?=$e_idEmpresa?>"><i class="fa fa-history fa-lg"></i></a></td>
    </tr>
  <?php } ?>
    </tbody>
</table>

<?php
$contenido = ob_get_contents();
ob_end_clean();

$ui = new SmartUI;
$options = array("editbutton" => false);
$widget = $ui->create_widget($options);

$widget->header = array(
    "title" => $datos_pantallas[$pantalla_actual]['body_title'],
    "icon" => 'fa fa-cog',
	  'toolbar' => array(
		array(
			"id" => "toolbar-id",
			"content" => '<a href="#"  data-toggle="modal" data-target="#myModalNew"></a>',
			"class" => 'smart-form'
		)
	)
);
$widget->body('content', $contenido);
?>

<div id="main" role="main">
	<?php
		include("../inc/ribbon.php");
	?>
	<!-- MAIN CONTENT -->
  <div id="content">	
    <?php
      $widget->print_html();
    ?>
  </div>
<!-- END MAIN PANEL -->
</div>
<!-- END MAIN PANEL -->
<!-- ==========================CONTENT ENDS HERE ========================== -->

<!-- PAGE FOOTER -->
<?php
	// include page footer
	include("../inc/footer.php");
?>
<!-- END PAGE FOOTER -->

<?php 
	include("../inc/scripts.php");
?>

<script>
  $(document).ready(function() {
    $('.datatable-convenios').DataTable({
      'lengthMenu': [[5, 10, 20], [5, 10, 20]],
      'language': {
        'sProcessing': 'Procesando...',
        'sZeroRecords': 'No se encontraron resultados',
        'sInfoPostFix': '',
        'sUrl': '',
        'oPaginate': {
          'sFirst': 'Primero',
          'sPrevious': 'Anterior',
          'sNext': 'Siguiente',
          'sLast': 'Último'
        },
        'sInfo': '_START_ a _END_ de _TOTAL_ Registros',
        'sInfoEmpty': '0 Registros',
        'sInfoFiltered': '(de _MAX_ Registros en total)',
        'sLengthMenu': 'Mostrar _MENU_ Registros',
        'sSearch': 'Buscar: '
      },
      'pageLength' : 50,
      'order' : [ 0, 'asc' ],
      'columns': [
        null,
        null,
        null,
        null,
        {'orderable': false},
        {'orderable': false}
      ],
      'destroy': true
    });
  });
</script>


<!-- PAGE RELATED PLUGIN(S) 
<script src="<?php echo ASSETS_URL; ?>/js/plugin/YOURJS.js"></script>-->

<?php 
	//include footer
	include("../inc/google-analytics.php");
?>