<?php
$pagina = 1;

define('PERMITIDO', true);
require_once("../inc/init.php");
require_once('../assets/tcpdf/tcpdf.php');
$tiempo = time(); 
$hoy=date('d-m-Y', $tiempo);

class ResultadosDialisis extends TCPDF {
  public function Header() {
    $this->setImageScale(2.5);
    $this->setJPEGQuality(100);
    $this->Image('../assets/img/logo_empresa2.jpg', '10', '10');
    $this->setImageScale(0.7);
  }
	public function Footer() {
    $this->SetFont('helvetica', '',9);
    $paginas= "Página ".$this->getAliasNumPage().' de '.$this->getAliasNbPages();
    $this->writeHTMLCell('', '', '', '', $paginas, 0, 1, 0, true, 'C', true);
  }
}

$pdf = new ResultadosDialisis('P', 'mm', 'letter', true, 'UTF-8', false);

$pdf->SetMargins(10, 35, 10);
$pdf->SetHeaderMargin(10);
$pdf->SetFooterMargin(10);
$pdf->SetAutoPageBreak(true, 58);
$pdf->setFontSubsetting(true);
$pdf->SetFont('times', '', 9);

$qConvenios=$mysqli->prepare("SELECT e.NBR FROM empresas e WHERE e.ID_EMPRESA = ? LIMIT 1");
$qConvenios->bind_param('i', $_GET['id_conv']);
$qConvenios->execute();
$qConvenios->bind_result($e_NBRConvenio);
$qConvenios->store_result();
$qConvenios->fetch();
$qConvenios->close();
$e_NBRConvenio = str_replace(' ', '_', $e_NBRConvenio);

$filtro = ""; 
if(isset($_GET['desde']) && $_GET['desde']!="") $filtro .= " AND a.FECHA >= '{$_GET['desde']}'"; 
if(isset($_GET['hasta']) && $_GET['hasta']!="") $filtro .= " AND a.FECHA <= '{$_GET['hasta']}'"; 

$qConvenios=$mysqli->prepare("SELECT a.ID_ATENCION, DATE_FORMAT(a.FECHA,'%d/%m/%Y'), a.MONTO_ATENCION, a.MONTO_PAGADO, a.MONTO_DESCUENTO, a.MONTO_CONVENIO, a.PCTJE_DESCUENTO, 
CONCAT_WS(' ', NOMBRES, APELLIDO_PATERNO, APELLIDO_MATERNO), a.ID_COBRANZA_CONVENIO
FROM atenciones a
LEFT JOIN personas p ON p.ID_PERSONA = a.ID_CLIENTE
LEFT JOIN empresas e ON e.ID_EMPRESA = a.ID_CONVENIO
WHERE e.ID_EMPRESA = ? AND a.FLAG_ELIMINADO = 0 AND a.ID_COBRANZA_CONVENIO IS NULL $filtro
AND a.FECHA >= '2021-04-07' # FECHA DE CORTE ES 07-04-2021, NO QUITAR CONDICION
ORDER BY a.ID_ATENCION DESC");
$qConvenios->bind_param('i', $_GET['id_conv']);
$qConvenios->execute();
$qConvenios->bind_result($a_idAtencion, $a_fechaAtencion, $a_montoAtencion, $a_montoPagado, $a_montoDescuento, $a_montoACobrarConvenio, $a_pctjeDescuento, 
$a_nombrePaciente, $a_idCobroConvenio);
$qConvenios->execute();
$qConvenios->store_result();

$pdf->AddPage();
$tbl =
'<table border="1" cellpadding="1" style="text-align:center">
  <thead>
    <tr nobr="true" style="background-color: #f2f2f2;">
      <th style="width:12%">Atención</th>
      <th style="width:13%">Fecha</th>
      <th style="width:45%">Nombre Paciente</th>
      <th style="width:15%">Monto Atención</th>
      <th style="width:15%">Monto a Cobrar a Convenio</th>
    </tr>
  </thead>
  <tbody>
';
  
while($qConvenios->fetch()) {
  $tbl .= 
  '<tr nobr="true">
    <td style="width:12%">'.$a_idAtencion.'</td>
    <td style="width:13%">'.$a_fechaAtencion.'</td>
    <td style="width:45%">'.$a_nombrePaciente.'</td>
    <td style="width:15%">$ '.number_format($a_montoAtencion,0,',','.').'</td>
    <td style="width:15%">$ '.number_format($a_montoACobrarConvenio,0,',','.').'</td>
  </tr>';
}
  
$tbl .= '</tbody></table>';
$pdf->SetFont('times', '', 8);
$pdf->writeHTML($tbl, true, false, false, false, '');

ob_end_clean();
$pdf->Output('cobranza_'.$e_NBRConvenio.'_'.$hoy.'.pdf', 'I');
?>
