<?php
define('PERMITIDO', true);

$pagina = 34;

require_once '../lib/valido.php';
require_once '../lib/util.php';
require_once '../lib/func.global.php';
require_once '../lib/connection.php';
require_once '../lib/config.php';
require_once '../assets/php/PHPExcel.php';
$tiempo = time(); 
$hoy=date('d-m-Y', $tiempo);

error_reporting(E_ALL);
ini_set('display_errors', true);
ini_set('display_startup_errors', true);

if (PHP_SAPI == 'cli')
	die('This file should only be run from a Web Browser');

$objPHPExcel = new PHPExcel();
$objPHPExcel->getProperties()->setCreator('RIPIT')->setTitle('Reporte');

$qConvenios=$mysqli->prepare("SELECT e.NBR FROM empresas e WHERE e.ID_EMPRESA = ? LIMIT 1");
$qConvenios->bind_param('i', $_GET['id_conv']);
$qConvenios->execute();
$qConvenios->bind_result($e_NBRConvenio);
$qConvenios->store_result();
$qConvenios->fetch();
$qConvenios->close();
$e_NBRConvenio = str_replace(' ', '_', $e_NBRConvenio);

$filtro = ""; 
if(isset($_GET['desde']) && $_GET['desde']!="") $filtro .= " AND a.FECHA >= '{$_GET['desde']}'"; 
if(isset($_GET['hasta']) && $_GET['hasta']!="") $filtro .= " AND a.FECHA <= '{$_GET['hasta']}'"; 

$qConvenios=$mysqli->prepare("SELECT a.ID_ATENCION, DATE_FORMAT(a.FECHA,'%d/%m/%Y'), a.MONTO_ATENCION, a.MONTO_PAGADO, a.MONTO_DESCUENTO, a.MONTO_CONVENIO, a.PCTJE_DESCUENTO, 
CONCAT_WS(' ', NOMBRES, APELLIDO_PATERNO, APELLIDO_MATERNO), a.ID_COBRANZA_CONVENIO
FROM atenciones a
LEFT JOIN personas p ON p.ID_PERSONA = a.ID_CLIENTE
LEFT JOIN empresas e ON e.ID_EMPRESA = a.ID_CONVENIO
WHERE e.ID_EMPRESA = ? AND a.FLAG_ELIMINADO = 0 AND a.ID_COBRANZA_CONVENIO IS NULL $filtro
AND a.FECHA >= '2021-04-07' # FECHA DE CORTE ES 07-04-2021, NO QUITAR CONDICION
ORDER BY a.ID_ATENCION DESC");
$qConvenios->bind_param('i', $_GET['id_conv']);
$qConvenios->execute();
$qConvenios->bind_result($a_idAtencion, $a_fechaAtencion, $a_montoAtencion, $a_montoPagado, $a_montoDescuento, $a_montoACobrarConvenio, $a_pctjeDescuento, 
$a_nombrePaciente, $a_idCobroConvenio);
$qConvenios->execute();
$qConvenios->store_result();

$objPHPExcel->getActiveSheet()->getColumnDimension('A')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('B')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('C')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('D')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('E')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('F')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('G')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('H')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('I')->setAutoSize(true);

$objPHPExcel->setActiveSheetIndex(0)
	->setCellValue('A1', 'NRO. ATENCIÓN')
	->setCellValue('B1', 'FECHA')
	->setCellValue('C1', 'PACIENTE')
	->setCellValue('D1', 'MONTO ATENCIÓN')
	->setCellValue('E1', 'DESCUENTO ($)')
	->setCellValue('F1', 'DESCUENTO (%)')
	->setCellValue('G1', 'MONTO ATENCIÓN CON DESCUENTOS')
	->setCellValue('H1', 'MONTO PAGADO')
  ->setCellValue('I1', 'MONTO A COBRAR A CONVENIO');

$f = 2;
while ($qConvenios->fetch()) {

	$montoConDescuentos = $a_montoAtencion - $a_montoDescuento - ($a_montoAtencion * $a_pctjeDescuento / 100);
	$aPagar = $montoConDescuentos;
	if ($a_porPagarConvenio) {
	$aPagar = $a_porPagarConvenio;
	}
	if ($a_montoACobrarConvenio) {
	$aPagar = $a_montoACobrarConvenio;
	}

		  
  $montoConDescuentos = $a_montoAtencion - $a_montoDescuento - ($a_montoAtencion*$a_pctjeDescuento/100);

	$objPHPExcel->setActiveSheetIndex(0)->setCellValue('A' . $f, $a_idAtencion);
	$objPHPExcel->setActiveSheetIndex(0)->setCellValue('B' . $f, $a_fechaAtencion);
  $objPHPExcel->setActiveSheetIndex(0)->setCellValue('C' . $f, $a_nombrePaciente);
	$objPHPExcel->setActiveSheetIndex(0)->setCellValue('D' . $f, $a_montoAtencion);
	$objPHPExcel->setActiveSheetIndex(0)->setCellValue('E' . $f, $a_montoDescuento);
	$objPHPExcel->setActiveSheetIndex(0)->setCellValue('F' . $f, $a_pctjeDescuento);
	$objPHPExcel->setActiveSheetIndex(0)->setCellValue('G' . $f, $montoConDescuentos);
	$objPHPExcel->setActiveSheetIndex(0)->setCellValue('H' . $f, $a_montoPagado);
	$objPHPExcel->setActiveSheetIndex(0)->setCellValue('I' . $f, $a_montoACobrarConvenio);
	$f++;
}
$qConvenios->close();

$objPHPExcel->getActiveSheet()->setTitle('Reporte');
$objPHPExcel->setActiveSheetIndex(0);

header('Content-Type: application/vnd.ms-excel');
header('Content-Disposition: attachment;filename="cobranza_'.$e_NBRConvenio.'_'.$hoy.'.xls"');
header('Cache-Control: max-age=0');

$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
$objWriter->save('php://output');

die();
