<?php
$pantalla_actual = 'DET_HIS_COBR_CONV';
define('PERMITIDO', true);
require_once("../inc/init.php");
require_once("../inc/config.ui.php");
$page_title = $datos_pantallas[$pantalla_actual]['page_title'];
$page_css[] = "your_style.css";
include("../inc/header.php");
include("../inc/nav.php");

$qConvenios = $mysqli->prepare("SELECT DATE_FORMAT(cc.FECHA_COBRANZA,'%d/%m/%Y'), DATE_FORMAT(cc.FECHA_DESDE,'%d/%m/%Y'), DATE_FORMAT(cc.FECHA_HASTA,'%d/%m/%Y'),
e.NOMBRE_E, e.FLAG_IVA, CONCAT_WS('-',e.NRO_RUT_EMPRESA,e.DV_RUT_EMPRESA), cc.FOLIO, cc.TIPO_FACTURA
FROM cobranzas_convenios cc
LEFT JOIN empresas e ON e.ID_EMPRESA = cc.ID_CONVENIO
WHERE ID_COBRANZA_CONVENIO = ? LIMIT 1");
$qConvenios->bind_param('i', $_GET['id_cc']);
$qConvenios->execute();
$qConvenios->bind_result($fechaCobranza, $fechaDesde, $fechaHasta, $nombreConvenio, $flag_iva, $rut_empresa, $folio_factura, $tipo_factura);
$qConvenios->store_result();
$qConvenios->fetch();
$qConvenios->close();

$filtro = "";
if (isset($_GET['desde']) && $_GET['desde'] != "") $filtro .= " AND a.FECHA >= '{$_GET['desde']}'";
if (isset($_GET['hasta']) && $_GET['hasta'] != "") $filtro .= " AND a.FECHA <= '{$_GET['hasta']}'";

$query = "SELECT a.ID_ATENCION, DATE_FORMAT(a.FECHA,'%d/%m/%Y'), a.MONTO_ATENCION, a.MONTO_PAGADO, a.MONTO_DESCUENTO, a.MONTO_CONVENIO, a.PCTJE_DESCUENTO, 
CONCAT_WS(' ', NOMBRES, APELLIDO_PATERNO, APELLIDO_MATERNO), a.ID_COBRANZA_CONVENIO
FROM atenciones a
LEFT JOIN personas p ON p.ID_PERSONA = a.ID_CLIENTE
LEFT JOIN empresas e ON e.ID_EMPRESA = a.ID_CONVENIO
WHERE a.ID_COBRANZA_CONVENIO = ? AND a.FLAG_ELIMINADO = 0 $filtro
ORDER BY a.ID_ATENCION ASC";
$qAtencionesCobranza = $mysqli->prepare($query);
$qAtencionesCobranza->bind_param('i', $_GET['id_cc']);
$qAtencionesCobranza->execute();
$qAtencionesCobranza->bind_result(
  $a_idAtencion,
  $a_fechaAtencion,
  $a_montoAtencion,
  $a_montoPagado,
  $a_montoDescuento,
  $a_montoACobrarConvenio,
  $a_pctjeDescuento,
  $a_nombrePaciente,
  $a_idCobroConvenio
);
$qAtencionesCobranza->execute();
$qAtencionesCobranza->store_result();
$numRowsAtenciones = $qAtencionesCobranza->num_rows;

$url_asociar_cc = urlencode("https://" . $_SERVER['SERVER_NAME'] . "/SILCLCE/api_fact/asociar_dte.php?idcc=" . $_GET['id_cc'] . "&uid=$usuario_id");

ob_start();
?>
<form action="" method="get" class="smart-form">
  <input type="hidden" name="id_cc" value="<?= $_GET['id_cc']; ?>" />
  <div class="row">
    <section class="col col-2">
      <label class="label">
        Desde <?php if ($_GET['desde'] != '') echo '<i class="fa fa-filter txt-color-red"></i>' ?>
      </label>
      <label class="input">
        <input type="date" class="form-control" name="desde" value="<?= isset($_GET["desde"]) ? $_GET["desde"] : "2021-04-07" ?>" min="2021-04-07" />
      </label>
    </section>
    <section class="col col-2">
      <label class="label">
        Hasta <?php if ($_GET['hasta'] != '') echo '<i class="fa fa-filter txt-color-red"></i>' ?>
      </label>
      <label class="input">
        <input type="date" class="form-control" name="hasta" value="<?= isset($_GET["hasta"]) ? $_GET["hasta"] : "" ?>" />
      </label>
    </section>
    <section class="col col-1">
      <lanel class="label"> &nbsp; </lanel>
      <button class="btn btn-sm btn-default btn-block" type="submit"> <i class="fa fa-search fa-lg"></i> Filtrar</button>
    </section>
    <section class="col col-1">
      <lanel class="label"> &nbsp; </lanel>
      <a class="btn btn-sm btn-default btn-block" href="detalle_historial.php?id_cc=<?= $_GET['id_cc'] ?>"> <i class="fa fa-list fa-lg"></i> Ver todo</a>
    </section>
    <section class="col col-1">
      <lanel class="label"> &nbsp; </lanel>
      <a class="btn btn-sm btn-default" target="_blank" href="pdf_cobro_convenio2.php?id_cc=<?= $_GET['id_cc'] ?>"> <i class="fa fa-file-pdf-o fa-lg"> </i> Exportar PDF</a>
    </section>
    <section class="col col-1">
      <lanel class="label"> &nbsp; </lanel>
      <a class="btn btn-sm btn-default" target="_blank" href="xls_cobro_convenio2.php?id_cc=<?= $_GET['id_cc'] ?>"> <i class="fa fa-file-excel-o fa-lg"> </i> Exportar Excel</a>
    </section>
  </div>
</form>

<?php $valor = $folio_factura ? $folio_factura : "Sin asignar"; ?>

<div class="font-md">
  <div style="display: flex; align-items: stretch;">
    Fecha cobranza: <?= $fechaCobranza ?>
  </div>
  Rango de fechas de la cobranza: <?= $fechaDesde ?> - <?= $fechaHasta ?>
  <div style="display: flex; align-items: stretch;">
    IVA incluido: <?= $flag_iva == "S" ? "Si" : "No" ?>
  </div>
  Tipo factura: <?= $tipo_factura == 33 ? "Factura electrónica (no exenta)" : "Factura electrónica exenta" ?>
  <div style="display: flex; align-items: stretch;">
    Folio factura: &nbsp; <a href="#" class="folio_input" data-pk="<?= $_GET['id_cc'] ?>" data-value="<?= $valor ?>"></a>
  </div>
</div>
<input type="hidden" name="tipo_factura" value="<?= $tipo_factura ?>">


<!-- <h5><b>Monto Total Cobrado: </b>$ <?= number_format($monto_cobranza, 0, ',', '.'); ?></h5> -->
<br>
<form action="sql_cod.php" method="post" class="" name="formCobroConvenio" id="formCobroConvenio">
  <table class="table table-responsive table-hover table-bordered datatable-atenciones-cobranza">
    <thead>
      <tr>
        <th>N° atención</th>
        <th>Fecha atención</th>
        <th>Paciente</th>
        <th>Monto atención</th>
        <th>Descuento ($)</th>
        <th>Descuento (%)</th>
        <th>Monto atención con descuentos</th>
        <th>Monto pagado</th>
        <th>Monto Convenio</th>
      </tr>
    </thead>
    <tbody>
      <?php
      $monto_cobranza = 0;
      while ($qAtencionesCobranza->fetch()) {
        $montoConDescuentos = $a_montoAtencion - $a_montoDescuento;
        if ($a_pctjeDescuento != "" || $a_pctjeDescuento > 0) $montoConDescuentos = $montoConDescuentos * (100 - $a_pctjeDescuento) / 100;
        $monto_cobranza += $a_montoACobrarConvenio;
      ?>
        <tr>
          <td><?= $a_idAtencion ?></td>
          <td><?= $a_fechaAtencion ?></td>
          <td><?= $a_nombrePaciente ?></td>
          <td>$ <?= number_format($a_montoAtencion, 0, ',', '.'); ?></td>
          <td>$ <?= number_format($a_montoDescuento, 0, ',', '.'); ?></td>
          <td><?= $a_pctjeDescuento ?> %</td>
          <td><b>$ <?= number_format($montoConDescuentos, 0, ',', '.'); ?></b></td>
          <td>$ <?= number_format($a_montoPagado, 0, ',', '.'); ?></td>
          <td><b>$ <?= number_format($a_montoACobrarConvenio, 0, ',', '.'); ?></b></td>
        </tr>
      <?php }
      $qAtencionesCobranza->close() ?>
    </tbody>
    <tfoot>
      <!-- <tr>
        <td class="text-center" colspan="9">
          <h5 class="text-center" colspan="9"> <b>Monto Total Cobrado: </b>$ <?= number_format($monto_cobranza, 0, ',', '.'); ?> </h5>
        </td>
      </tr> -->
      <tr>
        <td class="text-center" colspan="9">
          <?php
          $total_atenciones = $flag_iva == "S" ? $monto_cobranza / 1.19 : $monto_cobranza;
          $iva = $flag_iva == "S" ? ($monto_cobranza / 1.19) * 0.19 : $monto_cobranza * 0.19;
          $total_pagar = $flag_iva == "S" ? $monto_cobranza : $monto_cobranza * 1.19;
          if ($tipo_factura == 34) {
            $total_atenciones = $monto_cobranza;
            $total_pagar = $monto_cobranza;
          }
          $array_detalles_factura = array(
            array(
              'nombre' => "0",
              'descripcion' => "EXÁMENES DE LABORATORIO\nPCR SARS COV-2\nATENCIONES REALIZADAS DURANTE EL MES DE XXXXXX DE XXXX",
              'cantidad' => $numRowsAtenciones,
              'precio_unitario' => null,
              'porc_descuento' => '0',
              'monto_descuento' => '0',
              'monto' => round($total_pagar, 0),
              'id_detalle_venta' => ''
            )
          );
          $datos_venta = "c_razon_social: '" . json_encode($nombreConvenio)  . "', c_direccion: 'A', c_rut: '" . $rut_empresa . "'";
          ?>
          <h5 class="text-center" colspan="9"> <b>Total atenciones : </b>$ <?= number_format($total_atenciones, 0, ',', '.'); ?> </h5>
          <?php if ($tipo_factura != 34) { ?>
            <h5 class="text-center" colspan="9"> <b>IVA: </b>$ <?= number_format($iva, 0, ',', '.'); ?> </h5>
          <?php } ?>
          <h5 class="text-center" colspan="9"> <b>Monto total cobrado: </b>$ <?= number_format($total_pagar, 0, ',', '.'); ?> </h5>
          <a class="btn btn-sm btn-primary btn-success btn-generarFactura" target="_blank"><i class="fa fa-money"></i> Generar Factura Electrónica </a>
        </td>
      </tr>
    </tfoot>
  </table>
</form>


<?php
$contenido = ob_get_contents();
ob_end_clean();

$ui = new SmartUI;
$options = array("editbutton" => false);
$widget = $ui->create_widget($options);

$widget->header = array(
  "title" => $datos_pantallas[$pantalla_actual]['body_title'] . "<em>" . $nombreConvenio . "</em></h2>",
  "icon" => 'fa fa-cog'
);
$widget->body('content', $contenido);
?>

<div id="main" role="main">
  <?php
  include("../inc/ribbon.php");
  ?>
  <!-- MAIN CONTENT -->
  <div id="content">
    <?php
    $widget->print_html();
    ?>
  </div>
</div>

<?php
include("../inc/footer.php");
include("../inc/scripts.php");
?>

<script src="../assets/js/plugin/x-editable/x-editable.min.js"></script>

<script>
  $(document).ready(function() {

    $(".folio_input").editable({
      onblur: "ignore",
      url: 'sql_cod.php',
      type: 'number',
      name: "grabarFolioCobranza",
      title: 'Modificar Folio Cobranza',
      success: function(response, newValue) {
        location.reload();
        exito();
      }
    });

    $('.datatable-atenciones-cobranza').DataTable({
      'lengthMenu': [
        [5, 10, 20, 50],
        [5, 10, 20, 50]
      ],
      'language': {
        'sProcessing': 'Procesando...',
        'sZeroRecords': 'No se encontraron resultados',
        'sInfoPostFix': '',
        'sUrl': '',
        'oPaginate': {
          'sFirst': 'Primero',
          'sPrevious': 'Anterior',
          'sNext': 'Siguiente',
          'sLast': 'Último'
        },
        'sInfo': '_START_ a _END_ de _TOTAL_ Registros',
        'sInfoEmpty': '0 Registros',
        'sInfoFiltered': '(de _MAX_ Registros en total)',
        'sLengthMenu': 'Mostrar _MENU_ Registros',
        'sSearch': 'Buscar: '
      },
      'pageLength': 20,
      'order': [0, 'desc'],
      'columns': [
        null,
        null,
        null,
        null,
        null,
        null,
        null,
        null,
        null
      ],
    });

    $('.btn-generarFactura').on('click', function() {
      var detalle = <?= json_encode($array_detalles_factura) ?>;
      //var otrodetalle=JSON.stringify(detalle);
      //console.log(otrodetalle);
      //console.log(detalle);
      rut = '<?= $ate_rut ?>';
      // if(!validarRut(rut)) {
      //   alert('El rut del paciente no es válido, debe ser modificado.');
      //   return false;
      // } 
      var tipo_factura = 33;
      $(".tipo_factura").each(function() {
        if (this.checked) {
          tipo_factura = this.value;
        }
      });
      console.log(tipo_factura);
      var texto = "";
      if (tipo_factura != 33) {
        texto = "Exenta";
      }
      if (confirm('¿Desea generar Factura ' + texto + "?")) {
        $(this).addClass('disabled');
        var urlVentasSqlCod = '<?= $urlVentasSqlCod ?>';
        var id = $(this).data('id');
        var ext = '<?= $pacienteExtranjero ?>';
        $.post(urlVentasSqlCod, {
          updateVenta: 1,
          cod_empresa: 'ETCHEVERRY',
          monto_neto: 0,
          tasa_iva: 19,
          monto_exento: 0,
          detalle: detalle,
          <?= $datos_venta ?>,
          tipo_dte: tipo_factura
        }, function(data) {
          if (data.exito) {
            exito();
            var idv = data.idv;
            var ide = data.ide;
            var url = '<?= $url_asociar_cc ?>';
            var urlDetalleVenta = '<?= $urlDetalleVenta ?>?id_venta=' + idv + '&id_empresa=' + ide + '&ext=' + ext + '&url=' + url;
            popup(urlDetalleVenta);
          } else {
            error(data.mensaje);
          }
        }, 'json');
        $(this).removeClass('disabled');
      }
    });

    function popup(theURL) {
      window.open(theURL, 'Popup', 'status=yes, scrollbars=yes, resizable=yes, width=1050, height=600');
    }

  });

  $(".tipo_factura").on('click', function() {
    console.log(this.value);
    $.ajax({
        data: {
          "name": 'tipo_factura',
          "value": this.value,
          "pk": '<?= $_GET['id_cc'] ?>'
        },
        type: "POST",
        dataType: "json",
        url: "sql_cod.php",
      })
      .done(function(data, textStatus, jqXHR) {
        console.log("La solicitud se ha completado correctamente.");
      })
      .fail(function(jqXHR, textStatus, errorThrown) {
        error(textStatus)
      });
  });
</script>

<?php
include("../inc/google-analytics.php");
?>