<?php
$pantalla_actual = 'HIS_COBR_CONV';
define('PERMITIDO', true);
require_once("../inc/init.php");
require_once("../inc/config.ui.php");
$page_title = $datos_pantallas[$pantalla_actual]['page_title'];
$page_css[] = "your_style.css";
include("../inc/header.php");
include("../inc/nav.php");

$qConvenios=$mysqli->prepare("SELECT e.NOMBRE_E FROM empresas e WHERE e.ID_EMPRESA = ? LIMIT 1");
$qConvenios->bind_param('i', $_GET['id_conv']);
$qConvenios->execute();
$qConvenios->bind_result($nombreConvenio);
$qConvenios->store_result();
$qConvenios->fetch();
$qConvenios->close();

$qCobranzas=$mysqli->prepare("SELECT cc.ID_COBRANZA_CONVENIO, DATE_FORMAT(cc.FECHA_COBRANZA,'%d/%m/%Y'), cc.MONTO_COBRANZA, 
DATE_FORMAT(cc.FECHA_DESDE,'%d/%m/%Y'), DATE_FORMAT(cc.FECHA_HASTA,'%d/%m/%Y')
FROM cobranzas_convenios cc
WHERE cc.ID_CONVENIO = ?
ORDER BY cc.FECHA_COBRANZA DESC");
$qCobranzas->bind_param('i', $_GET['id_conv']);
$qCobranzas->execute();
$qCobranzas->bind_result($cc_idCobranzaConvenio, $cc_fechaCobranza, $cc_montoCobranza, $cc_fechaDesde, $cc_fechaHasta);
$qCobranzas->execute();
$qCobranzas->store_result();

ob_start();
?>

<form action="sql_cod.php" method="post" class="" name="formCobroConvenio" id="formCobroConvenio">
  <table class="table table-responsive table-hover table-bordered datatable-cobranzas">
    <thead>
      <tr>
        <th>Fecha cobranza</th>
        <th>Monto total cobranza</th>
        <th>Fecha atenciones desde</th>
        <th>Fecha atenciones hasta</th>
        <th>Detalle atenciones de cobranza</th>
      </tr>
    </thead>
    <tbody>
    <?php while($qCobranzas->fetch()) { ?>
      <tr>
        <td><?=$cc_fechaCobranza?></td>
        <td>$ <?=number_format($cc_montoCobranza,0,',','.');?></td>
        <td><?=$cc_fechaDesde?></td>
        <td><?=$cc_fechaHasta?></td>
        <td><a class="btn btn-link" href="detalle_historial.php?id_cc=<?=$cc_idCobranzaConvenio?>"><i class="fa fa-eye fa-lg"></i></a></td>
      </tr>
    <?php } $qCobranzas->close() ?>
    </tbody>
  </table>
</form>

<?php
$contenido = ob_get_contents();
ob_end_clean();

$ui = new SmartUI;
$options = array("editbutton" => false);
$widget = $ui->create_widget($options);

$widget->header = array(
  "title" => $datos_pantallas[$pantalla_actual]['body_title']."<em>".$nombreConvenio."</em></h2>",
  "icon" => 'fa fa-cog'
);
$widget->body('content', $contenido);
?>

<div id="main" role="main">
	<?php
		include("../inc/ribbon.php");
	?>
	<!-- MAIN CONTENT -->
  <div id="content">	
    <?php
      $widget->print_html();
    ?>
  </div>
</div>

<?php
	include("../inc/footer.php");
	include("../inc/scripts.php");
?>

<script>
$(document).ready(function() {

  $('.datatable-cobranzas').DataTable({
    'lengthMenu': [[5, 10, 20, 50], [5, 10, 20, 50]],
    'language': {
      'sProcessing': 'Procesando...',
      'sZeroRecords': 'No se encontraron resultados',
      'sInfoPostFix': '',
      'sUrl': '',
      'oPaginate': {
        'sFirst': 'Primero',
        'sPrevious': 'Anterior',
        'sNext': 'Siguiente',
        'sLast': 'Último'
      },
      'sInfo': '_START_ a _END_ de _TOTAL_ Registros',
      'sInfoEmpty': '0 Registros',
      'sInfoFiltered': '(de _MAX_ Registros en total)',
      'sLengthMenu': 'Mostrar _MENU_ Registros',
      'sSearch': 'Buscar: '
    },
    'pageLength' : 50,
    'order' : [ 0, 'desc' ],
    'columns': [
      null,
      null,
      null,
      null,
      {'orderable': false}
    ],
    'destroy': true
  });
});
</script>
<?php 
	//include footer
	include("../inc/google-analytics.php");
?>