<?php
define('PERMITIDO', true);
require_once('../inc/init.php');
require_once('../assets/tcpdf/tcpdf.php');

if (isset($_GET['id_conv']) && $_GET['id_conv'] != "") {
  $qConvenio = $mysqli->prepare("SELECT e.NBR FROM empresas e WHERE e.ID_EMPRESA = ? LIMIT 1");
  $qConvenio->bind_param('i', $_GET['id_conv']);
  $qConvenio->execute();
  $qConvenio->bind_result($nbrConvenio);
  $qConvenio->store_result();
  $qConvenio->fetch();
  $qConvenio->close();
  $fechaDesde = implode('/', array_reverse(explode('-', $_GET['desde'])));
  $fechaHasta = implode('/', array_reverse(explode('-', $_GET['hasta'])));
}

if (isset($_GET['id_cc']) && $_GET['id_cc'] != "") {
  $qCobranzaConvenio = $mysqli->prepare("SELECT cc.FOLIO, cc.TIPO_FACTURA, DATE_FORMAT(cc.FECHA_COBRANZA,'%d/%m/%Y'),
  DATE_FORMAT(cc.FECHA_DESDE,'%d/%m/%Y'), DATE_FORMAT(cc.FECHA_HASTA,'%d/%m/%Y'),
  CONCAT_WS('-', e.NRO_RUT_EMPRESA, e.DV_RUT_EMPRESA), e.NBR, e.FLAG_IVA
  FROM cobranzas_convenios cc
  LEFT JOIN empresas e ON e.ID_EMPRESA = cc.ID_CONVENIO
  WHERE ID_COBRANZA_CONVENIO = ? LIMIT 1");
  $qCobranzaConvenio->bind_param('i', $_GET['id_cc']);
  $qCobranzaConvenio->execute();
  $qCobranzaConvenio->bind_result($folioCobranza, $tipoFacturaCobranza, $fechaCobranza, $fechCobranzaDesde, $fechCobranzaHasta, $rutConvenio, $nbrConvenio, $flagIvaIncluido);
  $qCobranzaConvenio->store_result();
  $qCobranzaConvenio->fetch();
  $qCobranzaConvenio->close();
  $fechaDesde = $fechCobranzaDesde;
  $fechaHasta = $fechCobranzaHasta;
}

class ResultadosDialisis extends TCPDF {
  public function Header() {
    $this->setImageScale(1);
    $this->setJPEGQuality(100);
    $this->Image('../assets/img/logo_empresa2.jpg', 10, 0, 60, null);
  }
  public function Footer() {
    $this->SetFont('helvetica', '', 9);
    $paginas = "Página " . $this->getAliasNumPage() . ' de ' . $this->getAliasNbPages();
    $this->writeHTMLCell(null, null, 10, 290, $paginas, 0, 1, null, true, 'C', true);
  }
}

$pdf = new ResultadosDialisis('P', 'mm', 'letter', true, 'UTF-8', false);
$pdf->SetMargins(10, 25, 0);
# $pdf->SetHeaderMargin(20);
$pdf->SetFooterMargin(15);
$pdf->SetAutoPageBreak(true, 15);
$pdf->setFontSubsetting(true);

if (!isset($_GET['id_cc'])) {
  $filtro = "";
  if (isset($_GET['desde']) && $_GET['desde'] != "") $filtro .= " AND a.FECHA >= '{$_GET['desde']}'";
  if (isset($_GET['hasta']) && $_GET['hasta'] != "") $filtro .= " AND a.FECHA <= '{$_GET['hasta']}'";
  $qConvenios = $mysqli->prepare("SELECT a.ID_ATENCION, DATE_FORMAT(a.FECHA, '%d/%m/%Y'), cc.NOMBRE, CONCAT_WS('-', p.NRO_RUT, p.DV_RUT),
  CONCAT_WS(' ', p.NOMBRES, p.APELLIDO_PATERNO, p.APELLIDO_MATERNO), pre.NBR, a.MONTO_ATENCION,
  a.MONTO_ATENCION - SUM(pa.MONTO_PAGADO) AS COPAGO,
  IF(a.MONTO_ATENCION - SUM(pa.MONTO_PAGADO), '', a.MONTO_ATENCION) AS PARTICULAR,
  '' AS BOLETAS, 
  a.MONTO_PAGADO, a.MONTO_DESCUENTO, a.MONTO_CONVENIO, a.PCTJE_DESCUENTO
  FROM atenciones a
  INNER JOIN personas p ON a.ID_CLIENTE = p.ID_PERSONA
  INNER JOIN centros_contacto cc ON a.ID_CENTRO_CONTACTO = cc.ID_CENTRO_CONTACTO
  LEFT JOIN empresas c ON a.ID_CONVENIO = c.ID_EMPRESA
  LEFT JOIN empresas pre ON pre.ID_EMPRESA = a.ID_PREVISION
  LEFT JOIN usuarios u ON u.ID_USUARIO = a.ID_USUARIO
	LEFT JOIN pagos pa ON pa.ID_ATENCION = a.ID_ATENCION AND pa.FORMA_PAGO IN (1, 9) # BONOS O SEGUROS
  WHERE c.ID_EMPRESA = ? AND a.FLAG_ELIMINADO = 0 $filtro
  AND a.ID_COBRANZA_CONVENIO IS NULL
	GROUP BY a.ID_ATENCION 
  ORDER BY a.ID_ATENCION ASC");
  $qConvenios->bind_param('i', $_GET['id_conv']);
} else {
  $qConvenios = $mysqli->prepare("SELECT a.ID_ATENCION, DATE_FORMAT(a.FECHA, '%d/%m/%Y'), cc.NOMBRE, CONCAT_WS('-', p.NRO_RUT, p.DV_RUT),
  CONCAT_WS(' ', p.NOMBRES, p.APELLIDO_PATERNO, p.APELLIDO_MATERNO), pre.NBR, a.MONTO_ATENCION,
  a.MONTO_ATENCION - SUM(pa.MONTO_PAGADO) AS COPAGO,
  IF(a.MONTO_ATENCION - SUM(pa.MONTO_PAGADO), '', a.MONTO_ATENCION) AS PARTICULAR,
  '' AS BOLETAS, 
  a.MONTO_PAGADO, a.MONTO_DESCUENTO, a.MONTO_CONVENIO, a.PCTJE_DESCUENTO
  FROM atenciones a
  INNER JOIN personas p ON a.ID_CLIENTE = p.ID_PERSONA
  INNER JOIN centros_contacto cc ON a.ID_CENTRO_CONTACTO = cc.ID_CENTRO_CONTACTO
  LEFT JOIN empresas c ON a.ID_CONVENIO = c.ID_EMPRESA
  LEFT JOIN empresas pre ON pre.ID_EMPRESA = a.ID_PREVISION
  LEFT JOIN usuarios u ON u.ID_USUARIO = a.ID_USUARIO
  LEFT JOIN pagos pa ON pa.ID_ATENCION = a.ID_ATENCION AND pa.FORMA_PAGO IN (1, 9) # BONOS O SEGUROS
  WHERE a.ID_COBRANZA_CONVENIO = ? AND a.FLAG_ELIMINADO = 0 
  GROUP BY a.ID_ATENCION 
  ORDER BY a.ID_ATENCION ASC");
  $qConvenios->bind_param('i', $_GET['id_cc']);
}
$qConvenios->execute();
$qConvenios->bind_result($a_idAtencion, $a_fechaFormateada, $a_local, $a_rutPaciente, $a_nombrePaciente, $a_prevision, $a_montoAtencion, $a_copago, $a_particular, $a_boletas, $a_montoPagado, $a_montoDescuento, $a_montoConvenio, $a_pctjeDescuento);
$qConvenios->execute();
$qConvenios->store_result();
$numRows = $qConvenios->num_rows;

$data = "";
$total_atenciones = 0;
$iva = 0;
$total_pagar = 0;
while ($qConvenios->fetch()) {
  $a_particular = $a_particular - $a_montoDescuento - ($a_particular * $a_pctjeDescuento / 100);
  $aPagar = $a_particular;
  if ($a_montoConvenio) $aPagar = $a_montoConvenio;
  if ($a_copago) $aPagar = "";

  if ($tipoFacturaCobranza == 34) {
    $total_atenciones += $aPagar;
    $iva = 0;
    $total_pagar += $aPagar;
  }

  if ($tipoFacturaCobranza != 34) {
    $total_atenciones += $flagIvaIncluido == "S" ? $aPagar / 1.19 : $aPagar;
    $iva += $flagIvaIncluido == "S" ? ($aPagar / 1.19) * 0.19 : $aPagar * 0.19;
    $total_pagar += $flagIvaIncluido == "S" ? $aPagar : $aPagar * 1.19;
  }

  $data .=
    '<tr>
    <td style="width:10%">' . $a_idAtencion . '</td>
    <td style="width:10%">' . $a_fechaFormateada . '</td>
    <td style="width:13%">' . $a_local . '</td>
    <td style="width:10%">' . $a_rutPaciente . '</td>
    <td style="width:22%">' . $a_nombrePaciente . '</td>
    <td style="width:10%">' . $a_prevision . '</td>
    <td style="width:9%">$ ' . number_format($a_copago, 0, ',', '.') . '</td>
    <td style="width:11%">$ ' . number_format($aPagar, 0, ',', '.') . '</td>
  </tr>';
}

$pdf->AddPage();
$pdf->SetFont('times', '', 13);
$pdf->writeHTML("<b>Cobranza $nbrConvenio ($fechaDesde - $fechaHasta)</b><br>", true, false, false, false, 'L');
$pdf->SetFont('times', '', 8.5);
$datosCaja = '
	<table border="1" cellpadding="4" style="width:30%">
		<tbody>
    <tr>
				<td style="width: 50%">N° ATENCIONES</td>
				<td style="width: 50%">' . $numRows . '</td>
			</tr>
			<tr>
				<td style="width: 50%">TOTAL</td>
				<td style="width: 50%">$ ' . number_format($total_atenciones, 0, ',', '.') . '</td>
			</tr>
      <tr>
        <td style="width: 50%">IVA</td>
        <td style="width: 50%">$ ' . number_format($iva, 0, ',', '.') . '</td>
			</tr>
      <tr>
        <td style="width: 50%">TOTAL A PAGAR</td>
        <td style="width: 50%">$ ' . number_format($total_pagar, 0, ',', '.') . '</td>
			</tr>
		</tbody>
	</table>';
$pdf->writeHTML($datosCaja, true, false, false, false, 'L');

if ($data == "") $pdf->writeHTML("Error, No hay resultados", true, false, false, false, '');
else {
  $tbl =
    '<table border="1" cellpadding="4">
  <thead>
    <tr style="background-color: #f2f2f2;">
      <th style="width:10%">ATENCIÓN</th>
      <th style="width:10%">FECHA</th>
      <th style="width:13%">LOCAL</th>
      <th style="width:10%">RUT PACIENTE</th>
      <th style="width:22%">NOMBRE PACIENTE</th>
      <th style="width:10%">PREVISIÓN</th>
      <th style="width:9%">COPAGO</th>
      <th style="width:11%">PARTICULAR</th>
    </tr>
  </thead>
  <tbody>
    ' . $data . '
  </tbody>
  </table>';
  $pdf->SetFont('times', '', 8.5);
  $pdf->writeHTML($tbl, false, false, false, false, 'L');
}

$tiempo = time();
$hoy = date('d-m-Y', $tiempo);
ob_end_clean();
$pdf->Output("Cobranza $nbrConvenio ($fechaDesde - $fechaHasta).pdf", 'I');
