<?php
define('PERMITIDO', true);
require_once '../lib/valido.php';
require_once '../lib/util.php';
require_once '../lib/func.global.php';
require_once '../lib/connection.php';
require_once '../lib/config.php';
require_once '../assets/php/PHPExcel.php';
$tiempo = time();
$hoy = date('d-m-Y', $tiempo);

error_reporting(E_ALL);
ini_set('display_errors', true);
ini_set('display_startup_errors', true);

if (PHP_SAPI == 'cli') die('This file should only be run from a Web Browser');

$objPHPExcel = new PHPExcel();
$objPHPExcel->getProperties()->setCreator('RIPIT')->setTitle('Reporte');

if (isset($_GET['id_conv']) && $_GET['id_conv'] != "") {
	$qConvenio = $mysqli->prepare("SELECT e.NBR, e.FLAG_IVA FROM empresas e WHERE e.ID_EMPRESA = ? LIMIT 1");
	$qConvenio->bind_param('i', $_GET['id_conv']);
	$qConvenio->execute();
	$qConvenio->bind_result($nbrConvenio, $flagIvaIncluido);
	$qConvenio->store_result();
	$qConvenio->fetch();
	$qConvenio->close();
	$fechaDesde = implode('/', array_reverse(explode('-', $_GET['f_desde'])));
	$fechaHasta = implode('/', array_reverse(explode('-', $_GET['f_hasta'])));
	$tipoFacturaCobranza = 563736356; #truco malo
}

if (isset($_GET['id_cc']) && $_GET['id_cc'] != "") {
	$qCobranzaConvenio = $mysqli->prepare("SELECT cc.FOLIO, cc.TIPO_FACTURA, DATE_FORMAT(cc.FECHA_COBRANZA,'%d/%m/%Y'),
  DATE_FORMAT(cc.FECHA_DESDE,'%d/%m/%Y'), DATE_FORMAT(cc.FECHA_HASTA,'%d/%m/%Y'),
  CONCAT_WS('-', e.NRO_RUT_EMPRESA, e.DV_RUT_EMPRESA), e.NBR, e.FLAG_IVA
  FROM cobranzas_convenios cc
  LEFT JOIN empresas e ON e.ID_EMPRESA = cc.ID_CONVENIO
  WHERE ID_COBRANZA_CONVENIO = ? LIMIT 1");
	$qCobranzaConvenio->bind_param('i', $_GET['id_cc']);
	$qCobranzaConvenio->execute();
	$qCobranzaConvenio->bind_result($folioCobranza, $tipoFacturaCobranza, $fechaCobranza, $fechCobranzaDesde, $fechCobranzaHasta, $rutConvenio, $nbrConvenio, $flagIvaIncluido);
	$qCobranzaConvenio->store_result();
	$qCobranzaConvenio->fetch();
	$qCobranzaConvenio->close();
	$fechaDesde = $fechCobranzaDesde;
	$fechaHasta = $fechCobranzaHasta;
}

if (!isset($_GET['id_cc'])) {
	$filtro = "";
	if (isset($_GET['f_desde']) && $_GET['f_desde'] != "") $filtro .= " AND a.FECHA >= '{$_GET['f_desde']}'";
	if (isset($_GET['f_hasta']) && $_GET['f_hasta'] != "") $filtro .= " AND a.FECHA <= '{$_GET['f_hasta']}'";
	$qConvenios = $mysqli->prepare("SELECT a.ID_ATENCION, DATE_FORMAT(a.FECHA, '%d/%m/%Y'), cc.NOMBRE, CONCAT_WS('-', p.NRO_RUT, p.DV_RUT),
  CONCAT_WS(' ', p.NOMBRES, p.APELLIDO_PATERNO, p.APELLIDO_MATERNO), pre.NBR, a.MONTO_ATENCION,
  a.MONTO_ATENCION - SUM(pa.MONTO_PAGADO) AS COPAGO, 
  IF(a.MONTO_ATENCION - SUM(pa.MONTO_PAGADO), '', a.MONTO_ATENCION) AS PARTICULAR,
  '' AS BOLETAS, 
  a.MONTO_PAGADO, a.MONTO_DESCUENTO, a.MONTO_CONVENIO, a.PCTJE_DESCUENTO
  FROM atenciones a
	INNER JOIN personas p ON a.ID_CLIENTE = p.ID_PERSONA
	INNER JOIN centros_contacto cc ON a.ID_CENTRO_CONTACTO = cc.ID_CENTRO_CONTACTO
	LEFT JOIN empresas c ON a.ID_CONVENIO = c.ID_EMPRESA
	LEFT JOIN empresas pre ON pre.ID_EMPRESA = a.ID_PREVISION
	LEFT JOIN usuarios u ON u.ID_USUARIO = a.ID_USUARIO
	LEFT JOIN pagos pa ON pa.ID_ATENCION = a.ID_ATENCION AND pa.FORMA_PAGO IN (1, 9) #BONOS O SEGUROS
	WHERE c.ID_EMPRESA = ? AND a.FLAG_ELIMINADO = 0 $filtro
	AND a.ID_COBRANZA_CONVENIO IS NULL
	GROUP BY a.ID_ATENCION 
	ORDER BY a.ID_ATENCION DESC");
	$qConvenios->bind_param('i', $_GET['id_conv']);
} else {
	$qConvenios = $mysqli->prepare("SELECT a.ID_ATENCION, DATE_FORMAT(a.FECHA, '%d/%m/%Y'), cc.NOMBRE, CONCAT_WS('-', p.NRO_RUT, p.DV_RUT),
  CONCAT_WS(' ', p.NOMBRES, p.APELLIDO_PATERNO, p.APELLIDO_MATERNO), pre.NBR, a.MONTO_ATENCION,
  a.MONTO_ATENCION - SUM(pa.MONTO_PAGADO) AS COPAGO, 
  IF(a.MONTO_ATENCION - SUM(pa.MONTO_PAGADO), '', a.MONTO_ATENCION) AS PARTICULAR,
  '' AS BOLETAS, 
  a.MONTO_PAGADO, a.MONTO_DESCUENTO, a.MONTO_CONVENIO, a.PCTJE_DESCUENTO
  FROM atenciones a
	INNER JOIN personas p ON a.ID_CLIENTE = p.ID_PERSONA
	INNER JOIN centros_contacto cc ON a.ID_CENTRO_CONTACTO = cc.ID_CENTRO_CONTACTO
	LEFT JOIN empresas c ON a.ID_CONVENIO = c.ID_EMPRESA
	LEFT JOIN empresas pre ON pre.ID_EMPRESA = a.ID_PREVISION
	LEFT JOIN usuarios u ON u.ID_USUARIO = a.ID_USUARIO
	LEFT JOIN pagos pa ON pa.ID_ATENCION = a.ID_ATENCION AND pa.FORMA_PAGO IN (1, 9) #BONOS O SEGUROS
	WHERE a.ID_COBRANZA_CONVENIO = ? AND a.FLAG_ELIMINADO = 0 
	GROUP BY a.ID_ATENCION 
	ORDER BY a.ID_ATENCION DESC");
	$qConvenios->bind_param('i', $_GET['id_cc']);
}
$qConvenios->execute();
$qConvenios->bind_result($a_idAtencion, $a_fechaFormateada, $a_local, $a_rutPaciente, $a_nombrePaciente, $a_prevision, $a_montoAtencion, $a_copago, $a_particular, $a_boletas, $a_montoPagado, $a_montoDescuento, $a_montoACobrarConvenio, $a_pctjeDescuento);
$qConvenios->store_result();
$numRows = $qConvenios->num_rows;

$objPHPExcel->getActiveSheet()->getColumnDimension('A')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('B')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('C')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('D')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('E')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('F')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('G')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('H')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('I')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('J')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('K')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('L')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('M')->setAutoSize(true);

$styleArray = [
	'font'  => [
		'bold'  => true,
		'size'  => 15,
		'name'  => 'Verdana'
	],
	'alignment' => [
		'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
		'vertical' => PHPExcel_Style_Alignment::VERTICAL_CENTER
	],
	// 'borders' => [
	// 	'allborders' => [
	// 		'style' => PHPExcel_Style_Border::BORDER_THIN,
	// 		'color' => ['rgb' => '000000']
	// 	]
	// ]
];
$objPHPExcel->getActiveSheet()->mergeCells('A1:I1');
$objPHPExcel->getActiveSheet()->getStyle('A1:I1')->applyFromArray($styleArray);
$objPHPExcel->getActiveSheet()->setCellValue('A1', "Cobranza $nbrConvenio ($fechaDesde - $fechaHasta)");

$objPHPExcel->setActiveSheetIndex(0)
	->setCellValue('A3', 'N° ATENCIÓN')
	->setCellValue('B3', 'FECHA')
	->setCellValue('C3', 'LOCAL')
	->setCellValue('D3', 'RUT PACIENTE')
	->setCellValue('E3', 'NOMBRE PACIENTE')
	->setCellValue('F3', 'PREVISIÓN')
	->setCellValue('G3', 'COPAGO')
	->setCellValue('H3', 'PARTICULAR')
	->setCellValue('I3', 'BOLETAS');

$f = 4;
$total_atenciones = 0;
$iva = 0;
$total_pagar = 0;
while ($qConvenios->fetch()) {
	$a_particular = $a_particular - $a_montoDescuento - ($a_particular * $a_pctjeDescuento / 100);
	$aPagar = $a_particular;
	if ($a_montoACobrarConvenio) $aPagar = $a_montoACobrarConvenio;
	if ($a_copago) $aPagar = "";

  if ($tipoFacturaCobranza == 34) {
    $total_atenciones += $aPagar;
    $iva = 0;
    $total_pagar += $aPagar;
  }

  if ($tipoFacturaCobranza != 34) {
    $total_atenciones += $flagIvaIncluido == "S" ? $aPagar / 1.19 : $aPagar;
    $iva += $flagIvaIncluido == "S" ? ($aPagar / 1.19) * 0.19 : $aPagar * 0.19;
    $total_pagar += $flagIvaIncluido == "S" ? $aPagar : $aPagar * 1.19;
  }

	$objPHPExcel->setActiveSheetIndex(0)->setCellValue('A' . $f, $a_idAtencion);
	$objPHPExcel->setActiveSheetIndex(0)->setCellValue('B' . $f, $a_fechaFormateada);
	$objPHPExcel->setActiveSheetIndex(0)->setCellValue('C' . $f, $a_local);
	$objPHPExcel->setActiveSheetIndex(0)->setCellValue('D' . $f, $a_rutPaciente);
	$objPHPExcel->setActiveSheetIndex(0)->setCellValue('E' . $f, $a_nombrePaciente);
	$objPHPExcel->setActiveSheetIndex(0)->setCellValue('F' . $f, $a_prevision);
	$objPHPExcel->setActiveSheetIndex(0)->setCellValue('G' . $f, $a_copago);
	$objPHPExcel->setActiveSheetIndex(0)->setCellValue('H' . $f, $aPagar);
	$objPHPExcel->setActiveSheetIndex(0)->setCellValue('I' . $f, $a_boletas);
	$f++;
}
$qConvenios->close();

$ultimaFilaTabla = 3 + $numRows;
$objPHPExcel->getActiveSheet()->setCellValue("L3", "N° ATENCIONES");
$objPHPExcel->getActiveSheet()->setCellValue("M3", "$numRows");
$objPHPExcel->getActiveSheet()->setCellValue("L4", "TOTAL");
$objPHPExcel->getActiveSheet()->setCellValue("M4", "=SUM(H4:H". $ultimaFilaTabla . ")");
$objPHPExcel->getActiveSheet()->setCellValue("L5", "IVA");
$objPHPExcel->getActiveSheet()->setCellValue("M5", "=M4*0.19");
$objPHPExcel->getActiveSheet()->setCellValue("L6", "TOTAL A PAGAR");
$objPHPExcel->getActiveSheet()->setCellValue("M6", "=(M4+M5)");
$objPHPExcel->getActiveSheet()->getStyle("L3:M6")->applyFromArray(
	array(
		'borders' => array(
			'allborders' => array(
				'style' => PHPExcel_Style_Border::BORDER_THIN,
				'color' => array('rgb' => '000000')
			)
		)
	)
);

// $posicion = 5 + $numRows;
// $objPHPExcel->getActiveSheet()->setCellValue("G" . $posicion, "N° ATENCIONES");
// $objPHPExcel->getActiveSheet()->setCellValue("H" . $posicion, $numRows);
// $posicion2 = $posicion + 1;
// $objPHPExcel->getActiveSheet()->setCellValue("G" . $posicion2, "TOTAL");
// $objPHPExcel->getActiveSheet()->setCellValue("H" . $posicion2, "=SUM(H4:H" . $ultimaFilaTabla . ")");
// $posicion3 = $posicion2 + 1;
// $objPHPExcel->getActiveSheet()->setCellValue("G" . $posicion3, "IVA");
// $objPHPExcel->getActiveSheet()->setCellValue("H" . $posicion3, "=H" . $posicion2 . "* 0.19");
// $posicion4 = $posicion3 + 1;
// $objPHPExcel->getActiveSheet()->setCellValue("G" . $posicion4, "TOTAL A PAGAR");
// $objPHPExcel->getActiveSheet()->setCellValue("H" . $posicion4, "=(H" . $posicion2 . "+H" . $posicion3 . ")");
// $objPHPExcel->getActiveSheet()->getStyle("G" . $posicion . ":H" . $posicion4)->applyFromArray(
// 	array(
// 		'borders' => array(
// 			'allborders' => array(
// 				'style' => PHPExcel_Style_Border::BORDER_THIN,
// 				'color' => array('rgb' => '000000')
// 			)
// 		)
// 	)
// );

$objPHPExcel->getActiveSheet()->setTitle('Hoja 1');
$objPHPExcel->setActiveSheetIndex(0);
header('Content-Type: application/vnd.ms-excel');
header("Content-Disposition: attachment;filename=Cobranza $nbrConvenio ($fechaDesde - $fechaHasta).xls");
header('Cache-Control: max-age=0');

$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
$objWriter->save('php://output');
die();
