<?php
$pantalla_actual = 'CON_PRE_EXA';
define('PERMITIDO', true);
require_once("../inc/init.php");
require_once("../inc/config.ui.php");
$page_title = $datos_pantallas[$pantalla_actual]['page_title'];
$page_css[] = "your_style.css";
include("../inc/header.php");
include("../inc/nav.php");

$qEmpresas = $mysqli->prepare("SELECT e.ID_EMPRESA, CONCAT_WS('-', e.NRO_RUT_EMPRESA, e.DV_RUT_EMPRESA), e.NOMBRE_E, 
e.NBR, COUNT(p.ID_PEX) AS total_examenes
FROM empresas e
LEFT JOIN 
(
  SELECT ID_EMPRESA, COD_EXAMEN, MAX(ID_PEX) AS ID_PEX
  FROM precios_examenes 
  GROUP BY ID_EMPRESA, COD_EXAMEN
) AS p ON p.ID_EMPRESA = e.ID_EMPRESA
WHERE e.FLAG_PREVISION = 'S' OR e.FLAG_CONVENIO = 'S'
GROUP BY e.ID_EMPRESA
ORDER BY e.NOMBRE_E");
$qEmpresas->execute();
$qEmpresas->bind_result($idEmpresa, $rutEmpresa, $nombre_empresa, $nbrEmpresa, $countExamenesConfigurados);
$qEmpresas->store_result();

ob_start();
?>

<div class="table-responsive">
  <table id="dataTable-empresas" class="table table-bordered">
    <thead>
      <tr>
        <th>RUT empresa</th>
        <th>Nombre empresa</th>
        <th>Abreviación</th>
        <th>Exámenes configurados</th>
        <th>Ver detalle</th>
        <th>Exportar PDF</th>
        <th>Exportar Excel</th>
      </tr>
    </thead>
    <tbody>
      <?php while ($qEmpresas->fetch()) { ?>
        <tr>
          <td><?= $rutEmpresa ?></td>
          <td><?= $nombre_empresa ?></td>
          <td><?= $nbrEmpresa ?></td>
          <td><?= $countExamenesConfigurados ?></td>
          <td class="text-center"><a href="preciosExamenesEmpresa.php?idEmpresa=<?= $idEmpresa ?>" class="btn btn-link"><i class="glyphicon glyphicon-search"></i></a></td>
          <td class="text-center"><a target="_blank" href="preciosExamenesEmpresa_pdf.php?idEmpresa=<?= $idEmpresa ?>" class="btn btn-link"><i class="fa fa-file-pdf-o fa-lg"></i></a></td>
          <td class="text-center"><a target="_blank" href="preciosExamenesEmpresa_excel.php?idEmpresa=<?= $idEmpresa ?>" class="btn btn-link"><i class="fa fa-file-excel-o fa-lg"></i></a></td>
        </tr>
      <?php } ?>
    </tbody>
  </table>
</div>
<?php
$contenido = ob_get_contents();
ob_end_clean();

$ui = new SmartUI;
$options = array("editbutton" => false);
$widget = $ui->create_widget($options);

$widget->header = array(
  "title" => $datos_pantallas[$pantalla_actual]['body_title'],
  "icon" => 'fa fa-cog',
  'toolbar' => array(
    array(
      "id" => "toolbar-id",
      "content" => '<a href="#"  data-toggle="modal" data-target="#myModalNew"></a>',
      "class" => 'smart-form'
    )
  )
);
$widget->body('content', $contenido);
?>

<div id="main" role="main">
  <?php
  //configure ribbon (breadcrumbs) array("name"=>"url"), leave url empty if no url
  //$breadcrumbs["New Crumb"] => "http://url.com"
  //$breadcrumbs["Consulta Atenciones"] = "../ConsultaAtenciones/mostrar_atV2.php";
  include("../inc/ribbon.php");

  ?>

  <div id="content">
    <?php
    $widget->print_html();
    ?>
  </div>
</div>

<?php
include("../inc/footer.php");
include("../inc/scripts.php");
?>

<script>
  $(document).ready(function() {
    $('#dataTable-empresas').DataTable({
      'lengthMenu': [
        [50, 100, 200, 500],
        [50, 100, 200, 500]
      ],
      "language": {
        "sProcessing": "Procesando...",
        "sZeroRecords": "No se encontraron resultados",
        "sInfoPostFix": "",
        "sUrl": "",
        "oPaginate": {
          "sFirst": "Primero",
          "sPrevious": "Anterior",
          "sNext": "Siguiente",
          "sLast": "Último"
        },
        "sInfo": "_START_ a _END_ de _TOTAL_ Registros",
        "sInfoEmpty": "0 Registros",
        "sInfoFiltered": "(de _MAX_ Registros en total)",
        "sLengthMenu": "Mostrar _MENU_ Registros",
        "sSearch": "Buscar: "
      },
      'pageLength': 50,
      "order": []
    });
  });
</script>

<?php
include("../inc/google-analytics.php");
?>