<?php
$pantalla_actual = 'VER_PRE_EXA';
define('PERMITIDO', true);
require_once("../inc/init.php");
require_once("../inc/config.ui.php");
$page_title = $datos_pantallas[$pantalla_actual]['page_title'];
$page_css[] = "your_style.css";
include("../inc/header.php");
include("../inc/nav.php");

$idEmpresa = isset($_GET['idEmpresa']) ? $_GET['idEmpresa'] : "-1";

$qEmpresas = $mysqli->prepare("SELECT NOMBRE_E, NBR FROM empresas WHERE ID_EMPRESA = ?");
$qEmpresas->bind_param("i", $idEmpresa);
$qEmpresas->execute();
$qEmpresas->bind_result($nombreEmpresa, $nbrEmpresa);
$qEmpresas->store_result();
$qEmpresas->fetch();
$qEmpresas->close();

$stmt = $mysqli->prepare("SELECT pe.COD_EXAMEN, pe.PRECIO, DATE_FORMAT(pe.FECHA_INICIO,'%d/%m/%Y %H:%i:%s') AS fechaInicio,
e.NOMBRE, e.NOMBRE_INF, e.COD_FONASA, e.NRO_HOJA_TRABAJO
FROM precios_examenes pe
INNER JOIN examenes e ON pe.COD_EXAMEN = e.COD_INTERNO
INNER JOIN (
  SELECT COD_EXAMEN, MAX(ID_PEX) AS MAX_ID_PEX
  FROM precios_examenes
  WHERE ID_EMPRESA = ?
  GROUP BY COD_EXAMEN
) max_pe ON pe.COD_EXAMEN = max_pe.COD_EXAMEN AND pe.ID_PEX = max_pe.MAX_ID_PEX
WHERE pe.ID_EMPRESA = ?
ORDER BY e.NOMBRE ASC");
$stmt->bind_param("ii", $idEmpresa, $idEmpresa);
$stmt->execute();
$result = $stmt->get_result();
$num_rows = $result->num_rows;
$rows = $result->fetch_all(MYSQLI_ASSOC); // Fetching all rows into an associative array
$result->free(); // Freeing result 
$stmt->close(); // Closing statement
ob_start();
?>

<div class="row">
  <section class="col-md-4 font-md">
    <p>Nombre Empresa: <?= $nombreEmpresa ?> </p>
    <p>Abreviado: <?= $nbrEmpresa ?> </p>
  </section>
  <section class="col-md-4 pull-right">
    <a target="_blank" href="preciosExamenesEmpresa_pdf.php?idEmpresa=<?= $idEmpresa ?>" class="btn btn-link"><i class="fa fa-file-pdf-o fa-lg"></i> Exportar PDF</a>
    <a target="_blank" href="preciosExamenesEmpresa_excel.php?idEmpresa=<?= $idEmpresa ?>" class="btn btn-link"><i class="fa fa-file-excel-o fa-lg"></i> Exportar Excel</a>
  </section>
</div>

<br>

<div class="table-responsive">
  <table id="dataTable-precios" class="table table-bordered">
    <thead>
      <tr>
        <th>Nombre examen</th>
        <th>Código Fonasa</th>
        <th>Precio examen</th>
        <th>Fecha última modificación</th>
        <th>Historial precios</th>
      </tr>
    </thead>
    <tbody>
      <?php foreach ($rows as $row) {
        $columnaNombre = $row["NOMBRE_INF"] != "" ? $row["NOMBRE_INF"] : $row["NOMBRE"];
        $columnaCodFonasa = $row["COD_FONASA"] != "" ? $row["COD_FONASA"] : "PARTICULAR";
        $esDerivacion = $row["NRO_HOJA_TRABAJO"] == 4 ? "(Derivación)" : "";
        $precioExamen = number_format($row["PRECIO"], 0, ',', '.');
      ?>
        <tr>
          <td><?= $columnaNombre ?></td>
          <td><?= $columnaCodFonasa ?></td>
          <td>$ <?= $precioExamen ?></td>
          <td><?= $row["fechaInicio"] ?></td>
          <td class="text-center">
            <a class='btn btn-link' href='md_historialPreciosExamen.php?codExamen=<?= $row["COD_EXAMEN"] ?>&idEmpresa=<?= $idEmpresa ?>' data-toggle='modal' data-target='#md_historialPreciosExamen'>
              <i class='fa fa-lg fa-list'> </i>
            </a>
          </td>
        </tr>
      <?php } ?>
    </tbody>
  </table>
</div>


<?php
$contenido = ob_get_contents();
ob_end_clean();

$ui = new SmartUI;
$options = array("editbutton" => false);
$widget = $ui->create_widget($options);

$widget->header = [
  "title" => $datos_pantallas[$pantalla_actual]['body_title'],
  "icon" => 'fa fa-cog',
  'toolbar' => [
    [
      "id" => "toolbar-id",
      "content" => "",
      "class" => "smart-form"
    ]
  ]
];
$widget->body('content', $contenido);

?>

<div id="main" role="main">
  <?php
  include("../inc/ribbon.php");
  ?>

  <div id="content">
    <?php
    $widget->print_html();
    ?>
  </div>
</div>

<div class="modal fade New" id="md_ingresarPrecioExamen" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
  <div class="modal-dialog">
    <div class="modal-content" style="width:120%">
    </div>
  </div>
</div>

<div class="modal fade New" id="md_historialPreciosExamen" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
  <div class="modal-dialog">
    <div class="modal-content" style="width:160%">
    </div>
  </div>
</div>

<div class="modal fade New" id="md_modificarPrecioExamen" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
  <div class="modal-dialog">
    <div class="modal-content" style="width:120%">
    </div>
  </div>
</div>

<?php
include("../inc/footer.php");
include("../inc/scripts.php");
?>

<script>
  $(document).ready(function() {
    $('#dataTable-precios').DataTable({
      'lengthMenu': [
        [50, 100, 200],
        [50, 100, 200]
      ],
      "language": {
        "sProcessing": "Procesando...",
        "sZeroRecords": "No se encontraron resultados",
        "sInfoPostFix": "",
        "sUrl": "",
        "oPaginate": {
          "sFirst": "Primero",
          "sPrevious": "Anterior",
          "sNext": "Siguiente",
          "sLast": "Último"
        },
        "sInfo": "_START_ a _END_ de _TOTAL_ Registros",
        "sInfoEmpty": "0 Registros",
        "sInfoFiltered": "(de _MAX_ Registros en total)",
        "sLengthMenu": "Mostrar _MENU_ Registros",
        "sSearch": "Buscar: "
      },
      'pageLength': 50,
      'order': [],
    });

    // $('.precioExamen').editable({
    //   url: 'sql_cod.php',
    //   type: 'number',
    //   name: "modificarPrecioExamen",
    //   title: 'Modificar Precio',
    //   success: function(response, newValue) {
    //     location.reload();
    //     exito();
    //   }
    // });
  });
</script>

<?php
include("../inc/google-analytics.php");
?>