<?php require_once('../Connections/conexionlab.php'); ?>
<?php include('../pdfClasses/class.ezpdf.php'); ?>
<?php
$pagina = 1;
define('PERMITIDO', true);
require_once("../inc/init.php");

$pdf = new Cezpdf('LETTER');
$pdf->selectFont('../pdfClasses/fonts/Helvetica.afm');
$pdf->ezStartPageNumbers(330, 18, 10, '', 'Página {PAGENUM} de {TOTALPAGENUM}', 1);
$pdf->ezSetCmMargins(1, 1.5, 1, 1.5);

$idEmpresa = isset($_GET['idEmpresa']) ? $_GET['idEmpresa'] : "-1";

$qEmpresas = $mysqli->prepare("SELECT NOMBRE_E, NBR FROM empresas WHERE ID_EMPRESA = ?");
$qEmpresas->bind_param("i", $idEmpresa);
$qEmpresas->execute();
$qEmpresas->bind_result($nombreEmpresa, $nbrEmpresa);
$qEmpresas->store_result();
$qEmpresas->fetch();
$qEmpresas->close();

$stmt = $mysqli->prepare("SELECT pe.COD_EXAMEN, pe.PRECIO, DATE_FORMAT(pe.FECHA_INICIO,'%d/%m/%Y %H:%i:%s') AS FECHA_INICIO,
e.NOMBRE, e.NOMBRE_INF, e.COD_FONASA, e.NRO_HOJA_TRABAJO
FROM precios_examenes pe
INNER JOIN examenes e ON pe.COD_EXAMEN = e.COD_INTERNO
INNER JOIN (
  SELECT COD_EXAMEN, MAX(ID_PEX) AS MAX_ID_PEX
  FROM precios_examenes
  WHERE ID_EMPRESA = ?
  GROUP BY COD_EXAMEN
) max_pe ON pe.COD_EXAMEN = max_pe.COD_EXAMEN AND pe.ID_PEX = max_pe.MAX_ID_PEX
WHERE pe.ID_EMPRESA = ?
ORDER BY e.NOMBRE ASC");
$stmt->bind_param("ii", $idEmpresa, $idEmpresa);
$stmt->execute();
$result = $stmt->get_result();
$num_rows = $result->num_rows;
$rows = $result->fetch_all(MYSQLI_ASSOC); // Fetching all rows into an associative array
$result->free(); // Freeing result 
$stmt->close(); // Closing statement

$data = array();
$i = 1;

foreach ($rows as $row) {
	$columnaNombre = $row["NOMBRE_INF"] != "" ? $row["NOMBRE_INF"] : $row["NOMBRE"];
	$columnaCodFonasa = $row["COD_FONASA"] != "" ? $row["COD_FONASA"] : "PARTICULAR";
	$esDerivacion = $row["NRO_HOJA_TRABAJO"] == 4 ? "(Derivación)" : "";
	$precioExamen = number_format($row["PRECIO"], 0, ',', '.');

	$data[] = array(
		'NRO' => $i,
		'NOMBRE' => $columnaNombre,
		'COD_FONASA' => $columnaCodFonasa,
		'DERIVACION' => $esDerivacion,
		'PRECIO' => $precioExamen
	);
	$i++;
}

$titles = array(
	'NRO' => '',
	'NOMBRE' => '<b>Nombre examen</b>',
	'COD_FONASA' => '<b>Cód. Fonasa</b>',
	'DERIVACION' => '',
	'PRECIO' => '<b>Precio ($)</b>'
);

$options = array(
	'shadeCol' => array(0.9, 0.9, 0.9),
	'showLines' => 1,
	'xOrientation' => 'center',
	'width' => 550,
	'cols' => array(
		'NRO' => array('justification' => 'left'),
		'NOMBRE' => array('justification' => 'left'),
		'COD_FONASA' => array('justification' => 'left'),
		'DERIVACION' => array('justification' => 'left'),
		'PRECIO' => array('justification' => 'right')
	)
);

$pdf->ezText("<b>Laboratorio $ps_nombreLab</b>\n", 12);
$pdf->ezText("Listado de precios de exámenes para empresa: $nombreEmpresa\n", 10);

$pdf->ezTable($data, $titles, '', $options);

ob_end_clean();
$pdf->ezStream();
?>
